// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Json;

public sealed partial class ClusterSearchStatusConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.ClusterSearchStatus>
{
	private static readonly System.Text.Json.JsonEncodedText MemberFailed = System.Text.Json.JsonEncodedText.Encode("failed");
	private static readonly System.Text.Json.JsonEncodedText MemberPartial = System.Text.Json.JsonEncodedText.Encode("partial");
	private static readonly System.Text.Json.JsonEncodedText MemberRunning = System.Text.Json.JsonEncodedText.Encode("running");
	private static readonly System.Text.Json.JsonEncodedText MemberSkipped = System.Text.Json.JsonEncodedText.Encode("skipped");
	private static readonly System.Text.Json.JsonEncodedText MemberSuccessful = System.Text.Json.JsonEncodedText.Encode("successful");

	public override Elastic.Clients.Elasticsearch.ClusterSearchStatus Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		if (reader.ValueTextEquals(MemberFailed))
		{
			return Elastic.Clients.Elasticsearch.ClusterSearchStatus.Failed;
		}

		if (reader.ValueTextEquals(MemberPartial))
		{
			return Elastic.Clients.Elasticsearch.ClusterSearchStatus.Partial;
		}

		if (reader.ValueTextEquals(MemberRunning))
		{
			return Elastic.Clients.Elasticsearch.ClusterSearchStatus.Running;
		}

		if (reader.ValueTextEquals(MemberSkipped))
		{
			return Elastic.Clients.Elasticsearch.ClusterSearchStatus.Skipped;
		}

		if (reader.ValueTextEquals(MemberSuccessful))
		{
			return Elastic.Clients.Elasticsearch.ClusterSearchStatus.Successful;
		}

		var value = reader.GetString()!;
		if (string.Equals(value, MemberFailed.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.ClusterSearchStatus.Failed;
		}

		if (string.Equals(value, MemberPartial.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.ClusterSearchStatus.Partial;
		}

		if (string.Equals(value, MemberRunning.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.ClusterSearchStatus.Running;
		}

		if (string.Equals(value, MemberSkipped.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.ClusterSearchStatus.Skipped;
		}

		if (string.Equals(value, MemberSuccessful.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.ClusterSearchStatus.Successful;
		}

		throw new System.Text.Json.JsonException($"Unknown member '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.ClusterSearchStatus)}'.");
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.ClusterSearchStatus value, System.Text.Json.JsonSerializerOptions options)
	{
		switch (value)
		{
			case Elastic.Clients.Elasticsearch.ClusterSearchStatus.Failed:
				writer.WriteStringValue(MemberFailed);
				break;
			case Elastic.Clients.Elasticsearch.ClusterSearchStatus.Partial:
				writer.WriteStringValue(MemberPartial);
				break;
			case Elastic.Clients.Elasticsearch.ClusterSearchStatus.Running:
				writer.WriteStringValue(MemberRunning);
				break;
			case Elastic.Clients.Elasticsearch.ClusterSearchStatus.Skipped:
				writer.WriteStringValue(MemberSkipped);
				break;
			case Elastic.Clients.Elasticsearch.ClusterSearchStatus.Successful:
				writer.WriteStringValue(MemberSuccessful);
				break;
			default:
				throw new System.Text.Json.JsonException($"Invalid value '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.ClusterSearchStatus)}'.");
		}
	}

	public override Elastic.Clients.Elasticsearch.ClusterSearchStatus ReadAsPropertyName(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		return Read(ref reader, typeToConvert, options);
	}

	public override void WriteAsPropertyName(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.ClusterSearchStatus value, System.Text.Json.JsonSerializerOptions options)
	{
		Write(writer, value, options);
	}
}