// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Json;

public sealed partial class ClusterInfoTargetConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.ClusterInfoTarget>
{
	private static readonly System.Text.Json.JsonEncodedText MemberAll = System.Text.Json.JsonEncodedText.Encode("_all");
	private static readonly System.Text.Json.JsonEncodedText MemberHttp = System.Text.Json.JsonEncodedText.Encode("http");
	private static readonly System.Text.Json.JsonEncodedText MemberIngest = System.Text.Json.JsonEncodedText.Encode("ingest");
	private static readonly System.Text.Json.JsonEncodedText MemberScript = System.Text.Json.JsonEncodedText.Encode("script");
	private static readonly System.Text.Json.JsonEncodedText MemberThreadPool = System.Text.Json.JsonEncodedText.Encode("thread_pool");

	public override Elastic.Clients.Elasticsearch.ClusterInfoTarget Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		if (reader.ValueTextEquals(MemberAll))
		{
			return Elastic.Clients.Elasticsearch.ClusterInfoTarget.All;
		}

		if (reader.ValueTextEquals(MemberHttp))
		{
			return Elastic.Clients.Elasticsearch.ClusterInfoTarget.Http;
		}

		if (reader.ValueTextEquals(MemberIngest))
		{
			return Elastic.Clients.Elasticsearch.ClusterInfoTarget.Ingest;
		}

		if (reader.ValueTextEquals(MemberScript))
		{
			return Elastic.Clients.Elasticsearch.ClusterInfoTarget.Script;
		}

		if (reader.ValueTextEquals(MemberThreadPool))
		{
			return Elastic.Clients.Elasticsearch.ClusterInfoTarget.ThreadPool;
		}

		var value = reader.GetString()!;
		if (string.Equals(value, MemberAll.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.ClusterInfoTarget.All;
		}

		if (string.Equals(value, MemberHttp.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.ClusterInfoTarget.Http;
		}

		if (string.Equals(value, MemberIngest.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.ClusterInfoTarget.Ingest;
		}

		if (string.Equals(value, MemberScript.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.ClusterInfoTarget.Script;
		}

		if (string.Equals(value, MemberThreadPool.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.ClusterInfoTarget.ThreadPool;
		}

		throw new System.Text.Json.JsonException($"Unknown member '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.ClusterInfoTarget)}'.");
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.ClusterInfoTarget value, System.Text.Json.JsonSerializerOptions options)
	{
		switch (value)
		{
			case Elastic.Clients.Elasticsearch.ClusterInfoTarget.All:
				writer.WriteStringValue(MemberAll);
				break;
			case Elastic.Clients.Elasticsearch.ClusterInfoTarget.Http:
				writer.WriteStringValue(MemberHttp);
				break;
			case Elastic.Clients.Elasticsearch.ClusterInfoTarget.Ingest:
				writer.WriteStringValue(MemberIngest);
				break;
			case Elastic.Clients.Elasticsearch.ClusterInfoTarget.Script:
				writer.WriteStringValue(MemberScript);
				break;
			case Elastic.Clients.Elasticsearch.ClusterInfoTarget.ThreadPool:
				writer.WriteStringValue(MemberThreadPool);
				break;
			default:
				throw new System.Text.Json.JsonException($"Invalid value '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.ClusterInfoTarget)}'.");
		}
	}

	public override Elastic.Clients.Elasticsearch.ClusterInfoTarget ReadAsPropertyName(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		return Read(ref reader, typeToConvert, options);
	}

	public override void WriteAsPropertyName(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.ClusterInfoTarget value, System.Text.Json.JsonSerializerOptions options)
	{
		Write(writer, value, options);
	}
}