// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Cluster.Json;

public sealed partial class UnassignedInformationReasonConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.Cluster.UnassignedInformationReason>
{
	private static readonly System.Text.Json.JsonEncodedText MemberAllocationFailed = System.Text.Json.JsonEncodedText.Encode("ALLOCATION_FAILED");
	private static readonly System.Text.Json.JsonEncodedText MemberClusterRecovered = System.Text.Json.JsonEncodedText.Encode("CLUSTER_RECOVERED");
	private static readonly System.Text.Json.JsonEncodedText MemberDanglingIndexImported = System.Text.Json.JsonEncodedText.Encode("DANGLING_INDEX_IMPORTED");
	private static readonly System.Text.Json.JsonEncodedText MemberExistingIndexRestored = System.Text.Json.JsonEncodedText.Encode("EXISTING_INDEX_RESTORED");
	private static readonly System.Text.Json.JsonEncodedText MemberForcedEmptyPrimary = System.Text.Json.JsonEncodedText.Encode("FORCED_EMPTY_PRIMARY");
	private static readonly System.Text.Json.JsonEncodedText MemberIndexCreated = System.Text.Json.JsonEncodedText.Encode("INDEX_CREATED");
	private static readonly System.Text.Json.JsonEncodedText MemberIndexReopened = System.Text.Json.JsonEncodedText.Encode("INDEX_REOPENED");
	private static readonly System.Text.Json.JsonEncodedText MemberManualAllocation = System.Text.Json.JsonEncodedText.Encode("MANUAL_ALLOCATION");
	private static readonly System.Text.Json.JsonEncodedText MemberNewIndexRestored = System.Text.Json.JsonEncodedText.Encode("NEW_INDEX_RESTORED");
	private static readonly System.Text.Json.JsonEncodedText MemberNodeLeft = System.Text.Json.JsonEncodedText.Encode("NODE_LEFT");
	private static readonly System.Text.Json.JsonEncodedText MemberPrimaryFailed = System.Text.Json.JsonEncodedText.Encode("PRIMARY_FAILED");
	private static readonly System.Text.Json.JsonEncodedText MemberReallocatedReplica = System.Text.Json.JsonEncodedText.Encode("REALLOCATED_REPLICA");
	private static readonly System.Text.Json.JsonEncodedText MemberReinitialized = System.Text.Json.JsonEncodedText.Encode("REINITIALIZED");
	private static readonly System.Text.Json.JsonEncodedText MemberReplicaAdded = System.Text.Json.JsonEncodedText.Encode("REPLICA_ADDED");
	private static readonly System.Text.Json.JsonEncodedText MemberRerouteCancelled = System.Text.Json.JsonEncodedText.Encode("REROUTE_CANCELLED");

	public override Elastic.Clients.Elasticsearch.Cluster.UnassignedInformationReason Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		if (reader.ValueTextEquals(MemberAllocationFailed))
		{
			return Elastic.Clients.Elasticsearch.Cluster.UnassignedInformationReason.AllocationFailed;
		}

		if (reader.ValueTextEquals(MemberClusterRecovered))
		{
			return Elastic.Clients.Elasticsearch.Cluster.UnassignedInformationReason.ClusterRecovered;
		}

		if (reader.ValueTextEquals(MemberDanglingIndexImported))
		{
			return Elastic.Clients.Elasticsearch.Cluster.UnassignedInformationReason.DanglingIndexImported;
		}

		if (reader.ValueTextEquals(MemberExistingIndexRestored))
		{
			return Elastic.Clients.Elasticsearch.Cluster.UnassignedInformationReason.ExistingIndexRestored;
		}

		if (reader.ValueTextEquals(MemberForcedEmptyPrimary))
		{
			return Elastic.Clients.Elasticsearch.Cluster.UnassignedInformationReason.ForcedEmptyPrimary;
		}

		if (reader.ValueTextEquals(MemberIndexCreated))
		{
			return Elastic.Clients.Elasticsearch.Cluster.UnassignedInformationReason.IndexCreated;
		}

		if (reader.ValueTextEquals(MemberIndexReopened))
		{
			return Elastic.Clients.Elasticsearch.Cluster.UnassignedInformationReason.IndexReopened;
		}

		if (reader.ValueTextEquals(MemberManualAllocation))
		{
			return Elastic.Clients.Elasticsearch.Cluster.UnassignedInformationReason.ManualAllocation;
		}

		if (reader.ValueTextEquals(MemberNewIndexRestored))
		{
			return Elastic.Clients.Elasticsearch.Cluster.UnassignedInformationReason.NewIndexRestored;
		}

		if (reader.ValueTextEquals(MemberNodeLeft))
		{
			return Elastic.Clients.Elasticsearch.Cluster.UnassignedInformationReason.NodeLeft;
		}

		if (reader.ValueTextEquals(MemberPrimaryFailed))
		{
			return Elastic.Clients.Elasticsearch.Cluster.UnassignedInformationReason.PrimaryFailed;
		}

		if (reader.ValueTextEquals(MemberReallocatedReplica))
		{
			return Elastic.Clients.Elasticsearch.Cluster.UnassignedInformationReason.ReallocatedReplica;
		}

		if (reader.ValueTextEquals(MemberReinitialized))
		{
			return Elastic.Clients.Elasticsearch.Cluster.UnassignedInformationReason.Reinitialized;
		}

		if (reader.ValueTextEquals(MemberReplicaAdded))
		{
			return Elastic.Clients.Elasticsearch.Cluster.UnassignedInformationReason.ReplicaAdded;
		}

		if (reader.ValueTextEquals(MemberRerouteCancelled))
		{
			return Elastic.Clients.Elasticsearch.Cluster.UnassignedInformationReason.RerouteCancelled;
		}

		var value = reader.GetString()!;
		if (string.Equals(value, MemberAllocationFailed.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Cluster.UnassignedInformationReason.AllocationFailed;
		}

		if (string.Equals(value, MemberClusterRecovered.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Cluster.UnassignedInformationReason.ClusterRecovered;
		}

		if (string.Equals(value, MemberDanglingIndexImported.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Cluster.UnassignedInformationReason.DanglingIndexImported;
		}

		if (string.Equals(value, MemberExistingIndexRestored.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Cluster.UnassignedInformationReason.ExistingIndexRestored;
		}

		if (string.Equals(value, MemberForcedEmptyPrimary.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Cluster.UnassignedInformationReason.ForcedEmptyPrimary;
		}

		if (string.Equals(value, MemberIndexCreated.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Cluster.UnassignedInformationReason.IndexCreated;
		}

		if (string.Equals(value, MemberIndexReopened.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Cluster.UnassignedInformationReason.IndexReopened;
		}

		if (string.Equals(value, MemberManualAllocation.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Cluster.UnassignedInformationReason.ManualAllocation;
		}

		if (string.Equals(value, MemberNewIndexRestored.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Cluster.UnassignedInformationReason.NewIndexRestored;
		}

		if (string.Equals(value, MemberNodeLeft.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Cluster.UnassignedInformationReason.NodeLeft;
		}

		if (string.Equals(value, MemberPrimaryFailed.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Cluster.UnassignedInformationReason.PrimaryFailed;
		}

		if (string.Equals(value, MemberReallocatedReplica.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Cluster.UnassignedInformationReason.ReallocatedReplica;
		}

		if (string.Equals(value, MemberReinitialized.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Cluster.UnassignedInformationReason.Reinitialized;
		}

		if (string.Equals(value, MemberReplicaAdded.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Cluster.UnassignedInformationReason.ReplicaAdded;
		}

		if (string.Equals(value, MemberRerouteCancelled.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Cluster.UnassignedInformationReason.RerouteCancelled;
		}

		throw new System.Text.Json.JsonException($"Unknown member '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.Cluster.UnassignedInformationReason)}'.");
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Cluster.UnassignedInformationReason value, System.Text.Json.JsonSerializerOptions options)
	{
		switch (value)
		{
			case Elastic.Clients.Elasticsearch.Cluster.UnassignedInformationReason.AllocationFailed:
				writer.WriteStringValue(MemberAllocationFailed);
				break;
			case Elastic.Clients.Elasticsearch.Cluster.UnassignedInformationReason.ClusterRecovered:
				writer.WriteStringValue(MemberClusterRecovered);
				break;
			case Elastic.Clients.Elasticsearch.Cluster.UnassignedInformationReason.DanglingIndexImported:
				writer.WriteStringValue(MemberDanglingIndexImported);
				break;
			case Elastic.Clients.Elasticsearch.Cluster.UnassignedInformationReason.ExistingIndexRestored:
				writer.WriteStringValue(MemberExistingIndexRestored);
				break;
			case Elastic.Clients.Elasticsearch.Cluster.UnassignedInformationReason.ForcedEmptyPrimary:
				writer.WriteStringValue(MemberForcedEmptyPrimary);
				break;
			case Elastic.Clients.Elasticsearch.Cluster.UnassignedInformationReason.IndexCreated:
				writer.WriteStringValue(MemberIndexCreated);
				break;
			case Elastic.Clients.Elasticsearch.Cluster.UnassignedInformationReason.IndexReopened:
				writer.WriteStringValue(MemberIndexReopened);
				break;
			case Elastic.Clients.Elasticsearch.Cluster.UnassignedInformationReason.ManualAllocation:
				writer.WriteStringValue(MemberManualAllocation);
				break;
			case Elastic.Clients.Elasticsearch.Cluster.UnassignedInformationReason.NewIndexRestored:
				writer.WriteStringValue(MemberNewIndexRestored);
				break;
			case Elastic.Clients.Elasticsearch.Cluster.UnassignedInformationReason.NodeLeft:
				writer.WriteStringValue(MemberNodeLeft);
				break;
			case Elastic.Clients.Elasticsearch.Cluster.UnassignedInformationReason.PrimaryFailed:
				writer.WriteStringValue(MemberPrimaryFailed);
				break;
			case Elastic.Clients.Elasticsearch.Cluster.UnassignedInformationReason.ReallocatedReplica:
				writer.WriteStringValue(MemberReallocatedReplica);
				break;
			case Elastic.Clients.Elasticsearch.Cluster.UnassignedInformationReason.Reinitialized:
				writer.WriteStringValue(MemberReinitialized);
				break;
			case Elastic.Clients.Elasticsearch.Cluster.UnassignedInformationReason.ReplicaAdded:
				writer.WriteStringValue(MemberReplicaAdded);
				break;
			case Elastic.Clients.Elasticsearch.Cluster.UnassignedInformationReason.RerouteCancelled:
				writer.WriteStringValue(MemberRerouteCancelled);
				break;
			default:
				throw new System.Text.Json.JsonException($"Invalid value '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.Cluster.UnassignedInformationReason)}'.");
		}
	}

	public override Elastic.Clients.Elasticsearch.Cluster.UnassignedInformationReason ReadAsPropertyName(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		return Read(ref reader, typeToConvert, options);
	}

	public override void WriteAsPropertyName(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Cluster.UnassignedInformationReason value, System.Text.Json.JsonSerializerOptions options)
	{
		Write(writer, value, options);
	}
}