// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Cluster.Json;

public sealed partial class UnassignedInformationConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.Cluster.UnassignedInformation>
{
	private static readonly System.Text.Json.JsonEncodedText PropAllocationStatus = System.Text.Json.JsonEncodedText.Encode("allocation_status");
	private static readonly System.Text.Json.JsonEncodedText PropAt = System.Text.Json.JsonEncodedText.Encode("at");
	private static readonly System.Text.Json.JsonEncodedText PropDelayed = System.Text.Json.JsonEncodedText.Encode("delayed");
	private static readonly System.Text.Json.JsonEncodedText PropDetails = System.Text.Json.JsonEncodedText.Encode("details");
	private static readonly System.Text.Json.JsonEncodedText PropFailedAllocationAttempts = System.Text.Json.JsonEncodedText.Encode("failed_allocation_attempts");
	private static readonly System.Text.Json.JsonEncodedText PropLastAllocationStatus = System.Text.Json.JsonEncodedText.Encode("last_allocation_status");
	private static readonly System.Text.Json.JsonEncodedText PropReason = System.Text.Json.JsonEncodedText.Encode("reason");

	public override Elastic.Clients.Elasticsearch.Cluster.UnassignedInformation Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		reader.ValidateToken(System.Text.Json.JsonTokenType.StartObject);
		LocalJsonValue<string?> propAllocationStatus = default;
		LocalJsonValue<System.DateTimeOffset> propAt = default;
		LocalJsonValue<bool?> propDelayed = default;
		LocalJsonValue<string?> propDetails = default;
		LocalJsonValue<int?> propFailedAllocationAttempts = default;
		LocalJsonValue<string?> propLastAllocationStatus = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.Cluster.UnassignedInformationReason> propReason = default;
		while (reader.Read() && reader.TokenType is System.Text.Json.JsonTokenType.PropertyName)
		{
			if (propAllocationStatus.TryReadProperty(ref reader, options, PropAllocationStatus, null))
			{
				continue;
			}

			if (propAt.TryReadProperty(ref reader, options, PropAt, static System.DateTimeOffset (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadValueEx<System.DateTimeOffset>(o, typeof(Elastic.Clients.Elasticsearch.Serialization.DateTimeMarker))))
			{
				continue;
			}

			if (propDelayed.TryReadProperty(ref reader, options, PropDelayed, static bool? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<bool>(o)))
			{
				continue;
			}

			if (propDetails.TryReadProperty(ref reader, options, PropDetails, null))
			{
				continue;
			}

			if (propFailedAllocationAttempts.TryReadProperty(ref reader, options, PropFailedAllocationAttempts, static int? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<int>(o)))
			{
				continue;
			}

			if (propLastAllocationStatus.TryReadProperty(ref reader, options, PropLastAllocationStatus, null))
			{
				continue;
			}

			if (propReason.TryReadProperty(ref reader, options, PropReason, null))
			{
				continue;
			}

			if (options.UnmappedMemberHandling is System.Text.Json.Serialization.JsonUnmappedMemberHandling.Skip)
			{
				reader.SafeSkip();
				continue;
			}

			throw new System.Text.Json.JsonException($"Unknown JSON property '{reader.GetString()}' for type '{typeToConvert.Name}'.");
		}

		reader.ValidateToken(System.Text.Json.JsonTokenType.EndObject);
		return new Elastic.Clients.Elasticsearch.Cluster.UnassignedInformation(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance)
		{
			AllocationStatus = propAllocationStatus.Value,
			At = propAt.Value,
			Delayed = propDelayed.Value,
			Details = propDetails.Value,
			FailedAllocationAttempts = propFailedAllocationAttempts.Value,
			LastAllocationStatus = propLastAllocationStatus.Value,
			Reason = propReason.Value
		};
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Cluster.UnassignedInformation value, System.Text.Json.JsonSerializerOptions options)
	{
		writer.WriteStartObject();
		writer.WriteProperty(options, PropAllocationStatus, value.AllocationStatus, null, null);
		writer.WriteProperty(options, PropAt, value.At, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, System.DateTimeOffset v) => w.WriteValueEx<System.DateTimeOffset>(o, v, typeof(Elastic.Clients.Elasticsearch.Serialization.DateTimeMarker)));
		writer.WriteProperty(options, PropDelayed, value.Delayed, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, bool? v) => w.WriteNullableValue<bool>(o, v));
		writer.WriteProperty(options, PropDetails, value.Details, null, null);
		writer.WriteProperty(options, PropFailedAllocationAttempts, value.FailedAllocationAttempts, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, int? v) => w.WriteNullableValue<int>(o, v));
		writer.WriteProperty(options, PropLastAllocationStatus, value.LastAllocationStatus, null, null);
		writer.WriteProperty(options, PropReason, value.Reason, null, null);
		writer.WriteEndObject();
	}
}