// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Cluster;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Cluster.Json.SnapshotCurrentCountsConverter))]
public sealed partial class SnapshotCurrentCounts
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public SnapshotCurrentCounts(int cleanups, int concurrentOperations, int shardSnapshots, int snapshotDeletions, int snapshots)
	{
		Cleanups = cleanups;
		ConcurrentOperations = concurrentOperations;
		ShardSnapshots = shardSnapshots;
		SnapshotDeletions = snapshotDeletions;
		Snapshots = snapshots;
	}
#if NET7_0_OR_GREATER
	public SnapshotCurrentCounts()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public SnapshotCurrentCounts()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal SnapshotCurrentCounts(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// Cleanups in progress, not counted in concurrent_operations as they are not concurrent
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	int Cleanups { get; set; }

	/// <summary>
	/// <para>
	/// Sum of snapshots and snapshot_deletions
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	int ConcurrentOperations { get; set; }

	/// <summary>
	/// <para>
	/// Incomplete shard snapshots
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	int ShardSnapshots { get; set; }

	/// <summary>
	/// <para>
	/// Snapshots deletions in progress
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	int SnapshotDeletions { get; set; }

	/// <summary>
	/// <para>
	/// Snapshots currently in progress
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	int Snapshots { get; set; }
}