// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Cluster.Json;

public sealed partial class SnapshotCurrentCountsConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.Cluster.SnapshotCurrentCounts>
{
	private static readonly System.Text.Json.JsonEncodedText PropCleanups = System.Text.Json.JsonEncodedText.Encode("cleanups");
	private static readonly System.Text.Json.JsonEncodedText PropConcurrentOperations = System.Text.Json.JsonEncodedText.Encode("concurrent_operations");
	private static readonly System.Text.Json.JsonEncodedText PropShardSnapshots = System.Text.Json.JsonEncodedText.Encode("shard_snapshots");
	private static readonly System.Text.Json.JsonEncodedText PropSnapshotDeletions = System.Text.Json.JsonEncodedText.Encode("snapshot_deletions");
	private static readonly System.Text.Json.JsonEncodedText PropSnapshots = System.Text.Json.JsonEncodedText.Encode("snapshots");

	public override Elastic.Clients.Elasticsearch.Cluster.SnapshotCurrentCounts Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		reader.ValidateToken(System.Text.Json.JsonTokenType.StartObject);
		LocalJsonValue<int> propCleanups = default;
		LocalJsonValue<int> propConcurrentOperations = default;
		LocalJsonValue<int> propShardSnapshots = default;
		LocalJsonValue<int> propSnapshotDeletions = default;
		LocalJsonValue<int> propSnapshots = default;
		while (reader.Read() && reader.TokenType is System.Text.Json.JsonTokenType.PropertyName)
		{
			if (propCleanups.TryReadProperty(ref reader, options, PropCleanups, null))
			{
				continue;
			}

			if (propConcurrentOperations.TryReadProperty(ref reader, options, PropConcurrentOperations, null))
			{
				continue;
			}

			if (propShardSnapshots.TryReadProperty(ref reader, options, PropShardSnapshots, null))
			{
				continue;
			}

			if (propSnapshotDeletions.TryReadProperty(ref reader, options, PropSnapshotDeletions, null))
			{
				continue;
			}

			if (propSnapshots.TryReadProperty(ref reader, options, PropSnapshots, null))
			{
				continue;
			}

			if (options.UnmappedMemberHandling is System.Text.Json.Serialization.JsonUnmappedMemberHandling.Skip)
			{
				reader.SafeSkip();
				continue;
			}

			throw new System.Text.Json.JsonException($"Unknown JSON property '{reader.GetString()}' for type '{typeToConvert.Name}'.");
		}

		reader.ValidateToken(System.Text.Json.JsonTokenType.EndObject);
		return new Elastic.Clients.Elasticsearch.Cluster.SnapshotCurrentCounts(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance)
		{
			Cleanups = propCleanups.Value,
			ConcurrentOperations = propConcurrentOperations.Value,
			ShardSnapshots = propShardSnapshots.Value,
			SnapshotDeletions = propSnapshotDeletions.Value,
			Snapshots = propSnapshots.Value
		};
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Cluster.SnapshotCurrentCounts value, System.Text.Json.JsonSerializerOptions options)
	{
		writer.WriteStartObject();
		writer.WriteProperty(options, PropCleanups, value.Cleanups, null, null);
		writer.WriteProperty(options, PropConcurrentOperations, value.ConcurrentOperations, null, null);
		writer.WriteProperty(options, PropShardSnapshots, value.ShardSnapshots, null, null);
		writer.WriteProperty(options, PropSnapshotDeletions, value.SnapshotDeletions, null, null);
		writer.WriteProperty(options, PropSnapshots, value.Snapshots, null, null);
		writer.WriteEndObject();
	}
}