// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Cluster.Json;

public sealed partial class ShardStateConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.Cluster.ShardState>
{
	private static readonly System.Text.Json.JsonEncodedText MemberAborted = System.Text.Json.JsonEncodedText.Encode("ABORTED");
	private static readonly System.Text.Json.JsonEncodedText MemberFailed = System.Text.Json.JsonEncodedText.Encode("FAILED");
	private static readonly System.Text.Json.JsonEncodedText MemberInit = System.Text.Json.JsonEncodedText.Encode("INIT");
	private static readonly System.Text.Json.JsonEncodedText MemberMissing = System.Text.Json.JsonEncodedText.Encode("MISSING");
	private static readonly System.Text.Json.JsonEncodedText MemberPausedForNodeRemoval = System.Text.Json.JsonEncodedText.Encode("PAUSED_FOR_NODE_REMOVAL");
	private static readonly System.Text.Json.JsonEncodedText MemberQueued = System.Text.Json.JsonEncodedText.Encode("QUEUED");
	private static readonly System.Text.Json.JsonEncodedText MemberSuccess = System.Text.Json.JsonEncodedText.Encode("SUCCESS");
	private static readonly System.Text.Json.JsonEncodedText MemberWaiting = System.Text.Json.JsonEncodedText.Encode("WAITING");

	public override Elastic.Clients.Elasticsearch.Cluster.ShardState Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		if (reader.ValueTextEquals(MemberAborted))
		{
			return Elastic.Clients.Elasticsearch.Cluster.ShardState.Aborted;
		}

		if (reader.ValueTextEquals(MemberFailed))
		{
			return Elastic.Clients.Elasticsearch.Cluster.ShardState.Failed;
		}

		if (reader.ValueTextEquals(MemberInit))
		{
			return Elastic.Clients.Elasticsearch.Cluster.ShardState.Init;
		}

		if (reader.ValueTextEquals(MemberMissing))
		{
			return Elastic.Clients.Elasticsearch.Cluster.ShardState.Missing;
		}

		if (reader.ValueTextEquals(MemberPausedForNodeRemoval))
		{
			return Elastic.Clients.Elasticsearch.Cluster.ShardState.PausedForNodeRemoval;
		}

		if (reader.ValueTextEquals(MemberQueued))
		{
			return Elastic.Clients.Elasticsearch.Cluster.ShardState.Queued;
		}

		if (reader.ValueTextEquals(MemberSuccess))
		{
			return Elastic.Clients.Elasticsearch.Cluster.ShardState.Success;
		}

		if (reader.ValueTextEquals(MemberWaiting))
		{
			return Elastic.Clients.Elasticsearch.Cluster.ShardState.Waiting;
		}

		var value = reader.GetString()!;
		if (string.Equals(value, MemberAborted.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Cluster.ShardState.Aborted;
		}

		if (string.Equals(value, MemberFailed.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Cluster.ShardState.Failed;
		}

		if (string.Equals(value, MemberInit.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Cluster.ShardState.Init;
		}

		if (string.Equals(value, MemberMissing.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Cluster.ShardState.Missing;
		}

		if (string.Equals(value, MemberPausedForNodeRemoval.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Cluster.ShardState.PausedForNodeRemoval;
		}

		if (string.Equals(value, MemberQueued.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Cluster.ShardState.Queued;
		}

		if (string.Equals(value, MemberSuccess.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Cluster.ShardState.Success;
		}

		if (string.Equals(value, MemberWaiting.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Cluster.ShardState.Waiting;
		}

		throw new System.Text.Json.JsonException($"Unknown member '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.Cluster.ShardState)}'.");
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Cluster.ShardState value, System.Text.Json.JsonSerializerOptions options)
	{
		switch (value)
		{
			case Elastic.Clients.Elasticsearch.Cluster.ShardState.Aborted:
				writer.WriteStringValue(MemberAborted);
				break;
			case Elastic.Clients.Elasticsearch.Cluster.ShardState.Failed:
				writer.WriteStringValue(MemberFailed);
				break;
			case Elastic.Clients.Elasticsearch.Cluster.ShardState.Init:
				writer.WriteStringValue(MemberInit);
				break;
			case Elastic.Clients.Elasticsearch.Cluster.ShardState.Missing:
				writer.WriteStringValue(MemberMissing);
				break;
			case Elastic.Clients.Elasticsearch.Cluster.ShardState.PausedForNodeRemoval:
				writer.WriteStringValue(MemberPausedForNodeRemoval);
				break;
			case Elastic.Clients.Elasticsearch.Cluster.ShardState.Queued:
				writer.WriteStringValue(MemberQueued);
				break;
			case Elastic.Clients.Elasticsearch.Cluster.ShardState.Success:
				writer.WriteStringValue(MemberSuccess);
				break;
			case Elastic.Clients.Elasticsearch.Cluster.ShardState.Waiting:
				writer.WriteStringValue(MemberWaiting);
				break;
			default:
				throw new System.Text.Json.JsonException($"Invalid value '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.Cluster.ShardState)}'.");
		}
	}

	public override Elastic.Clients.Elasticsearch.Cluster.ShardState ReadAsPropertyName(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		return Read(ref reader, typeToConvert, options);
	}

	public override void WriteAsPropertyName(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Cluster.ShardState value, System.Text.Json.JsonSerializerOptions options)
	{
		Write(writer, value, options);
	}
}