// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Cluster.Json;

public sealed partial class RuntimeFieldTypesConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.Cluster.RuntimeFieldTypes>
{
	private static readonly System.Text.Json.JsonEncodedText PropCharsMax = System.Text.Json.JsonEncodedText.Encode("chars_max");
	private static readonly System.Text.Json.JsonEncodedText PropCharsTotal = System.Text.Json.JsonEncodedText.Encode("chars_total");
	private static readonly System.Text.Json.JsonEncodedText PropCount = System.Text.Json.JsonEncodedText.Encode("count");
	private static readonly System.Text.Json.JsonEncodedText PropDocMax = System.Text.Json.JsonEncodedText.Encode("doc_max");
	private static readonly System.Text.Json.JsonEncodedText PropDocTotal = System.Text.Json.JsonEncodedText.Encode("doc_total");
	private static readonly System.Text.Json.JsonEncodedText PropIndexCount = System.Text.Json.JsonEncodedText.Encode("index_count");
	private static readonly System.Text.Json.JsonEncodedText PropLang = System.Text.Json.JsonEncodedText.Encode("lang");
	private static readonly System.Text.Json.JsonEncodedText PropLinesMax = System.Text.Json.JsonEncodedText.Encode("lines_max");
	private static readonly System.Text.Json.JsonEncodedText PropLinesTotal = System.Text.Json.JsonEncodedText.Encode("lines_total");
	private static readonly System.Text.Json.JsonEncodedText PropName = System.Text.Json.JsonEncodedText.Encode("name");
	private static readonly System.Text.Json.JsonEncodedText PropScriptlessCount = System.Text.Json.JsonEncodedText.Encode("scriptless_count");
	private static readonly System.Text.Json.JsonEncodedText PropShadowedCount = System.Text.Json.JsonEncodedText.Encode("shadowed_count");
	private static readonly System.Text.Json.JsonEncodedText PropSourceMax = System.Text.Json.JsonEncodedText.Encode("source_max");
	private static readonly System.Text.Json.JsonEncodedText PropSourceTotal = System.Text.Json.JsonEncodedText.Encode("source_total");

	public override Elastic.Clients.Elasticsearch.Cluster.RuntimeFieldTypes Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		reader.ValidateToken(System.Text.Json.JsonTokenType.StartObject);
		LocalJsonValue<int> propCharsMax = default;
		LocalJsonValue<int> propCharsTotal = default;
		LocalJsonValue<int> propCount = default;
		LocalJsonValue<int> propDocMax = default;
		LocalJsonValue<int> propDocTotal = default;
		LocalJsonValue<int> propIndexCount = default;
		LocalJsonValue<System.Collections.Generic.IReadOnlyCollection<string>> propLang = default;
		LocalJsonValue<int> propLinesMax = default;
		LocalJsonValue<int> propLinesTotal = default;
		LocalJsonValue<string> propName = default;
		LocalJsonValue<int> propScriptlessCount = default;
		LocalJsonValue<int> propShadowedCount = default;
		LocalJsonValue<int> propSourceMax = default;
		LocalJsonValue<int> propSourceTotal = default;
		while (reader.Read() && reader.TokenType is System.Text.Json.JsonTokenType.PropertyName)
		{
			if (propCharsMax.TryReadProperty(ref reader, options, PropCharsMax, null))
			{
				continue;
			}

			if (propCharsTotal.TryReadProperty(ref reader, options, PropCharsTotal, null))
			{
				continue;
			}

			if (propCount.TryReadProperty(ref reader, options, PropCount, null))
			{
				continue;
			}

			if (propDocMax.TryReadProperty(ref reader, options, PropDocMax, null))
			{
				continue;
			}

			if (propDocTotal.TryReadProperty(ref reader, options, PropDocTotal, null))
			{
				continue;
			}

			if (propIndexCount.TryReadProperty(ref reader, options, PropIndexCount, null))
			{
				continue;
			}

			if (propLang.TryReadProperty(ref reader, options, PropLang, static System.Collections.Generic.IReadOnlyCollection<string> (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadCollectionValue<string>(o, null)!))
			{
				continue;
			}

			if (propLinesMax.TryReadProperty(ref reader, options, PropLinesMax, null))
			{
				continue;
			}

			if (propLinesTotal.TryReadProperty(ref reader, options, PropLinesTotal, null))
			{
				continue;
			}

			if (propName.TryReadProperty(ref reader, options, PropName, null))
			{
				continue;
			}

			if (propScriptlessCount.TryReadProperty(ref reader, options, PropScriptlessCount, null))
			{
				continue;
			}

			if (propShadowedCount.TryReadProperty(ref reader, options, PropShadowedCount, null))
			{
				continue;
			}

			if (propSourceMax.TryReadProperty(ref reader, options, PropSourceMax, null))
			{
				continue;
			}

			if (propSourceTotal.TryReadProperty(ref reader, options, PropSourceTotal, null))
			{
				continue;
			}

			if (options.UnmappedMemberHandling is System.Text.Json.Serialization.JsonUnmappedMemberHandling.Skip)
			{
				reader.SafeSkip();
				continue;
			}

			throw new System.Text.Json.JsonException($"Unknown JSON property '{reader.GetString()}' for type '{typeToConvert.Name}'.");
		}

		reader.ValidateToken(System.Text.Json.JsonTokenType.EndObject);
		return new Elastic.Clients.Elasticsearch.Cluster.RuntimeFieldTypes(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance)
		{
			CharsMax = propCharsMax.Value,
			CharsTotal = propCharsTotal.Value,
			Count = propCount.Value,
			DocMax = propDocMax.Value,
			DocTotal = propDocTotal.Value,
			IndexCount = propIndexCount.Value,
			Lang = propLang.Value,
			LinesMax = propLinesMax.Value,
			LinesTotal = propLinesTotal.Value,
			Name = propName.Value,
			ScriptlessCount = propScriptlessCount.Value,
			ShadowedCount = propShadowedCount.Value,
			SourceMax = propSourceMax.Value,
			SourceTotal = propSourceTotal.Value
		};
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Cluster.RuntimeFieldTypes value, System.Text.Json.JsonSerializerOptions options)
	{
		writer.WriteStartObject();
		writer.WriteProperty(options, PropCharsMax, value.CharsMax, null, null);
		writer.WriteProperty(options, PropCharsTotal, value.CharsTotal, null, null);
		writer.WriteProperty(options, PropCount, value.Count, null, null);
		writer.WriteProperty(options, PropDocMax, value.DocMax, null, null);
		writer.WriteProperty(options, PropDocTotal, value.DocTotal, null, null);
		writer.WriteProperty(options, PropIndexCount, value.IndexCount, null, null);
		writer.WriteProperty(options, PropLang, value.Lang, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, System.Collections.Generic.IReadOnlyCollection<string> v) => w.WriteCollectionValue<string>(o, v, null));
		writer.WriteProperty(options, PropLinesMax, value.LinesMax, null, null);
		writer.WriteProperty(options, PropLinesTotal, value.LinesTotal, null, null);
		writer.WriteProperty(options, PropName, value.Name, null, null);
		writer.WriteProperty(options, PropScriptlessCount, value.ScriptlessCount, null, null);
		writer.WriteProperty(options, PropShadowedCount, value.ShadowedCount, null, null);
		writer.WriteProperty(options, PropSourceMax, value.SourceMax, null, null);
		writer.WriteProperty(options, PropSourceTotal, value.SourceTotal, null, null);
		writer.WriteEndObject();
	}
}