// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Cluster.Json;

public sealed partial class RepositoryStatsShardsConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.Cluster.RepositoryStatsShards>
{
	private static readonly System.Text.Json.JsonEncodedText PropComplete = System.Text.Json.JsonEncodedText.Encode("complete");
	private static readonly System.Text.Json.JsonEncodedText PropIncomplete = System.Text.Json.JsonEncodedText.Encode("incomplete");
	private static readonly System.Text.Json.JsonEncodedText PropStates = System.Text.Json.JsonEncodedText.Encode("states");
	private static readonly System.Text.Json.JsonEncodedText PropTotal = System.Text.Json.JsonEncodedText.Encode("total");

	public override Elastic.Clients.Elasticsearch.Cluster.RepositoryStatsShards Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		reader.ValidateToken(System.Text.Json.JsonTokenType.StartObject);
		LocalJsonValue<int> propComplete = default;
		LocalJsonValue<int> propIncomplete = default;
		LocalJsonValue<System.Collections.Generic.IReadOnlyDictionary<Elastic.Clients.Elasticsearch.Cluster.ShardState, int>> propStates = default;
		LocalJsonValue<int> propTotal = default;
		while (reader.Read() && reader.TokenType is System.Text.Json.JsonTokenType.PropertyName)
		{
			if (propComplete.TryReadProperty(ref reader, options, PropComplete, null))
			{
				continue;
			}

			if (propIncomplete.TryReadProperty(ref reader, options, PropIncomplete, null))
			{
				continue;
			}

			if (propStates.TryReadProperty(ref reader, options, PropStates, static System.Collections.Generic.IReadOnlyDictionary<Elastic.Clients.Elasticsearch.Cluster.ShardState, int> (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadDictionaryValue<Elastic.Clients.Elasticsearch.Cluster.ShardState, int>(o, null, null)!))
			{
				continue;
			}

			if (propTotal.TryReadProperty(ref reader, options, PropTotal, null))
			{
				continue;
			}

			if (options.UnmappedMemberHandling is System.Text.Json.Serialization.JsonUnmappedMemberHandling.Skip)
			{
				reader.SafeSkip();
				continue;
			}

			throw new System.Text.Json.JsonException($"Unknown JSON property '{reader.GetString()}' for type '{typeToConvert.Name}'.");
		}

		reader.ValidateToken(System.Text.Json.JsonTokenType.EndObject);
		return new Elastic.Clients.Elasticsearch.Cluster.RepositoryStatsShards(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance)
		{
			Complete = propComplete.Value,
			Incomplete = propIncomplete.Value,
			States = propStates.Value,
			Total = propTotal.Value
		};
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Cluster.RepositoryStatsShards value, System.Text.Json.JsonSerializerOptions options)
	{
		writer.WriteStartObject();
		writer.WriteProperty(options, PropComplete, value.Complete, null, null);
		writer.WriteProperty(options, PropIncomplete, value.Incomplete, null, null);
		writer.WriteProperty(options, PropStates, value.States, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, System.Collections.Generic.IReadOnlyDictionary<Elastic.Clients.Elasticsearch.Cluster.ShardState, int> v) => w.WriteDictionaryValue<Elastic.Clients.Elasticsearch.Cluster.ShardState, int>(o, v, null, null));
		writer.WriteProperty(options, PropTotal, value.Total, null, null);
		writer.WriteEndObject();
	}
}