// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Cluster.Json;

public sealed partial class RepositoryStatsCurrentCountsConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.Cluster.RepositoryStatsCurrentCounts>
{
	private static readonly System.Text.Json.JsonEncodedText PropActiveDeletions = System.Text.Json.JsonEncodedText.Encode("active_deletions");
	private static readonly System.Text.Json.JsonEncodedText PropClones = System.Text.Json.JsonEncodedText.Encode("clones");
	private static readonly System.Text.Json.JsonEncodedText PropDeletions = System.Text.Json.JsonEncodedText.Encode("deletions");
	private static readonly System.Text.Json.JsonEncodedText PropFinalizations = System.Text.Json.JsonEncodedText.Encode("finalizations");
	private static readonly System.Text.Json.JsonEncodedText PropShards = System.Text.Json.JsonEncodedText.Encode("shards");
	private static readonly System.Text.Json.JsonEncodedText PropSnapshotDeletions = System.Text.Json.JsonEncodedText.Encode("snapshot_deletions");
	private static readonly System.Text.Json.JsonEncodedText PropSnapshots = System.Text.Json.JsonEncodedText.Encode("snapshots");

	public override Elastic.Clients.Elasticsearch.Cluster.RepositoryStatsCurrentCounts Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		reader.ValidateToken(System.Text.Json.JsonTokenType.StartObject);
		LocalJsonValue<int> propActiveDeletions = default;
		LocalJsonValue<int> propClones = default;
		LocalJsonValue<int> propDeletions = default;
		LocalJsonValue<int> propFinalizations = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.Cluster.RepositoryStatsShards> propShards = default;
		LocalJsonValue<int> propSnapshotDeletions = default;
		LocalJsonValue<int> propSnapshots = default;
		while (reader.Read() && reader.TokenType is System.Text.Json.JsonTokenType.PropertyName)
		{
			if (propActiveDeletions.TryReadProperty(ref reader, options, PropActiveDeletions, null))
			{
				continue;
			}

			if (propClones.TryReadProperty(ref reader, options, PropClones, null))
			{
				continue;
			}

			if (propDeletions.TryReadProperty(ref reader, options, PropDeletions, null))
			{
				continue;
			}

			if (propFinalizations.TryReadProperty(ref reader, options, PropFinalizations, null))
			{
				continue;
			}

			if (propShards.TryReadProperty(ref reader, options, PropShards, null))
			{
				continue;
			}

			if (propSnapshotDeletions.TryReadProperty(ref reader, options, PropSnapshotDeletions, null))
			{
				continue;
			}

			if (propSnapshots.TryReadProperty(ref reader, options, PropSnapshots, null))
			{
				continue;
			}

			if (options.UnmappedMemberHandling is System.Text.Json.Serialization.JsonUnmappedMemberHandling.Skip)
			{
				reader.SafeSkip();
				continue;
			}

			throw new System.Text.Json.JsonException($"Unknown JSON property '{reader.GetString()}' for type '{typeToConvert.Name}'.");
		}

		reader.ValidateToken(System.Text.Json.JsonTokenType.EndObject);
		return new Elastic.Clients.Elasticsearch.Cluster.RepositoryStatsCurrentCounts(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance)
		{
			ActiveDeletions = propActiveDeletions.Value,
			Clones = propClones.Value,
			Deletions = propDeletions.Value,
			Finalizations = propFinalizations.Value,
			Shards = propShards.Value,
			SnapshotDeletions = propSnapshotDeletions.Value,
			Snapshots = propSnapshots.Value
		};
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Cluster.RepositoryStatsCurrentCounts value, System.Text.Json.JsonSerializerOptions options)
	{
		writer.WriteStartObject();
		writer.WriteProperty(options, PropActiveDeletions, value.ActiveDeletions, null, null);
		writer.WriteProperty(options, PropClones, value.Clones, null, null);
		writer.WriteProperty(options, PropDeletions, value.Deletions, null, null);
		writer.WriteProperty(options, PropFinalizations, value.Finalizations, null, null);
		writer.WriteProperty(options, PropShards, value.Shards, null, null);
		writer.WriteProperty(options, PropSnapshotDeletions, value.SnapshotDeletions, null, null);
		writer.WriteProperty(options, PropSnapshots, value.Snapshots, null, null);
		writer.WriteEndObject();
	}
}