// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Cluster;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Cluster.Json.RemoteClusterInfoConverter))]
public sealed partial class RemoteClusterInfo
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public RemoteClusterInfo(string clusterUuid, int indicesCount, long indicesTotalSizeInBytes, long maxHeapInBytes, long memTotalInBytes, string mode, int nodesCount, int shardsCount, bool skipUnavailable, Elastic.Clients.Elasticsearch.HealthStatus status, string transportCompress, System.Collections.Generic.IReadOnlyCollection<string> version)
	{
		ClusterUuid = clusterUuid;
		IndicesCount = indicesCount;
		IndicesTotalSizeInBytes = indicesTotalSizeInBytes;
		MaxHeapInBytes = maxHeapInBytes;
		MemTotalInBytes = memTotalInBytes;
		Mode = mode;
		NodesCount = nodesCount;
		ShardsCount = shardsCount;
		SkipUnavailable = skipUnavailable;
		Status = status;
		TransportCompress = transportCompress;
		Version = version;
	}
#if NET7_0_OR_GREATER
	public RemoteClusterInfo()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public RemoteClusterInfo()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal RemoteClusterInfo(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// The UUID of the remote cluster.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	string ClusterUuid { get; set; }

	/// <summary>
	/// <para>
	/// The total number of indices in the remote cluster.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	int IndicesCount { get; set; }

	/// <summary>
	/// <para>
	/// Total data set size of all shards assigned to selected nodes, as a human-readable string.
	/// </para>
	/// </summary>
	public string? IndicesTotalSize { get; set; }

	/// <summary>
	/// <para>
	/// Total data set size, in bytes, of all shards assigned to selected nodes.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	long IndicesTotalSizeInBytes { get; set; }

	/// <summary>
	/// <para>
	/// Maximum amount of memory available for use by the heap across the nodes of the remote cluster, as a human-readable string.
	/// </para>
	/// </summary>
	public string? MaxHeap { get; set; }

	/// <summary>
	/// <para>
	/// Maximum amount of memory, in bytes, available for use by the heap across the nodes of the remote cluster.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	long MaxHeapInBytes { get; set; }

	/// <summary>
	/// <para>
	/// Total amount of physical memory across the nodes of the remote cluster, as a human-readable string.
	/// </para>
	/// </summary>
	public string? MemTotal { get; set; }

	/// <summary>
	/// <para>
	/// Total amount, in bytes, of physical memory across the nodes of the remote cluster.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	long MemTotalInBytes { get; set; }

	/// <summary>
	/// <para>
	/// The connection mode used to communicate with the remote cluster.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	string Mode { get; set; }

	/// <summary>
	/// <para>
	/// The total count of nodes in the remote cluster.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	int NodesCount { get; set; }

	/// <summary>
	/// <para>
	/// The total number of shards in the remote cluster.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	int ShardsCount { get; set; }

	/// <summary>
	/// <para>
	/// The <c>skip_unavailable</c> setting used for this remote cluster.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	bool SkipUnavailable { get; set; }

	/// <summary>
	/// <para>
	/// Health status of the cluster, based on the state of its primary and replica shards.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.HealthStatus Status { get; set; }

	/// <summary>
	/// <para>
	/// Transport compression setting used for this remote cluster.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	string TransportCompress { get; set; }

	/// <summary>
	/// <para>
	/// The list of Elasticsearch versions used by the nodes on the remote cluster.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	System.Collections.Generic.IReadOnlyCollection<string> Version { get; set; }
}