// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Cluster.Json;

public sealed partial class RemoteClusterInfoConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.Cluster.RemoteClusterInfo>
{
	private static readonly System.Text.Json.JsonEncodedText PropClusterUuid = System.Text.Json.JsonEncodedText.Encode("cluster_uuid");
	private static readonly System.Text.Json.JsonEncodedText PropIndicesCount = System.Text.Json.JsonEncodedText.Encode("indices_count");
	private static readonly System.Text.Json.JsonEncodedText PropIndicesTotalSize = System.Text.Json.JsonEncodedText.Encode("indices_total_size");
	private static readonly System.Text.Json.JsonEncodedText PropIndicesTotalSizeInBytes = System.Text.Json.JsonEncodedText.Encode("indices_total_size_in_bytes");
	private static readonly System.Text.Json.JsonEncodedText PropMaxHeap = System.Text.Json.JsonEncodedText.Encode("max_heap");
	private static readonly System.Text.Json.JsonEncodedText PropMaxHeapInBytes = System.Text.Json.JsonEncodedText.Encode("max_heap_in_bytes");
	private static readonly System.Text.Json.JsonEncodedText PropMemTotal = System.Text.Json.JsonEncodedText.Encode("mem_total");
	private static readonly System.Text.Json.JsonEncodedText PropMemTotalInBytes = System.Text.Json.JsonEncodedText.Encode("mem_total_in_bytes");
	private static readonly System.Text.Json.JsonEncodedText PropMode = System.Text.Json.JsonEncodedText.Encode("mode");
	private static readonly System.Text.Json.JsonEncodedText PropNodesCount = System.Text.Json.JsonEncodedText.Encode("nodes_count");
	private static readonly System.Text.Json.JsonEncodedText PropShardsCount = System.Text.Json.JsonEncodedText.Encode("shards_count");
	private static readonly System.Text.Json.JsonEncodedText PropSkipUnavailable = System.Text.Json.JsonEncodedText.Encode("skip_unavailable");
	private static readonly System.Text.Json.JsonEncodedText PropStatus = System.Text.Json.JsonEncodedText.Encode("status");
	private static readonly System.Text.Json.JsonEncodedText PropTransportCompress = System.Text.Json.JsonEncodedText.Encode("transport.compress");
	private static readonly System.Text.Json.JsonEncodedText PropVersion = System.Text.Json.JsonEncodedText.Encode("version");

	public override Elastic.Clients.Elasticsearch.Cluster.RemoteClusterInfo Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		reader.ValidateToken(System.Text.Json.JsonTokenType.StartObject);
		LocalJsonValue<string> propClusterUuid = default;
		LocalJsonValue<int> propIndicesCount = default;
		LocalJsonValue<string?> propIndicesTotalSize = default;
		LocalJsonValue<long> propIndicesTotalSizeInBytes = default;
		LocalJsonValue<string?> propMaxHeap = default;
		LocalJsonValue<long> propMaxHeapInBytes = default;
		LocalJsonValue<string?> propMemTotal = default;
		LocalJsonValue<long> propMemTotalInBytes = default;
		LocalJsonValue<string> propMode = default;
		LocalJsonValue<int> propNodesCount = default;
		LocalJsonValue<int> propShardsCount = default;
		LocalJsonValue<bool> propSkipUnavailable = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.HealthStatus> propStatus = default;
		LocalJsonValue<string> propTransportCompress = default;
		LocalJsonValue<System.Collections.Generic.IReadOnlyCollection<string>> propVersion = default;
		while (reader.Read() && reader.TokenType is System.Text.Json.JsonTokenType.PropertyName)
		{
			if (propClusterUuid.TryReadProperty(ref reader, options, PropClusterUuid, null))
			{
				continue;
			}

			if (propIndicesCount.TryReadProperty(ref reader, options, PropIndicesCount, null))
			{
				continue;
			}

			if (propIndicesTotalSize.TryReadProperty(ref reader, options, PropIndicesTotalSize, null))
			{
				continue;
			}

			if (propIndicesTotalSizeInBytes.TryReadProperty(ref reader, options, PropIndicesTotalSizeInBytes, null))
			{
				continue;
			}

			if (propMaxHeap.TryReadProperty(ref reader, options, PropMaxHeap, null))
			{
				continue;
			}

			if (propMaxHeapInBytes.TryReadProperty(ref reader, options, PropMaxHeapInBytes, null))
			{
				continue;
			}

			if (propMemTotal.TryReadProperty(ref reader, options, PropMemTotal, null))
			{
				continue;
			}

			if (propMemTotalInBytes.TryReadProperty(ref reader, options, PropMemTotalInBytes, null))
			{
				continue;
			}

			if (propMode.TryReadProperty(ref reader, options, PropMode, null))
			{
				continue;
			}

			if (propNodesCount.TryReadProperty(ref reader, options, PropNodesCount, null))
			{
				continue;
			}

			if (propShardsCount.TryReadProperty(ref reader, options, PropShardsCount, null))
			{
				continue;
			}

			if (propSkipUnavailable.TryReadProperty(ref reader, options, PropSkipUnavailable, null))
			{
				continue;
			}

			if (propStatus.TryReadProperty(ref reader, options, PropStatus, null))
			{
				continue;
			}

			if (propTransportCompress.TryReadProperty(ref reader, options, PropTransportCompress, null))
			{
				continue;
			}

			if (propVersion.TryReadProperty(ref reader, options, PropVersion, static System.Collections.Generic.IReadOnlyCollection<string> (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadCollectionValue<string>(o, null)!))
			{
				continue;
			}

			if (options.UnmappedMemberHandling is System.Text.Json.Serialization.JsonUnmappedMemberHandling.Skip)
			{
				reader.SafeSkip();
				continue;
			}

			throw new System.Text.Json.JsonException($"Unknown JSON property '{reader.GetString()}' for type '{typeToConvert.Name}'.");
		}

		reader.ValidateToken(System.Text.Json.JsonTokenType.EndObject);
		return new Elastic.Clients.Elasticsearch.Cluster.RemoteClusterInfo(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance)
		{
			ClusterUuid = propClusterUuid.Value,
			IndicesCount = propIndicesCount.Value,
			IndicesTotalSize = propIndicesTotalSize.Value,
			IndicesTotalSizeInBytes = propIndicesTotalSizeInBytes.Value,
			MaxHeap = propMaxHeap.Value,
			MaxHeapInBytes = propMaxHeapInBytes.Value,
			MemTotal = propMemTotal.Value,
			MemTotalInBytes = propMemTotalInBytes.Value,
			Mode = propMode.Value,
			NodesCount = propNodesCount.Value,
			ShardsCount = propShardsCount.Value,
			SkipUnavailable = propSkipUnavailable.Value,
			Status = propStatus.Value,
			TransportCompress = propTransportCompress.Value,
			Version = propVersion.Value
		};
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Cluster.RemoteClusterInfo value, System.Text.Json.JsonSerializerOptions options)
	{
		writer.WriteStartObject();
		writer.WriteProperty(options, PropClusterUuid, value.ClusterUuid, null, null);
		writer.WriteProperty(options, PropIndicesCount, value.IndicesCount, null, null);
		writer.WriteProperty(options, PropIndicesTotalSize, value.IndicesTotalSize, null, null);
		writer.WriteProperty(options, PropIndicesTotalSizeInBytes, value.IndicesTotalSizeInBytes, null, null);
		writer.WriteProperty(options, PropMaxHeap, value.MaxHeap, null, null);
		writer.WriteProperty(options, PropMaxHeapInBytes, value.MaxHeapInBytes, null, null);
		writer.WriteProperty(options, PropMemTotal, value.MemTotal, null, null);
		writer.WriteProperty(options, PropMemTotalInBytes, value.MemTotalInBytes, null, null);
		writer.WriteProperty(options, PropMode, value.Mode, null, null);
		writer.WriteProperty(options, PropNodesCount, value.NodesCount, null, null);
		writer.WriteProperty(options, PropShardsCount, value.ShardsCount, null, null);
		writer.WriteProperty(options, PropSkipUnavailable, value.SkipUnavailable, null, null);
		writer.WriteProperty(options, PropStatus, value.Status, null, null);
		writer.WriteProperty(options, PropTransportCompress, value.TransportCompress, null, null);
		writer.WriteProperty(options, PropVersion, value.Version, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, System.Collections.Generic.IReadOnlyCollection<string> v) => w.WriteCollectionValue<string>(o, v, null));
		writer.WriteEndObject();
	}
}