// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Cluster;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Cluster.Json.PendingTaskConverter))]
public sealed partial class PendingTask
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public PendingTask(bool executing, int insertOrder, string priority, string source, System.TimeSpan timeInQueueMillis)
	{
		Executing = executing;
		InsertOrder = insertOrder;
		Priority = priority;
		Source = source;
		TimeInQueueMillis = timeInQueueMillis;
	}
#if NET7_0_OR_GREATER
	public PendingTask()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public PendingTask()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal PendingTask(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// Indicates whether the pending tasks are currently executing or not.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	bool Executing { get; set; }

	/// <summary>
	/// <para>
	/// The number that represents when the task has been inserted into the task queue.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	int InsertOrder { get; set; }

	/// <summary>
	/// <para>
	/// The priority of the pending task.
	/// The valid priorities in descending priority order are: <c>IMMEDIATE</c> > <c>URGENT</c> > <c>HIGH</c> > <c>NORMAL</c> > <c>LOW</c> > <c>LANGUID</c>.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	string Priority { get; set; }

	/// <summary>
	/// <para>
	/// A general description of the cluster task that may include a reason and origin.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	string Source { get; set; }

	/// <summary>
	/// <para>
	/// The time since the task is waiting for being performed.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Duration? TimeInQueue { get; set; }

	/// <summary>
	/// <para>
	/// The time expressed in milliseconds since the task is waiting for being performed.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	System.TimeSpan TimeInQueueMillis { get; set; }
}