// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Cluster;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Cluster.Json.OperatingSystemMemoryInfoConverter))]
public sealed partial class OperatingSystemMemoryInfo
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public OperatingSystemMemoryInfo(long freeInBytes, int freePercent, long totalInBytes, long usedInBytes, int usedPercent)
	{
		FreeInBytes = freeInBytes;
		FreePercent = freePercent;
		TotalInBytes = totalInBytes;
		UsedInBytes = usedInBytes;
		UsedPercent = usedPercent;
	}
#if NET7_0_OR_GREATER
	public OperatingSystemMemoryInfo()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public OperatingSystemMemoryInfo()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal OperatingSystemMemoryInfo(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// Total amount of memory across all selected nodes, but using the value specified using the <c>es.total_memory_bytes</c> system property instead of measured total memory for those nodes where that system property was set.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.ByteSize? AdjustedTotal { get; set; }

	/// <summary>
	/// <para>
	/// Total amount, in bytes, of memory across all selected nodes, but using the value specified using the <c>es.total_memory_bytes</c> system property instead of measured total memory for those nodes where that system property was set.
	/// </para>
	/// </summary>
	public long? AdjustedTotalInBytes { get; set; }

	/// <summary>
	/// <para>
	/// Amount of free physical memory across all selected nodes.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.ByteSize? Free { get; set; }

	/// <summary>
	/// <para>
	/// Amount, in bytes, of free physical memory across all selected nodes.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	long FreeInBytes { get; set; }

	/// <summary>
	/// <para>
	/// Percentage of free physical memory across all selected nodes.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	int FreePercent { get; set; }

	/// <summary>
	/// <para>
	/// Total amount of physical memory across all selected nodes.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.ByteSize? Total { get; set; }

	/// <summary>
	/// <para>
	/// Total amount, in bytes, of physical memory across all selected nodes.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	long TotalInBytes { get; set; }

	/// <summary>
	/// <para>
	/// Amount of physical memory in use across all selected nodes.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.ByteSize? Used { get; set; }

	/// <summary>
	/// <para>
	/// Amount, in bytes, of physical memory in use across all selected nodes.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	long UsedInBytes { get; set; }

	/// <summary>
	/// <para>
	/// Percentage of physical memory in use across all selected nodes.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	int UsedPercent { get; set; }
}