// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Cluster.Json;

public sealed partial class NodeDiskUsageConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.Cluster.NodeDiskUsage>
{
	private static readonly System.Text.Json.JsonEncodedText PropLeastAvailable = System.Text.Json.JsonEncodedText.Encode("least_available");
	private static readonly System.Text.Json.JsonEncodedText PropMostAvailable = System.Text.Json.JsonEncodedText.Encode("most_available");
	private static readonly System.Text.Json.JsonEncodedText PropNodeName = System.Text.Json.JsonEncodedText.Encode("node_name");

	public override Elastic.Clients.Elasticsearch.Cluster.NodeDiskUsage Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		reader.ValidateToken(System.Text.Json.JsonTokenType.StartObject);
		LocalJsonValue<Elastic.Clients.Elasticsearch.Cluster.DiskUsage> propLeastAvailable = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.Cluster.DiskUsage> propMostAvailable = default;
		LocalJsonValue<string> propNodeName = default;
		while (reader.Read() && reader.TokenType is System.Text.Json.JsonTokenType.PropertyName)
		{
			if (propLeastAvailable.TryReadProperty(ref reader, options, PropLeastAvailable, null))
			{
				continue;
			}

			if (propMostAvailable.TryReadProperty(ref reader, options, PropMostAvailable, null))
			{
				continue;
			}

			if (propNodeName.TryReadProperty(ref reader, options, PropNodeName, null))
			{
				continue;
			}

			if (options.UnmappedMemberHandling is System.Text.Json.Serialization.JsonUnmappedMemberHandling.Skip)
			{
				reader.SafeSkip();
				continue;
			}

			throw new System.Text.Json.JsonException($"Unknown JSON property '{reader.GetString()}' for type '{typeToConvert.Name}'.");
		}

		reader.ValidateToken(System.Text.Json.JsonTokenType.EndObject);
		return new Elastic.Clients.Elasticsearch.Cluster.NodeDiskUsage(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance)
		{
			LeastAvailable = propLeastAvailable.Value,
			MostAvailable = propMostAvailable.Value,
			NodeName = propNodeName.Value
		};
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Cluster.NodeDiskUsage value, System.Text.Json.JsonSerializerOptions options)
	{
		writer.WriteStartObject();
		writer.WriteProperty(options, PropLeastAvailable, value.LeastAvailable, null, null);
		writer.WriteProperty(options, PropMostAvailable, value.MostAvailable, null, null);
		writer.WriteProperty(options, PropNodeName, value.NodeName, null, null);
		writer.WriteEndObject();
	}
}