// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Cluster.Json;

public sealed partial class IndicesVersionsConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.Cluster.IndicesVersions>
{
	private static readonly System.Text.Json.JsonEncodedText PropIndexCount = System.Text.Json.JsonEncodedText.Encode("index_count");
	private static readonly System.Text.Json.JsonEncodedText PropPrimaryShardCount = System.Text.Json.JsonEncodedText.Encode("primary_shard_count");
	private static readonly System.Text.Json.JsonEncodedText PropTotalPrimaryBytes = System.Text.Json.JsonEncodedText.Encode("total_primary_bytes");
	private static readonly System.Text.Json.JsonEncodedText PropTotalPrimarySize = System.Text.Json.JsonEncodedText.Encode("total_primary_size");
	private static readonly System.Text.Json.JsonEncodedText PropVersion = System.Text.Json.JsonEncodedText.Encode("version");

	public override Elastic.Clients.Elasticsearch.Cluster.IndicesVersions Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		reader.ValidateToken(System.Text.Json.JsonTokenType.StartObject);
		LocalJsonValue<int> propIndexCount = default;
		LocalJsonValue<int> propPrimaryShardCount = default;
		LocalJsonValue<long> propTotalPrimaryBytes = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.ByteSize?> propTotalPrimarySize = default;
		LocalJsonValue<string> propVersion = default;
		while (reader.Read() && reader.TokenType is System.Text.Json.JsonTokenType.PropertyName)
		{
			if (propIndexCount.TryReadProperty(ref reader, options, PropIndexCount, null))
			{
				continue;
			}

			if (propPrimaryShardCount.TryReadProperty(ref reader, options, PropPrimaryShardCount, null))
			{
				continue;
			}

			if (propTotalPrimaryBytes.TryReadProperty(ref reader, options, PropTotalPrimaryBytes, null))
			{
				continue;
			}

			if (propTotalPrimarySize.TryReadProperty(ref reader, options, PropTotalPrimarySize, null))
			{
				continue;
			}

			if (propVersion.TryReadProperty(ref reader, options, PropVersion, null))
			{
				continue;
			}

			if (options.UnmappedMemberHandling is System.Text.Json.Serialization.JsonUnmappedMemberHandling.Skip)
			{
				reader.SafeSkip();
				continue;
			}

			throw new System.Text.Json.JsonException($"Unknown JSON property '{reader.GetString()}' for type '{typeToConvert.Name}'.");
		}

		reader.ValidateToken(System.Text.Json.JsonTokenType.EndObject);
		return new Elastic.Clients.Elasticsearch.Cluster.IndicesVersions(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance)
		{
			IndexCount = propIndexCount.Value,
			PrimaryShardCount = propPrimaryShardCount.Value,
			TotalPrimaryBytes = propTotalPrimaryBytes.Value,
			TotalPrimarySize = propTotalPrimarySize.Value,
			Version = propVersion.Value
		};
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Cluster.IndicesVersions value, System.Text.Json.JsonSerializerOptions options)
	{
		writer.WriteStartObject();
		writer.WriteProperty(options, PropIndexCount, value.IndexCount, null, null);
		writer.WriteProperty(options, PropPrimaryShardCount, value.PrimaryShardCount, null, null);
		writer.WriteProperty(options, PropTotalPrimaryBytes, value.TotalPrimaryBytes, null, null);
		writer.WriteProperty(options, PropTotalPrimarySize, value.TotalPrimarySize, null, null);
		writer.WriteProperty(options, PropVersion, value.Version, null, null);
		writer.WriteEndObject();
	}
}