// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Cluster;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Cluster.Json.IndexHealthStatsConverter))]
public sealed partial class IndexHealthStats
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public IndexHealthStats(int activePrimaryShards, int activeShards, int initializingShards, int numberOfReplicas, int numberOfShards, int relocatingShards, Elastic.Clients.Elasticsearch.HealthStatus status, int unassignedPrimaryShards, int unassignedShards)
	{
		ActivePrimaryShards = activePrimaryShards;
		ActiveShards = activeShards;
		InitializingShards = initializingShards;
		NumberOfReplicas = numberOfReplicas;
		NumberOfShards = numberOfShards;
		RelocatingShards = relocatingShards;
		Status = status;
		UnassignedPrimaryShards = unassignedPrimaryShards;
		UnassignedShards = unassignedShards;
	}
#if NET7_0_OR_GREATER
	public IndexHealthStats()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public IndexHealthStats()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal IndexHealthStats(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	public
#if NET7_0_OR_GREATER
	required
#endif
	int ActivePrimaryShards { get; set; }
	public
#if NET7_0_OR_GREATER
	required
#endif
	int ActiveShards { get; set; }
	public
#if NET7_0_OR_GREATER
	required
#endif
	int InitializingShards { get; set; }
	public
#if NET7_0_OR_GREATER
	required
#endif
	int NumberOfReplicas { get; set; }
	public
#if NET7_0_OR_GREATER
	required
#endif
	int NumberOfShards { get; set; }
	public
#if NET7_0_OR_GREATER
	required
#endif
	int RelocatingShards { get; set; }
	public System.Collections.Generic.IReadOnlyDictionary<string, Elastic.Clients.Elasticsearch.Cluster.ShardHealthStats>? Shards { get; set; }
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.HealthStatus Status { get; set; }
	public
#if NET7_0_OR_GREATER
	required
#endif
	int UnassignedPrimaryShards { get; set; }
	public
#if NET7_0_OR_GREATER
	required
#endif
	int UnassignedShards { get; set; }
}