// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Cluster.Json;

public sealed partial class IndexHealthStatsConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.Cluster.IndexHealthStats>
{
	private static readonly System.Text.Json.JsonEncodedText PropActivePrimaryShards = System.Text.Json.JsonEncodedText.Encode("active_primary_shards");
	private static readonly System.Text.Json.JsonEncodedText PropActiveShards = System.Text.Json.JsonEncodedText.Encode("active_shards");
	private static readonly System.Text.Json.JsonEncodedText PropInitializingShards = System.Text.Json.JsonEncodedText.Encode("initializing_shards");
	private static readonly System.Text.Json.JsonEncodedText PropNumberOfReplicas = System.Text.Json.JsonEncodedText.Encode("number_of_replicas");
	private static readonly System.Text.Json.JsonEncodedText PropNumberOfShards = System.Text.Json.JsonEncodedText.Encode("number_of_shards");
	private static readonly System.Text.Json.JsonEncodedText PropRelocatingShards = System.Text.Json.JsonEncodedText.Encode("relocating_shards");
	private static readonly System.Text.Json.JsonEncodedText PropShards = System.Text.Json.JsonEncodedText.Encode("shards");
	private static readonly System.Text.Json.JsonEncodedText PropStatus = System.Text.Json.JsonEncodedText.Encode("status");
	private static readonly System.Text.Json.JsonEncodedText PropUnassignedPrimaryShards = System.Text.Json.JsonEncodedText.Encode("unassigned_primary_shards");
	private static readonly System.Text.Json.JsonEncodedText PropUnassignedShards = System.Text.Json.JsonEncodedText.Encode("unassigned_shards");

	public override Elastic.Clients.Elasticsearch.Cluster.IndexHealthStats Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		reader.ValidateToken(System.Text.Json.JsonTokenType.StartObject);
		LocalJsonValue<int> propActivePrimaryShards = default;
		LocalJsonValue<int> propActiveShards = default;
		LocalJsonValue<int> propInitializingShards = default;
		LocalJsonValue<int> propNumberOfReplicas = default;
		LocalJsonValue<int> propNumberOfShards = default;
		LocalJsonValue<int> propRelocatingShards = default;
		LocalJsonValue<System.Collections.Generic.IReadOnlyDictionary<string, Elastic.Clients.Elasticsearch.Cluster.ShardHealthStats>?> propShards = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.HealthStatus> propStatus = default;
		LocalJsonValue<int> propUnassignedPrimaryShards = default;
		LocalJsonValue<int> propUnassignedShards = default;
		while (reader.Read() && reader.TokenType is System.Text.Json.JsonTokenType.PropertyName)
		{
			if (propActivePrimaryShards.TryReadProperty(ref reader, options, PropActivePrimaryShards, null))
			{
				continue;
			}

			if (propActiveShards.TryReadProperty(ref reader, options, PropActiveShards, null))
			{
				continue;
			}

			if (propInitializingShards.TryReadProperty(ref reader, options, PropInitializingShards, null))
			{
				continue;
			}

			if (propNumberOfReplicas.TryReadProperty(ref reader, options, PropNumberOfReplicas, null))
			{
				continue;
			}

			if (propNumberOfShards.TryReadProperty(ref reader, options, PropNumberOfShards, null))
			{
				continue;
			}

			if (propRelocatingShards.TryReadProperty(ref reader, options, PropRelocatingShards, null))
			{
				continue;
			}

			if (propShards.TryReadProperty(ref reader, options, PropShards, static System.Collections.Generic.IReadOnlyDictionary<string, Elastic.Clients.Elasticsearch.Cluster.ShardHealthStats>? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadDictionaryValue<string, Elastic.Clients.Elasticsearch.Cluster.ShardHealthStats>(o, null, null)))
			{
				continue;
			}

			if (propStatus.TryReadProperty(ref reader, options, PropStatus, null))
			{
				continue;
			}

			if (propUnassignedPrimaryShards.TryReadProperty(ref reader, options, PropUnassignedPrimaryShards, null))
			{
				continue;
			}

			if (propUnassignedShards.TryReadProperty(ref reader, options, PropUnassignedShards, null))
			{
				continue;
			}

			if (options.UnmappedMemberHandling is System.Text.Json.Serialization.JsonUnmappedMemberHandling.Skip)
			{
				reader.SafeSkip();
				continue;
			}

			throw new System.Text.Json.JsonException($"Unknown JSON property '{reader.GetString()}' for type '{typeToConvert.Name}'.");
		}

		reader.ValidateToken(System.Text.Json.JsonTokenType.EndObject);
		return new Elastic.Clients.Elasticsearch.Cluster.IndexHealthStats(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance)
		{
			ActivePrimaryShards = propActivePrimaryShards.Value,
			ActiveShards = propActiveShards.Value,
			InitializingShards = propInitializingShards.Value,
			NumberOfReplicas = propNumberOfReplicas.Value,
			NumberOfShards = propNumberOfShards.Value,
			RelocatingShards = propRelocatingShards.Value,
			Shards = propShards.Value,
			Status = propStatus.Value,
			UnassignedPrimaryShards = propUnassignedPrimaryShards.Value,
			UnassignedShards = propUnassignedShards.Value
		};
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Cluster.IndexHealthStats value, System.Text.Json.JsonSerializerOptions options)
	{
		writer.WriteStartObject();
		writer.WriteProperty(options, PropActivePrimaryShards, value.ActivePrimaryShards, null, null);
		writer.WriteProperty(options, PropActiveShards, value.ActiveShards, null, null);
		writer.WriteProperty(options, PropInitializingShards, value.InitializingShards, null, null);
		writer.WriteProperty(options, PropNumberOfReplicas, value.NumberOfReplicas, null, null);
		writer.WriteProperty(options, PropNumberOfShards, value.NumberOfShards, null, null);
		writer.WriteProperty(options, PropRelocatingShards, value.RelocatingShards, null, null);
		writer.WriteProperty(options, PropShards, value.Shards, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, System.Collections.Generic.IReadOnlyDictionary<string, Elastic.Clients.Elasticsearch.Cluster.ShardHealthStats>? v) => w.WriteDictionaryValue<string, Elastic.Clients.Elasticsearch.Cluster.ShardHealthStats>(o, v, null, null));
		writer.WriteProperty(options, PropStatus, value.Status, null, null);
		writer.WriteProperty(options, PropUnassignedPrimaryShards, value.UnassignedPrimaryShards, null, null);
		writer.WriteProperty(options, PropUnassignedShards, value.UnassignedShards, null, null);
		writer.WriteEndObject();
	}
}