// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Cluster;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Cluster.Json.FieldTypesMappingsConverter))]
public sealed partial class FieldTypesMappings
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public FieldTypesMappings(System.Collections.Generic.IReadOnlyCollection<Elastic.Clients.Elasticsearch.Cluster.FieldTypes> fieldTypes, System.Collections.Generic.IReadOnlyCollection<Elastic.Clients.Elasticsearch.Cluster.RuntimeFieldTypes> runtimeFieldTypes, System.Collections.Generic.IReadOnlyDictionary<string, int> sourceModes)
	{
		FieldTypes = fieldTypes;
		RuntimeFieldTypes = runtimeFieldTypes;
		SourceModes = sourceModes;
	}
#if NET7_0_OR_GREATER
	public FieldTypesMappings()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public FieldTypesMappings()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal FieldTypesMappings(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// Contains statistics about field data types used in selected nodes.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	System.Collections.Generic.IReadOnlyCollection<Elastic.Clients.Elasticsearch.Cluster.FieldTypes> FieldTypes { get; set; }

	/// <summary>
	/// <para>
	/// Contains statistics about runtime field data types used in selected nodes.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	System.Collections.Generic.IReadOnlyCollection<Elastic.Clients.Elasticsearch.Cluster.RuntimeFieldTypes> RuntimeFieldTypes { get; set; }

	/// <summary>
	/// <para>
	/// Source mode usage count.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	System.Collections.Generic.IReadOnlyDictionary<string, int> SourceModes { get; set; }

	/// <summary>
	/// <para>
	/// Total number of fields in all non-system indices, accounting for mapping deduplication.
	/// </para>
	/// </summary>
	public long? TotalDeduplicatedFieldCount { get; set; }

	/// <summary>
	/// <para>
	/// Total size of all mappings after deduplication and compression.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.ByteSize? TotalDeduplicatedMappingSize { get; set; }

	/// <summary>
	/// <para>
	/// Total size of all mappings, in bytes, after deduplication and compression.
	/// </para>
	/// </summary>
	public long? TotalDeduplicatedMappingSizeInBytes { get; set; }

	/// <summary>
	/// <para>
	/// Total number of fields in all non-system indices.
	/// </para>
	/// </summary>
	public long? TotalFieldCount { get; set; }
}