// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Cluster.Json;

public sealed partial class FieldTypesMappingsConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.Cluster.FieldTypesMappings>
{
	private static readonly System.Text.Json.JsonEncodedText PropFieldTypes = System.Text.Json.JsonEncodedText.Encode("field_types");
	private static readonly System.Text.Json.JsonEncodedText PropRuntimeFieldTypes = System.Text.Json.JsonEncodedText.Encode("runtime_field_types");
	private static readonly System.Text.Json.JsonEncodedText PropSourceModes = System.Text.Json.JsonEncodedText.Encode("source_modes");
	private static readonly System.Text.Json.JsonEncodedText PropTotalDeduplicatedFieldCount = System.Text.Json.JsonEncodedText.Encode("total_deduplicated_field_count");
	private static readonly System.Text.Json.JsonEncodedText PropTotalDeduplicatedMappingSize = System.Text.Json.JsonEncodedText.Encode("total_deduplicated_mapping_size");
	private static readonly System.Text.Json.JsonEncodedText PropTotalDeduplicatedMappingSizeInBytes = System.Text.Json.JsonEncodedText.Encode("total_deduplicated_mapping_size_in_bytes");
	private static readonly System.Text.Json.JsonEncodedText PropTotalFieldCount = System.Text.Json.JsonEncodedText.Encode("total_field_count");

	public override Elastic.Clients.Elasticsearch.Cluster.FieldTypesMappings Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		reader.ValidateToken(System.Text.Json.JsonTokenType.StartObject);
		LocalJsonValue<System.Collections.Generic.IReadOnlyCollection<Elastic.Clients.Elasticsearch.Cluster.FieldTypes>> propFieldTypes = default;
		LocalJsonValue<System.Collections.Generic.IReadOnlyCollection<Elastic.Clients.Elasticsearch.Cluster.RuntimeFieldTypes>> propRuntimeFieldTypes = default;
		LocalJsonValue<System.Collections.Generic.IReadOnlyDictionary<string, int>> propSourceModes = default;
		LocalJsonValue<long?> propTotalDeduplicatedFieldCount = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.ByteSize?> propTotalDeduplicatedMappingSize = default;
		LocalJsonValue<long?> propTotalDeduplicatedMappingSizeInBytes = default;
		LocalJsonValue<long?> propTotalFieldCount = default;
		while (reader.Read() && reader.TokenType is System.Text.Json.JsonTokenType.PropertyName)
		{
			if (propFieldTypes.TryReadProperty(ref reader, options, PropFieldTypes, static System.Collections.Generic.IReadOnlyCollection<Elastic.Clients.Elasticsearch.Cluster.FieldTypes> (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadCollectionValue<Elastic.Clients.Elasticsearch.Cluster.FieldTypes>(o, null)!))
			{
				continue;
			}

			if (propRuntimeFieldTypes.TryReadProperty(ref reader, options, PropRuntimeFieldTypes, static System.Collections.Generic.IReadOnlyCollection<Elastic.Clients.Elasticsearch.Cluster.RuntimeFieldTypes> (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadCollectionValue<Elastic.Clients.Elasticsearch.Cluster.RuntimeFieldTypes>(o, null)!))
			{
				continue;
			}

			if (propSourceModes.TryReadProperty(ref reader, options, PropSourceModes, static System.Collections.Generic.IReadOnlyDictionary<string, int> (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadDictionaryValue<string, int>(o, null, null)!))
			{
				continue;
			}

			if (propTotalDeduplicatedFieldCount.TryReadProperty(ref reader, options, PropTotalDeduplicatedFieldCount, static long? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<long>(o)))
			{
				continue;
			}

			if (propTotalDeduplicatedMappingSize.TryReadProperty(ref reader, options, PropTotalDeduplicatedMappingSize, null))
			{
				continue;
			}

			if (propTotalDeduplicatedMappingSizeInBytes.TryReadProperty(ref reader, options, PropTotalDeduplicatedMappingSizeInBytes, static long? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<long>(o)))
			{
				continue;
			}

			if (propTotalFieldCount.TryReadProperty(ref reader, options, PropTotalFieldCount, static long? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<long>(o)))
			{
				continue;
			}

			if (options.UnmappedMemberHandling is System.Text.Json.Serialization.JsonUnmappedMemberHandling.Skip)
			{
				reader.SafeSkip();
				continue;
			}

			throw new System.Text.Json.JsonException($"Unknown JSON property '{reader.GetString()}' for type '{typeToConvert.Name}'.");
		}

		reader.ValidateToken(System.Text.Json.JsonTokenType.EndObject);
		return new Elastic.Clients.Elasticsearch.Cluster.FieldTypesMappings(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance)
		{
			FieldTypes = propFieldTypes.Value,
			RuntimeFieldTypes = propRuntimeFieldTypes.Value,
			SourceModes = propSourceModes.Value,
			TotalDeduplicatedFieldCount = propTotalDeduplicatedFieldCount.Value,
			TotalDeduplicatedMappingSize = propTotalDeduplicatedMappingSize.Value,
			TotalDeduplicatedMappingSizeInBytes = propTotalDeduplicatedMappingSizeInBytes.Value,
			TotalFieldCount = propTotalFieldCount.Value
		};
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Cluster.FieldTypesMappings value, System.Text.Json.JsonSerializerOptions options)
	{
		writer.WriteStartObject();
		writer.WriteProperty(options, PropFieldTypes, value.FieldTypes, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, System.Collections.Generic.IReadOnlyCollection<Elastic.Clients.Elasticsearch.Cluster.FieldTypes> v) => w.WriteCollectionValue<Elastic.Clients.Elasticsearch.Cluster.FieldTypes>(o, v, null));
		writer.WriteProperty(options, PropRuntimeFieldTypes, value.RuntimeFieldTypes, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, System.Collections.Generic.IReadOnlyCollection<Elastic.Clients.Elasticsearch.Cluster.RuntimeFieldTypes> v) => w.WriteCollectionValue<Elastic.Clients.Elasticsearch.Cluster.RuntimeFieldTypes>(o, v, null));
		writer.WriteProperty(options, PropSourceModes, value.SourceModes, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, System.Collections.Generic.IReadOnlyDictionary<string, int> v) => w.WriteDictionaryValue<string, int>(o, v, null, null));
		writer.WriteProperty(options, PropTotalDeduplicatedFieldCount, value.TotalDeduplicatedFieldCount, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, long? v) => w.WriteNullableValue<long>(o, v));
		writer.WriteProperty(options, PropTotalDeduplicatedMappingSize, value.TotalDeduplicatedMappingSize, null, null);
		writer.WriteProperty(options, PropTotalDeduplicatedMappingSizeInBytes, value.TotalDeduplicatedMappingSizeInBytes, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, long? v) => w.WriteNullableValue<long>(o, v));
		writer.WriteProperty(options, PropTotalFieldCount, value.TotalFieldCount, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, long? v) => w.WriteNullableValue<long>(o, v));
		writer.WriteEndObject();
	}
}