// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Cluster;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Cluster.Json.FieldTypesConverter))]
public sealed partial class FieldTypes
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public FieldTypes(int count, int indexCount, string name)
	{
		Count = count;
		IndexCount = indexCount;
		Name = name;
	}
#if NET7_0_OR_GREATER
	public FieldTypes()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public FieldTypes()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal FieldTypes(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// The number of occurrences of the field type in selected nodes.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	int Count { get; set; }

	/// <summary>
	/// <para>
	/// The number of indices containing the field type in selected nodes.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	int IndexCount { get; set; }

	/// <summary>
	/// <para>
	/// For dense_vector field types, number of indexed vector types in selected nodes.
	/// </para>
	/// </summary>
	public int? IndexedVectorCount { get; set; }

	/// <summary>
	/// <para>
	/// For dense_vector field types, the maximum dimension of all indexed vector types in selected nodes.
	/// </para>
	/// </summary>
	public int? IndexedVectorDimMax { get; set; }

	/// <summary>
	/// <para>
	/// For dense_vector field types, the minimum dimension of all indexed vector types in selected nodes.
	/// </para>
	/// </summary>
	public int? IndexedVectorDimMin { get; set; }

	/// <summary>
	/// <para>
	/// The name for the field type in selected nodes.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	string Name { get; set; }

	/// <summary>
	/// <para>
	/// The number of fields that declare a script.
	/// </para>
	/// </summary>
	public int? ScriptCount { get; set; }

	/// <summary>
	/// <para>
	/// For dense_vector field types, count of mappings by element type
	/// </para>
	/// </summary>
	public System.Collections.Generic.IReadOnlyDictionary<string, int>? VectorElementTypeCount { get; set; }

	/// <summary>
	/// <para>
	/// For dense_vector field types, count of mappings by index type
	/// </para>
	/// </summary>
	public System.Collections.Generic.IReadOnlyDictionary<string, int>? VectorIndexTypeCount { get; set; }

	/// <summary>
	/// <para>
	/// For dense_vector field types, count of mappings by similarity
	/// </para>
	/// </summary>
	public System.Collections.Generic.IReadOnlyDictionary<string, int>? VectorSimilarityTypeCount { get; set; }
}