// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Cluster.Json;

public sealed partial class FieldTypesConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.Cluster.FieldTypes>
{
	private static readonly System.Text.Json.JsonEncodedText PropCount = System.Text.Json.JsonEncodedText.Encode("count");
	private static readonly System.Text.Json.JsonEncodedText PropIndexCount = System.Text.Json.JsonEncodedText.Encode("index_count");
	private static readonly System.Text.Json.JsonEncodedText PropIndexedVectorCount = System.Text.Json.JsonEncodedText.Encode("indexed_vector_count");
	private static readonly System.Text.Json.JsonEncodedText PropIndexedVectorDimMax = System.Text.Json.JsonEncodedText.Encode("indexed_vector_dim_max");
	private static readonly System.Text.Json.JsonEncodedText PropIndexedVectorDimMin = System.Text.Json.JsonEncodedText.Encode("indexed_vector_dim_min");
	private static readonly System.Text.Json.JsonEncodedText PropName = System.Text.Json.JsonEncodedText.Encode("name");
	private static readonly System.Text.Json.JsonEncodedText PropScriptCount = System.Text.Json.JsonEncodedText.Encode("script_count");
	private static readonly System.Text.Json.JsonEncodedText PropVectorElementTypeCount = System.Text.Json.JsonEncodedText.Encode("vector_element_type_count");
	private static readonly System.Text.Json.JsonEncodedText PropVectorIndexTypeCount = System.Text.Json.JsonEncodedText.Encode("vector_index_type_count");
	private static readonly System.Text.Json.JsonEncodedText PropVectorSimilarityTypeCount = System.Text.Json.JsonEncodedText.Encode("vector_similarity_type_count");

	public override Elastic.Clients.Elasticsearch.Cluster.FieldTypes Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		reader.ValidateToken(System.Text.Json.JsonTokenType.StartObject);
		LocalJsonValue<int> propCount = default;
		LocalJsonValue<int> propIndexCount = default;
		LocalJsonValue<int?> propIndexedVectorCount = default;
		LocalJsonValue<int?> propIndexedVectorDimMax = default;
		LocalJsonValue<int?> propIndexedVectorDimMin = default;
		LocalJsonValue<string> propName = default;
		LocalJsonValue<int?> propScriptCount = default;
		LocalJsonValue<System.Collections.Generic.IReadOnlyDictionary<string, int>?> propVectorElementTypeCount = default;
		LocalJsonValue<System.Collections.Generic.IReadOnlyDictionary<string, int>?> propVectorIndexTypeCount = default;
		LocalJsonValue<System.Collections.Generic.IReadOnlyDictionary<string, int>?> propVectorSimilarityTypeCount = default;
		while (reader.Read() && reader.TokenType is System.Text.Json.JsonTokenType.PropertyName)
		{
			if (propCount.TryReadProperty(ref reader, options, PropCount, null))
			{
				continue;
			}

			if (propIndexCount.TryReadProperty(ref reader, options, PropIndexCount, null))
			{
				continue;
			}

			if (propIndexedVectorCount.TryReadProperty(ref reader, options, PropIndexedVectorCount, static int? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<int>(o)))
			{
				continue;
			}

			if (propIndexedVectorDimMax.TryReadProperty(ref reader, options, PropIndexedVectorDimMax, static int? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<int>(o)))
			{
				continue;
			}

			if (propIndexedVectorDimMin.TryReadProperty(ref reader, options, PropIndexedVectorDimMin, static int? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<int>(o)))
			{
				continue;
			}

			if (propName.TryReadProperty(ref reader, options, PropName, null))
			{
				continue;
			}

			if (propScriptCount.TryReadProperty(ref reader, options, PropScriptCount, static int? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<int>(o)))
			{
				continue;
			}

			if (propVectorElementTypeCount.TryReadProperty(ref reader, options, PropVectorElementTypeCount, static System.Collections.Generic.IReadOnlyDictionary<string, int>? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadDictionaryValue<string, int>(o, null, null)))
			{
				continue;
			}

			if (propVectorIndexTypeCount.TryReadProperty(ref reader, options, PropVectorIndexTypeCount, static System.Collections.Generic.IReadOnlyDictionary<string, int>? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadDictionaryValue<string, int>(o, null, null)))
			{
				continue;
			}

			if (propVectorSimilarityTypeCount.TryReadProperty(ref reader, options, PropVectorSimilarityTypeCount, static System.Collections.Generic.IReadOnlyDictionary<string, int>? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadDictionaryValue<string, int>(o, null, null)))
			{
				continue;
			}

			if (options.UnmappedMemberHandling is System.Text.Json.Serialization.JsonUnmappedMemberHandling.Skip)
			{
				reader.SafeSkip();
				continue;
			}

			throw new System.Text.Json.JsonException($"Unknown JSON property '{reader.GetString()}' for type '{typeToConvert.Name}'.");
		}

		reader.ValidateToken(System.Text.Json.JsonTokenType.EndObject);
		return new Elastic.Clients.Elasticsearch.Cluster.FieldTypes(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance)
		{
			Count = propCount.Value,
			IndexCount = propIndexCount.Value,
			IndexedVectorCount = propIndexedVectorCount.Value,
			IndexedVectorDimMax = propIndexedVectorDimMax.Value,
			IndexedVectorDimMin = propIndexedVectorDimMin.Value,
			Name = propName.Value,
			ScriptCount = propScriptCount.Value,
			VectorElementTypeCount = propVectorElementTypeCount.Value,
			VectorIndexTypeCount = propVectorIndexTypeCount.Value,
			VectorSimilarityTypeCount = propVectorSimilarityTypeCount.Value
		};
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Cluster.FieldTypes value, System.Text.Json.JsonSerializerOptions options)
	{
		writer.WriteStartObject();
		writer.WriteProperty(options, PropCount, value.Count, null, null);
		writer.WriteProperty(options, PropIndexCount, value.IndexCount, null, null);
		writer.WriteProperty(options, PropIndexedVectorCount, value.IndexedVectorCount, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, int? v) => w.WriteNullableValue<int>(o, v));
		writer.WriteProperty(options, PropIndexedVectorDimMax, value.IndexedVectorDimMax, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, int? v) => w.WriteNullableValue<int>(o, v));
		writer.WriteProperty(options, PropIndexedVectorDimMin, value.IndexedVectorDimMin, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, int? v) => w.WriteNullableValue<int>(o, v));
		writer.WriteProperty(options, PropName, value.Name, null, null);
		writer.WriteProperty(options, PropScriptCount, value.ScriptCount, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, int? v) => w.WriteNullableValue<int>(o, v));
		writer.WriteProperty(options, PropVectorElementTypeCount, value.VectorElementTypeCount, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, System.Collections.Generic.IReadOnlyDictionary<string, int>? v) => w.WriteDictionaryValue<string, int>(o, v, null, null));
		writer.WriteProperty(options, PropVectorIndexTypeCount, value.VectorIndexTypeCount, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, System.Collections.Generic.IReadOnlyDictionary<string, int>? v) => w.WriteDictionaryValue<string, int>(o, v, null, null));
		writer.WriteProperty(options, PropVectorSimilarityTypeCount, value.VectorSimilarityTypeCount, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, System.Collections.Generic.IReadOnlyDictionary<string, int>? v) => w.WriteDictionaryValue<string, int>(o, v, null, null));
		writer.WriteEndObject();
	}
}