// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Cluster.Json;

public sealed partial class DiskUsageConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.Cluster.DiskUsage>
{
	private static readonly System.Text.Json.JsonEncodedText PropFreeBytes = System.Text.Json.JsonEncodedText.Encode("free_bytes");
	private static readonly System.Text.Json.JsonEncodedText PropFreeDiskPercent = System.Text.Json.JsonEncodedText.Encode("free_disk_percent");
	private static readonly System.Text.Json.JsonEncodedText PropPath = System.Text.Json.JsonEncodedText.Encode("path");
	private static readonly System.Text.Json.JsonEncodedText PropTotalBytes = System.Text.Json.JsonEncodedText.Encode("total_bytes");
	private static readonly System.Text.Json.JsonEncodedText PropUsedBytes = System.Text.Json.JsonEncodedText.Encode("used_bytes");
	private static readonly System.Text.Json.JsonEncodedText PropUsedDiskPercent = System.Text.Json.JsonEncodedText.Encode("used_disk_percent");

	public override Elastic.Clients.Elasticsearch.Cluster.DiskUsage Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		reader.ValidateToken(System.Text.Json.JsonTokenType.StartObject);
		LocalJsonValue<long> propFreeBytes = default;
		LocalJsonValue<double> propFreeDiskPercent = default;
		LocalJsonValue<string> propPath = default;
		LocalJsonValue<long> propTotalBytes = default;
		LocalJsonValue<long> propUsedBytes = default;
		LocalJsonValue<double> propUsedDiskPercent = default;
		while (reader.Read() && reader.TokenType is System.Text.Json.JsonTokenType.PropertyName)
		{
			if (propFreeBytes.TryReadProperty(ref reader, options, PropFreeBytes, null))
			{
				continue;
			}

			if (propFreeDiskPercent.TryReadProperty(ref reader, options, PropFreeDiskPercent, null))
			{
				continue;
			}

			if (propPath.TryReadProperty(ref reader, options, PropPath, null))
			{
				continue;
			}

			if (propTotalBytes.TryReadProperty(ref reader, options, PropTotalBytes, null))
			{
				continue;
			}

			if (propUsedBytes.TryReadProperty(ref reader, options, PropUsedBytes, null))
			{
				continue;
			}

			if (propUsedDiskPercent.TryReadProperty(ref reader, options, PropUsedDiskPercent, null))
			{
				continue;
			}

			if (options.UnmappedMemberHandling is System.Text.Json.Serialization.JsonUnmappedMemberHandling.Skip)
			{
				reader.SafeSkip();
				continue;
			}

			throw new System.Text.Json.JsonException($"Unknown JSON property '{reader.GetString()}' for type '{typeToConvert.Name}'.");
		}

		reader.ValidateToken(System.Text.Json.JsonTokenType.EndObject);
		return new Elastic.Clients.Elasticsearch.Cluster.DiskUsage(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance)
		{
			FreeBytes = propFreeBytes.Value,
			FreeDiskPercent = propFreeDiskPercent.Value,
			Path = propPath.Value,
			TotalBytes = propTotalBytes.Value,
			UsedBytes = propUsedBytes.Value,
			UsedDiskPercent = propUsedDiskPercent.Value
		};
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Cluster.DiskUsage value, System.Text.Json.JsonSerializerOptions options)
	{
		writer.WriteStartObject();
		writer.WriteProperty(options, PropFreeBytes, value.FreeBytes, null, null);
		writer.WriteProperty(options, PropFreeDiskPercent, value.FreeDiskPercent, null, null);
		writer.WriteProperty(options, PropPath, value.Path, null, null);
		writer.WriteProperty(options, PropTotalBytes, value.TotalBytes, null, null);
		writer.WriteProperty(options, PropUsedBytes, value.UsedBytes, null, null);
		writer.WriteProperty(options, PropUsedDiskPercent, value.UsedDiskPercent, null, null);
		writer.WriteEndObject();
	}
}