// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Cluster.Json;

public sealed partial class DenseVectorOffHeapStatsConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.Cluster.DenseVectorOffHeapStats>
{
	private static readonly System.Text.Json.JsonEncodedText PropFielddata = System.Text.Json.JsonEncodedText.Encode("fielddata");
	private static readonly System.Text.Json.JsonEncodedText PropTotalSize = System.Text.Json.JsonEncodedText.Encode("total_size");
	private static readonly System.Text.Json.JsonEncodedText PropTotalSizeBytes = System.Text.Json.JsonEncodedText.Encode("total_size_bytes");
	private static readonly System.Text.Json.JsonEncodedText PropTotalVebSize = System.Text.Json.JsonEncodedText.Encode("total_veb_size");
	private static readonly System.Text.Json.JsonEncodedText PropTotalVebSizeBytes = System.Text.Json.JsonEncodedText.Encode("total_veb_size_bytes");
	private static readonly System.Text.Json.JsonEncodedText PropTotalVecSize = System.Text.Json.JsonEncodedText.Encode("total_vec_size");
	private static readonly System.Text.Json.JsonEncodedText PropTotalVecSizeBytes = System.Text.Json.JsonEncodedText.Encode("total_vec_size_bytes");
	private static readonly System.Text.Json.JsonEncodedText PropTotalVeqSize = System.Text.Json.JsonEncodedText.Encode("total_veq_size");
	private static readonly System.Text.Json.JsonEncodedText PropTotalVeqSizeBytes = System.Text.Json.JsonEncodedText.Encode("total_veq_size_bytes");
	private static readonly System.Text.Json.JsonEncodedText PropTotalVexSize = System.Text.Json.JsonEncodedText.Encode("total_vex_size");
	private static readonly System.Text.Json.JsonEncodedText PropTotalVexSizeBytes = System.Text.Json.JsonEncodedText.Encode("total_vex_size_bytes");

	public override Elastic.Clients.Elasticsearch.Cluster.DenseVectorOffHeapStats Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		reader.ValidateToken(System.Text.Json.JsonTokenType.StartObject);
		LocalJsonValue<System.Collections.Generic.IReadOnlyDictionary<string, System.Collections.Generic.IReadOnlyDictionary<string, long>>?> propFielddata = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.ByteSize?> propTotalSize = default;
		LocalJsonValue<long> propTotalSizeBytes = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.ByteSize?> propTotalVebSize = default;
		LocalJsonValue<long> propTotalVebSizeBytes = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.ByteSize?> propTotalVecSize = default;
		LocalJsonValue<long> propTotalVecSizeBytes = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.ByteSize?> propTotalVeqSize = default;
		LocalJsonValue<long> propTotalVeqSizeBytes = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.ByteSize?> propTotalVexSize = default;
		LocalJsonValue<long> propTotalVexSizeBytes = default;
		while (reader.Read() && reader.TokenType is System.Text.Json.JsonTokenType.PropertyName)
		{
			if (propFielddata.TryReadProperty(ref reader, options, PropFielddata, static System.Collections.Generic.IReadOnlyDictionary<string, System.Collections.Generic.IReadOnlyDictionary<string, long>>? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadDictionaryValue<string, System.Collections.Generic.IReadOnlyDictionary<string, long>>(o, null, static System.Collections.Generic.IReadOnlyDictionary<string, long> (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadDictionaryValue<string, long>(o, null, null)!)))
			{
				continue;
			}

			if (propTotalSize.TryReadProperty(ref reader, options, PropTotalSize, null))
			{
				continue;
			}

			if (propTotalSizeBytes.TryReadProperty(ref reader, options, PropTotalSizeBytes, null))
			{
				continue;
			}

			if (propTotalVebSize.TryReadProperty(ref reader, options, PropTotalVebSize, null))
			{
				continue;
			}

			if (propTotalVebSizeBytes.TryReadProperty(ref reader, options, PropTotalVebSizeBytes, null))
			{
				continue;
			}

			if (propTotalVecSize.TryReadProperty(ref reader, options, PropTotalVecSize, null))
			{
				continue;
			}

			if (propTotalVecSizeBytes.TryReadProperty(ref reader, options, PropTotalVecSizeBytes, null))
			{
				continue;
			}

			if (propTotalVeqSize.TryReadProperty(ref reader, options, PropTotalVeqSize, null))
			{
				continue;
			}

			if (propTotalVeqSizeBytes.TryReadProperty(ref reader, options, PropTotalVeqSizeBytes, null))
			{
				continue;
			}

			if (propTotalVexSize.TryReadProperty(ref reader, options, PropTotalVexSize, null))
			{
				continue;
			}

			if (propTotalVexSizeBytes.TryReadProperty(ref reader, options, PropTotalVexSizeBytes, null))
			{
				continue;
			}

			if (options.UnmappedMemberHandling is System.Text.Json.Serialization.JsonUnmappedMemberHandling.Skip)
			{
				reader.SafeSkip();
				continue;
			}

			throw new System.Text.Json.JsonException($"Unknown JSON property '{reader.GetString()}' for type '{typeToConvert.Name}'.");
		}

		reader.ValidateToken(System.Text.Json.JsonTokenType.EndObject);
		return new Elastic.Clients.Elasticsearch.Cluster.DenseVectorOffHeapStats(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance)
		{
			Fielddata = propFielddata.Value,
			TotalSize = propTotalSize.Value,
			TotalSizeBytes = propTotalSizeBytes.Value,
			TotalVebSize = propTotalVebSize.Value,
			TotalVebSizeBytes = propTotalVebSizeBytes.Value,
			TotalVecSize = propTotalVecSize.Value,
			TotalVecSizeBytes = propTotalVecSizeBytes.Value,
			TotalVeqSize = propTotalVeqSize.Value,
			TotalVeqSizeBytes = propTotalVeqSizeBytes.Value,
			TotalVexSize = propTotalVexSize.Value,
			TotalVexSizeBytes = propTotalVexSizeBytes.Value
		};
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Cluster.DenseVectorOffHeapStats value, System.Text.Json.JsonSerializerOptions options)
	{
		writer.WriteStartObject();
		writer.WriteProperty(options, PropFielddata, value.Fielddata, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, System.Collections.Generic.IReadOnlyDictionary<string, System.Collections.Generic.IReadOnlyDictionary<string, long>>? v) => w.WriteDictionaryValue<string, System.Collections.Generic.IReadOnlyDictionary<string, long>>(o, v, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, System.Collections.Generic.IReadOnlyDictionary<string, long> v) => w.WriteDictionaryValue<string, long>(o, v, null, null)));
		writer.WriteProperty(options, PropTotalSize, value.TotalSize, null, null);
		writer.WriteProperty(options, PropTotalSizeBytes, value.TotalSizeBytes, null, null);
		writer.WriteProperty(options, PropTotalVebSize, value.TotalVebSize, null, null);
		writer.WriteProperty(options, PropTotalVebSizeBytes, value.TotalVebSizeBytes, null, null);
		writer.WriteProperty(options, PropTotalVecSize, value.TotalVecSize, null, null);
		writer.WriteProperty(options, PropTotalVecSizeBytes, value.TotalVecSizeBytes, null, null);
		writer.WriteProperty(options, PropTotalVeqSize, value.TotalVeqSize, null, null);
		writer.WriteProperty(options, PropTotalVeqSizeBytes, value.TotalVeqSizeBytes, null, null);
		writer.WriteProperty(options, PropTotalVexSize, value.TotalVexSize, null, null);
		writer.WriteProperty(options, PropTotalVexSizeBytes, value.TotalVexSizeBytes, null, null);
		writer.WriteEndObject();
	}
}