// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Cluster.Json;

public sealed partial class DecisionConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.Cluster.Decision>
{
	private static readonly System.Text.Json.JsonEncodedText MemberAllocationDelayed = System.Text.Json.JsonEncodedText.Encode("allocation_delayed");
	private static readonly System.Text.Json.JsonEncodedText MemberAwaitingInfo = System.Text.Json.JsonEncodedText.Encode("awaiting_info");
	private static readonly System.Text.Json.JsonEncodedText MemberNo = System.Text.Json.JsonEncodedText.Encode("no");
	private static readonly System.Text.Json.JsonEncodedText MemberNoAttempt = System.Text.Json.JsonEncodedText.Encode("no_attempt");
	private static readonly System.Text.Json.JsonEncodedText MemberNoValidShardCopy = System.Text.Json.JsonEncodedText.Encode("no_valid_shard_copy");
	private static readonly System.Text.Json.JsonEncodedText MemberThrottled = System.Text.Json.JsonEncodedText.Encode("throttled");
	private static readonly System.Text.Json.JsonEncodedText MemberWorseBalance = System.Text.Json.JsonEncodedText.Encode("worse_balance");
	private static readonly System.Text.Json.JsonEncodedText MemberYes = System.Text.Json.JsonEncodedText.Encode("yes");

	public override Elastic.Clients.Elasticsearch.Cluster.Decision Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		if (reader.ValueTextEquals(MemberAllocationDelayed))
		{
			return Elastic.Clients.Elasticsearch.Cluster.Decision.AllocationDelayed;
		}

		if (reader.ValueTextEquals(MemberAwaitingInfo))
		{
			return Elastic.Clients.Elasticsearch.Cluster.Decision.AwaitingInfo;
		}

		if (reader.ValueTextEquals(MemberNo))
		{
			return Elastic.Clients.Elasticsearch.Cluster.Decision.No;
		}

		if (reader.ValueTextEquals(MemberNoAttempt))
		{
			return Elastic.Clients.Elasticsearch.Cluster.Decision.NoAttempt;
		}

		if (reader.ValueTextEquals(MemberNoValidShardCopy))
		{
			return Elastic.Clients.Elasticsearch.Cluster.Decision.NoValidShardCopy;
		}

		if (reader.ValueTextEquals(MemberThrottled))
		{
			return Elastic.Clients.Elasticsearch.Cluster.Decision.Throttled;
		}

		if (reader.ValueTextEquals(MemberWorseBalance))
		{
			return Elastic.Clients.Elasticsearch.Cluster.Decision.WorseBalance;
		}

		if (reader.ValueTextEquals(MemberYes))
		{
			return Elastic.Clients.Elasticsearch.Cluster.Decision.Yes;
		}

		var value = reader.GetString()!;
		if (string.Equals(value, MemberAllocationDelayed.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Cluster.Decision.AllocationDelayed;
		}

		if (string.Equals(value, MemberAwaitingInfo.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Cluster.Decision.AwaitingInfo;
		}

		if (string.Equals(value, MemberNo.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Cluster.Decision.No;
		}

		if (string.Equals(value, MemberNoAttempt.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Cluster.Decision.NoAttempt;
		}

		if (string.Equals(value, MemberNoValidShardCopy.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Cluster.Decision.NoValidShardCopy;
		}

		if (string.Equals(value, MemberThrottled.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Cluster.Decision.Throttled;
		}

		if (string.Equals(value, MemberWorseBalance.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Cluster.Decision.WorseBalance;
		}

		if (string.Equals(value, MemberYes.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Cluster.Decision.Yes;
		}

		throw new System.Text.Json.JsonException($"Unknown member '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.Cluster.Decision)}'.");
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Cluster.Decision value, System.Text.Json.JsonSerializerOptions options)
	{
		switch (value)
		{
			case Elastic.Clients.Elasticsearch.Cluster.Decision.AllocationDelayed:
				writer.WriteStringValue(MemberAllocationDelayed);
				break;
			case Elastic.Clients.Elasticsearch.Cluster.Decision.AwaitingInfo:
				writer.WriteStringValue(MemberAwaitingInfo);
				break;
			case Elastic.Clients.Elasticsearch.Cluster.Decision.No:
				writer.WriteStringValue(MemberNo);
				break;
			case Elastic.Clients.Elasticsearch.Cluster.Decision.NoAttempt:
				writer.WriteStringValue(MemberNoAttempt);
				break;
			case Elastic.Clients.Elasticsearch.Cluster.Decision.NoValidShardCopy:
				writer.WriteStringValue(MemberNoValidShardCopy);
				break;
			case Elastic.Clients.Elasticsearch.Cluster.Decision.Throttled:
				writer.WriteStringValue(MemberThrottled);
				break;
			case Elastic.Clients.Elasticsearch.Cluster.Decision.WorseBalance:
				writer.WriteStringValue(MemberWorseBalance);
				break;
			case Elastic.Clients.Elasticsearch.Cluster.Decision.Yes:
				writer.WriteStringValue(MemberYes);
				break;
			default:
				throw new System.Text.Json.JsonException($"Invalid value '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.Cluster.Decision)}'.");
		}
	}

	public override Elastic.Clients.Elasticsearch.Cluster.Decision ReadAsPropertyName(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		return Read(ref reader, typeToConvert, options);
	}

	public override void WriteAsPropertyName(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Cluster.Decision value, System.Text.Json.JsonSerializerOptions options)
	{
		Write(writer, value, options);
	}
}