// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Cluster;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Cluster.Json.ClusterProcessOpenFileDescriptorsConverter))]
public sealed partial class ClusterProcessOpenFileDescriptors
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public ClusterProcessOpenFileDescriptors(long avg, long max, long min)
	{
		Avg = avg;
		Max = max;
		Min = min;
	}
#if NET7_0_OR_GREATER
	public ClusterProcessOpenFileDescriptors()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public ClusterProcessOpenFileDescriptors()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal ClusterProcessOpenFileDescriptors(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// Average number of concurrently open file descriptors.
	/// Returns <c>-1</c> if not supported.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	long Avg { get; set; }

	/// <summary>
	/// <para>
	/// Maximum number of concurrently open file descriptors allowed across all selected nodes.
	/// Returns <c>-1</c> if not supported.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	long Max { get; set; }

	/// <summary>
	/// <para>
	/// Minimum number of concurrently open file descriptors across all selected nodes.
	/// Returns -1 if not supported.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	long Min { get; set; }
}