// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Cluster;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Cluster.Json.ClusterOperatingSystemConverter))]
public sealed partial class ClusterOperatingSystem
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public ClusterOperatingSystem(int allocatedProcessors, int availableProcessors, Elastic.Clients.Elasticsearch.Cluster.OperatingSystemMemoryInfo mem, System.Collections.Generic.IReadOnlyCollection<Elastic.Clients.Elasticsearch.Cluster.ClusterOperatingSystemName> names, System.Collections.Generic.IReadOnlyCollection<Elastic.Clients.Elasticsearch.Cluster.ClusterOperatingSystemPrettyName> prettyNames)
	{
		AllocatedProcessors = allocatedProcessors;
		AvailableProcessors = availableProcessors;
		Mem = mem;
		Names = names;
		PrettyNames = prettyNames;
	}
#if NET7_0_OR_GREATER
	public ClusterOperatingSystem()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public ClusterOperatingSystem()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal ClusterOperatingSystem(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// Number of processors used to calculate thread pool size across all selected nodes.
	/// This number can be set with the processors setting of a node and defaults to the number of processors reported by the operating system.
	/// In both cases, this number will never be larger than 32.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	int AllocatedProcessors { get; set; }

	/// <summary>
	/// <para>
	/// Contains statistics about processor architectures (for example, x86_64 or aarch64) used by selected nodes.
	/// </para>
	/// </summary>
	public System.Collections.Generic.IReadOnlyCollection<Elastic.Clients.Elasticsearch.Cluster.ClusterOperatingSystemArchitecture>? Architectures { get; set; }

	/// <summary>
	/// <para>
	/// Number of processors available to JVM across all selected nodes.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	int AvailableProcessors { get; set; }

	/// <summary>
	/// <para>
	/// Contains statistics about memory used by selected nodes.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Cluster.OperatingSystemMemoryInfo Mem { get; set; }

	/// <summary>
	/// <para>
	/// Contains statistics about operating systems used by selected nodes.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	System.Collections.Generic.IReadOnlyCollection<Elastic.Clients.Elasticsearch.Cluster.ClusterOperatingSystemName> Names { get; set; }

	/// <summary>
	/// <para>
	/// Contains statistics about operating systems used by selected nodes.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	System.Collections.Generic.IReadOnlyCollection<Elastic.Clients.Elasticsearch.Cluster.ClusterOperatingSystemPrettyName> PrettyNames { get; set; }
}