// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Cluster;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Cluster.Json.ClusterNodesConverter))]
public sealed partial class ClusterNodes
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public ClusterNodes(Elastic.Clients.Elasticsearch.Cluster.ClusterNodeCount count, System.Collections.Generic.IReadOnlyDictionary<string, int> discoveryTypes, Elastic.Clients.Elasticsearch.Cluster.ClusterFileSystem fs, Elastic.Clients.Elasticsearch.Cluster.IndexingPressure indexingPressure, Elastic.Clients.Elasticsearch.Cluster.ClusterIngest ingest, Elastic.Clients.Elasticsearch.Cluster.ClusterJvm jvm, Elastic.Clients.Elasticsearch.Cluster.ClusterNetworkTypes networkTypes, Elastic.Clients.Elasticsearch.Cluster.ClusterOperatingSystem os, System.Collections.Generic.IReadOnlyCollection<Elastic.Clients.Elasticsearch.Cluster.NodePackagingType> packagingTypes, System.Collections.Generic.IReadOnlyCollection<Elastic.Clients.Elasticsearch.PluginStats> plugins, Elastic.Clients.Elasticsearch.Cluster.ClusterProcess process, System.Collections.Generic.IReadOnlyCollection<string> versions)
	{
		Count = count;
		DiscoveryTypes = discoveryTypes;
		Fs = fs;
		IndexingPressure = indexingPressure;
		Ingest = ingest;
		Jvm = jvm;
		NetworkTypes = networkTypes;
		Os = os;
		PackagingTypes = packagingTypes;
		Plugins = plugins;
		Process = process;
		Versions = versions;
	}
#if NET7_0_OR_GREATER
	public ClusterNodes()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public ClusterNodes()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal ClusterNodes(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// Contains counts for nodes selected by the request’s node filters.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Cluster.ClusterNodeCount Count { get; set; }

	/// <summary>
	/// <para>
	/// Contains statistics about the discovery types used by selected nodes.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	System.Collections.Generic.IReadOnlyDictionary<string, int> DiscoveryTypes { get; set; }

	/// <summary>
	/// <para>
	/// Contains statistics about file stores by selected nodes.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Cluster.ClusterFileSystem Fs { get; set; }
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Cluster.IndexingPressure IndexingPressure { get; set; }
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Cluster.ClusterIngest Ingest { get; set; }

	/// <summary>
	/// <para>
	/// Contains statistics about the Java Virtual Machines (JVMs) used by selected nodes.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Cluster.ClusterJvm Jvm { get; set; }

	/// <summary>
	/// <para>
	/// Contains statistics about the transport and HTTP networks used by selected nodes.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Cluster.ClusterNetworkTypes NetworkTypes { get; set; }

	/// <summary>
	/// <para>
	/// Contains statistics about the operating systems used by selected nodes.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Cluster.ClusterOperatingSystem Os { get; set; }

	/// <summary>
	/// <para>
	/// Contains statistics about Elasticsearch distributions installed on selected nodes.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	System.Collections.Generic.IReadOnlyCollection<Elastic.Clients.Elasticsearch.Cluster.NodePackagingType> PackagingTypes { get; set; }

	/// <summary>
	/// <para>
	/// Contains statistics about installed plugins and modules by selected nodes.
	/// If no plugins or modules are installed, this array is empty.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	System.Collections.Generic.IReadOnlyCollection<Elastic.Clients.Elasticsearch.PluginStats> Plugins { get; set; }

	/// <summary>
	/// <para>
	/// Contains statistics about processes used by selected nodes.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Cluster.ClusterProcess Process { get; set; }

	/// <summary>
	/// <para>
	/// Array of Elasticsearch versions used on selected nodes.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	System.Collections.Generic.IReadOnlyCollection<string> Versions { get; set; }
}