// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Cluster.Json;

public sealed partial class ClusterNodesConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.Cluster.ClusterNodes>
{
	private static readonly System.Text.Json.JsonEncodedText PropCount = System.Text.Json.JsonEncodedText.Encode("count");
	private static readonly System.Text.Json.JsonEncodedText PropDiscoveryTypes = System.Text.Json.JsonEncodedText.Encode("discovery_types");
	private static readonly System.Text.Json.JsonEncodedText PropFs = System.Text.Json.JsonEncodedText.Encode("fs");
	private static readonly System.Text.Json.JsonEncodedText PropIndexingPressure = System.Text.Json.JsonEncodedText.Encode("indexing_pressure");
	private static readonly System.Text.Json.JsonEncodedText PropIngest = System.Text.Json.JsonEncodedText.Encode("ingest");
	private static readonly System.Text.Json.JsonEncodedText PropJvm = System.Text.Json.JsonEncodedText.Encode("jvm");
	private static readonly System.Text.Json.JsonEncodedText PropNetworkTypes = System.Text.Json.JsonEncodedText.Encode("network_types");
	private static readonly System.Text.Json.JsonEncodedText PropOs = System.Text.Json.JsonEncodedText.Encode("os");
	private static readonly System.Text.Json.JsonEncodedText PropPackagingTypes = System.Text.Json.JsonEncodedText.Encode("packaging_types");
	private static readonly System.Text.Json.JsonEncodedText PropPlugins = System.Text.Json.JsonEncodedText.Encode("plugins");
	private static readonly System.Text.Json.JsonEncodedText PropProcess = System.Text.Json.JsonEncodedText.Encode("process");
	private static readonly System.Text.Json.JsonEncodedText PropVersions = System.Text.Json.JsonEncodedText.Encode("versions");

	public override Elastic.Clients.Elasticsearch.Cluster.ClusterNodes Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		reader.ValidateToken(System.Text.Json.JsonTokenType.StartObject);
		LocalJsonValue<Elastic.Clients.Elasticsearch.Cluster.ClusterNodeCount> propCount = default;
		LocalJsonValue<System.Collections.Generic.IReadOnlyDictionary<string, int>> propDiscoveryTypes = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.Cluster.ClusterFileSystem> propFs = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.Cluster.IndexingPressure> propIndexingPressure = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.Cluster.ClusterIngest> propIngest = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.Cluster.ClusterJvm> propJvm = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.Cluster.ClusterNetworkTypes> propNetworkTypes = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.Cluster.ClusterOperatingSystem> propOs = default;
		LocalJsonValue<System.Collections.Generic.IReadOnlyCollection<Elastic.Clients.Elasticsearch.Cluster.NodePackagingType>> propPackagingTypes = default;
		LocalJsonValue<System.Collections.Generic.IReadOnlyCollection<Elastic.Clients.Elasticsearch.PluginStats>> propPlugins = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.Cluster.ClusterProcess> propProcess = default;
		LocalJsonValue<System.Collections.Generic.IReadOnlyCollection<string>> propVersions = default;
		while (reader.Read() && reader.TokenType is System.Text.Json.JsonTokenType.PropertyName)
		{
			if (propCount.TryReadProperty(ref reader, options, PropCount, null))
			{
				continue;
			}

			if (propDiscoveryTypes.TryReadProperty(ref reader, options, PropDiscoveryTypes, static System.Collections.Generic.IReadOnlyDictionary<string, int> (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadDictionaryValue<string, int>(o, null, null)!))
			{
				continue;
			}

			if (propFs.TryReadProperty(ref reader, options, PropFs, null))
			{
				continue;
			}

			if (propIndexingPressure.TryReadProperty(ref reader, options, PropIndexingPressure, null))
			{
				continue;
			}

			if (propIngest.TryReadProperty(ref reader, options, PropIngest, null))
			{
				continue;
			}

			if (propJvm.TryReadProperty(ref reader, options, PropJvm, null))
			{
				continue;
			}

			if (propNetworkTypes.TryReadProperty(ref reader, options, PropNetworkTypes, null))
			{
				continue;
			}

			if (propOs.TryReadProperty(ref reader, options, PropOs, null))
			{
				continue;
			}

			if (propPackagingTypes.TryReadProperty(ref reader, options, PropPackagingTypes, static System.Collections.Generic.IReadOnlyCollection<Elastic.Clients.Elasticsearch.Cluster.NodePackagingType> (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadCollectionValue<Elastic.Clients.Elasticsearch.Cluster.NodePackagingType>(o, null)!))
			{
				continue;
			}

			if (propPlugins.TryReadProperty(ref reader, options, PropPlugins, static System.Collections.Generic.IReadOnlyCollection<Elastic.Clients.Elasticsearch.PluginStats> (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadCollectionValue<Elastic.Clients.Elasticsearch.PluginStats>(o, null)!))
			{
				continue;
			}

			if (propProcess.TryReadProperty(ref reader, options, PropProcess, null))
			{
				continue;
			}

			if (propVersions.TryReadProperty(ref reader, options, PropVersions, static System.Collections.Generic.IReadOnlyCollection<string> (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadCollectionValue<string>(o, null)!))
			{
				continue;
			}

			if (options.UnmappedMemberHandling is System.Text.Json.Serialization.JsonUnmappedMemberHandling.Skip)
			{
				reader.SafeSkip();
				continue;
			}

			throw new System.Text.Json.JsonException($"Unknown JSON property '{reader.GetString()}' for type '{typeToConvert.Name}'.");
		}

		reader.ValidateToken(System.Text.Json.JsonTokenType.EndObject);
		return new Elastic.Clients.Elasticsearch.Cluster.ClusterNodes(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance)
		{
			Count = propCount.Value,
			DiscoveryTypes = propDiscoveryTypes.Value,
			Fs = propFs.Value,
			IndexingPressure = propIndexingPressure.Value,
			Ingest = propIngest.Value,
			Jvm = propJvm.Value,
			NetworkTypes = propNetworkTypes.Value,
			Os = propOs.Value,
			PackagingTypes = propPackagingTypes.Value,
			Plugins = propPlugins.Value,
			Process = propProcess.Value,
			Versions = propVersions.Value
		};
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Cluster.ClusterNodes value, System.Text.Json.JsonSerializerOptions options)
	{
		writer.WriteStartObject();
		writer.WriteProperty(options, PropCount, value.Count, null, null);
		writer.WriteProperty(options, PropDiscoveryTypes, value.DiscoveryTypes, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, System.Collections.Generic.IReadOnlyDictionary<string, int> v) => w.WriteDictionaryValue<string, int>(o, v, null, null));
		writer.WriteProperty(options, PropFs, value.Fs, null, null);
		writer.WriteProperty(options, PropIndexingPressure, value.IndexingPressure, null, null);
		writer.WriteProperty(options, PropIngest, value.Ingest, null, null);
		writer.WriteProperty(options, PropJvm, value.Jvm, null, null);
		writer.WriteProperty(options, PropNetworkTypes, value.NetworkTypes, null, null);
		writer.WriteProperty(options, PropOs, value.Os, null, null);
		writer.WriteProperty(options, PropPackagingTypes, value.PackagingTypes, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, System.Collections.Generic.IReadOnlyCollection<Elastic.Clients.Elasticsearch.Cluster.NodePackagingType> v) => w.WriteCollectionValue<Elastic.Clients.Elasticsearch.Cluster.NodePackagingType>(o, v, null));
		writer.WriteProperty(options, PropPlugins, value.Plugins, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, System.Collections.Generic.IReadOnlyCollection<Elastic.Clients.Elasticsearch.PluginStats> v) => w.WriteCollectionValue<Elastic.Clients.Elasticsearch.PluginStats>(o, v, null));
		writer.WriteProperty(options, PropProcess, value.Process, null, null);
		writer.WriteProperty(options, PropVersions, value.Versions, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, System.Collections.Generic.IReadOnlyCollection<string> v) => w.WriteCollectionValue<string>(o, v, null));
		writer.WriteEndObject();
	}
}