// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Cluster;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Cluster.Json.ClusterJvmVersionConverter))]
public sealed partial class ClusterJvmVersion
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public ClusterJvmVersion(bool bundledJdk, int count, bool usingBundledJdk, string version, string vmName, string vmVendor, string vmVersion)
	{
		BundledJdk = bundledJdk;
		Count = count;
		UsingBundledJdk = usingBundledJdk;
		Version = version;
		VmName = vmName;
		VmVendor = vmVendor;
		VmVersion = vmVersion;
	}
#if NET7_0_OR_GREATER
	public ClusterJvmVersion()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public ClusterJvmVersion()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal ClusterJvmVersion(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// Always <c>true</c>. All distributions come with a bundled Java Development Kit (JDK).
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	bool BundledJdk { get; set; }

	/// <summary>
	/// <para>
	/// Total number of selected nodes using JVM.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	int Count { get; set; }

	/// <summary>
	/// <para>
	/// If <c>true</c>, a bundled JDK is in use by JVM.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	bool UsingBundledJdk { get; set; }

	/// <summary>
	/// <para>
	/// Version of JVM used by one or more selected nodes.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	string Version { get; set; }

	/// <summary>
	/// <para>
	/// Name of the JVM.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	string VmName { get; set; }

	/// <summary>
	/// <para>
	/// Vendor of the JVM.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	string VmVendor { get; set; }

	/// <summary>
	/// <para>
	/// Full version number of JVM.
	/// The full version number includes a plus sign (+) followed by the build number.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	string VmVersion { get; set; }
}