// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Cluster;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Cluster.Json.ClusterJvmConverter))]
public sealed partial class ClusterJvm
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public ClusterJvm(System.TimeSpan maxUptimeInMillis, Elastic.Clients.Elasticsearch.Cluster.ClusterJvmMemory mem, long threads, System.Collections.Generic.IReadOnlyCollection<Elastic.Clients.Elasticsearch.Cluster.ClusterJvmVersion> versions)
	{
		MaxUptimeInMillis = maxUptimeInMillis;
		Mem = mem;
		Threads = threads;
		Versions = versions;
	}
#if NET7_0_OR_GREATER
	public ClusterJvm()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public ClusterJvm()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal ClusterJvm(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// Uptime duration since JVM last started.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Duration? MaxUptime { get; set; }

	/// <summary>
	/// <para>
	/// Uptime duration, in milliseconds, since JVM last started.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	System.TimeSpan MaxUptimeInMillis { get; set; }

	/// <summary>
	/// <para>
	/// Contains statistics about memory used by selected nodes.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Cluster.ClusterJvmMemory Mem { get; set; }

	/// <summary>
	/// <para>
	/// Number of active threads in use by JVM across all selected nodes.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	long Threads { get; set; }

	/// <summary>
	/// <para>
	/// Contains statistics about the JVM versions used by selected nodes.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	System.Collections.Generic.IReadOnlyCollection<Elastic.Clients.Elasticsearch.Cluster.ClusterJvmVersion> Versions { get; set; }
}