// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Cluster;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Cluster.Json.ClusterIndicesShardsIndexConverter))]
public sealed partial class ClusterIndicesShardsIndex
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public ClusterIndicesShardsIndex(Elastic.Clients.Elasticsearch.Cluster.ClusterShardMetrics primaries, Elastic.Clients.Elasticsearch.Cluster.ClusterShardMetrics replication, Elastic.Clients.Elasticsearch.Cluster.ClusterShardMetrics shards)
	{
		Primaries = primaries;
		Replication = replication;
		Shards = shards;
	}
#if NET7_0_OR_GREATER
	public ClusterIndicesShardsIndex()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public ClusterIndicesShardsIndex()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal ClusterIndicesShardsIndex(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// Contains statistics about the number of primary shards assigned to selected nodes.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Cluster.ClusterShardMetrics Primaries { get; set; }

	/// <summary>
	/// <para>
	/// Contains statistics about the number of replication shards assigned to selected nodes.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Cluster.ClusterShardMetrics Replication { get; set; }

	/// <summary>
	/// <para>
	/// Contains statistics about the number of shards assigned to selected nodes.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Cluster.ClusterShardMetrics Shards { get; set; }
}