// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Cluster;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Cluster.Json.ClusterIndicesConverter))]
public sealed partial class ClusterIndices
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public ClusterIndices(Elastic.Clients.Elasticsearch.CompletionStats completion, long count, Elastic.Clients.Elasticsearch.Cluster.DenseVectorStats denseVector, Elastic.Clients.Elasticsearch.DocStats docs, Elastic.Clients.Elasticsearch.FielddataStats fielddata, Elastic.Clients.Elasticsearch.QueryCacheStats queryCache, Elastic.Clients.Elasticsearch.Cluster.SearchUsageStats search, Elastic.Clients.Elasticsearch.SegmentsStats segments, Elastic.Clients.Elasticsearch.Cluster.ClusterIndicesShards shards, Elastic.Clients.Elasticsearch.Cluster.SparseVectorStats sparseVector, Elastic.Clients.Elasticsearch.StoreStats store)
	{
		Completion = completion;
		Count = count;
		DenseVector = denseVector;
		Docs = docs;
		Fielddata = fielddata;
		QueryCache = queryCache;
		Search = search;
		Segments = segments;
		Shards = shards;
		SparseVector = sparseVector;
		Store = store;
	}
#if NET7_0_OR_GREATER
	public ClusterIndices()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public ClusterIndices()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal ClusterIndices(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// Contains statistics about analyzers and analyzer components used in selected nodes.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Cluster.CharFilterTypes? Analysis { get; set; }

	/// <summary>
	/// <para>
	/// Contains statistics about memory used for completion in selected nodes.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.CompletionStats Completion { get; set; }

	/// <summary>
	/// <para>
	/// Total number of indices with shards assigned to selected nodes.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	long Count { get; set; }

	/// <summary>
	/// <para>
	/// Contains statistics about indexed dense vector
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Cluster.DenseVectorStats DenseVector { get; set; }

	/// <summary>
	/// <para>
	/// Contains counts for documents in selected nodes.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.DocStats Docs { get; set; }

	/// <summary>
	/// <para>
	/// Contains statistics about the field data cache of selected nodes.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.FielddataStats Fielddata { get; set; }

	/// <summary>
	/// <para>
	/// Contains statistics about field mappings in selected nodes.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Cluster.FieldTypesMappings? Mappings { get; set; }

	/// <summary>
	/// <para>
	/// Contains statistics about the query cache of selected nodes.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.QueryCacheStats QueryCache { get; set; }

	/// <summary>
	/// <para>
	/// Holds a snapshot of the search usage statistics.
	/// Used to hold the stats for a single node that's part of a ClusterStatsNodeResponse, as well as to
	/// accumulate stats for the entire cluster and return them as part of the ClusterStatsResponse.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Cluster.SearchUsageStats Search { get; set; }

	/// <summary>
	/// <para>
	/// Contains statistics about segments in selected nodes.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.SegmentsStats Segments { get; set; }

	/// <summary>
	/// <para>
	/// Contains statistics about indices with shards assigned to selected nodes.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Cluster.ClusterIndicesShards Shards { get; set; }

	/// <summary>
	/// <para>
	/// Contains statistics about indexed sparse vector
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Cluster.SparseVectorStats SparseVector { get; set; }

	/// <summary>
	/// <para>
	/// Contains statistics about the size of shards assigned to selected nodes.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.StoreStats Store { get; set; }

	/// <summary>
	/// <para>
	/// Contains statistics about analyzers and analyzer components used in selected nodes.
	/// </para>
	/// </summary>
	public System.Collections.Generic.IReadOnlyCollection<Elastic.Clients.Elasticsearch.Cluster.IndicesVersions>? Versions { get; set; }
}