// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Cluster.Json;

public sealed partial class ClusterIndicesConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.Cluster.ClusterIndices>
{
	private static readonly System.Text.Json.JsonEncodedText PropAnalysis = System.Text.Json.JsonEncodedText.Encode("analysis");
	private static readonly System.Text.Json.JsonEncodedText PropCompletion = System.Text.Json.JsonEncodedText.Encode("completion");
	private static readonly System.Text.Json.JsonEncodedText PropCount = System.Text.Json.JsonEncodedText.Encode("count");
	private static readonly System.Text.Json.JsonEncodedText PropDenseVector = System.Text.Json.JsonEncodedText.Encode("dense_vector");
	private static readonly System.Text.Json.JsonEncodedText PropDocs = System.Text.Json.JsonEncodedText.Encode("docs");
	private static readonly System.Text.Json.JsonEncodedText PropFielddata = System.Text.Json.JsonEncodedText.Encode("fielddata");
	private static readonly System.Text.Json.JsonEncodedText PropMappings = System.Text.Json.JsonEncodedText.Encode("mappings");
	private static readonly System.Text.Json.JsonEncodedText PropQueryCache = System.Text.Json.JsonEncodedText.Encode("query_cache");
	private static readonly System.Text.Json.JsonEncodedText PropSearch = System.Text.Json.JsonEncodedText.Encode("search");
	private static readonly System.Text.Json.JsonEncodedText PropSegments = System.Text.Json.JsonEncodedText.Encode("segments");
	private static readonly System.Text.Json.JsonEncodedText PropShards = System.Text.Json.JsonEncodedText.Encode("shards");
	private static readonly System.Text.Json.JsonEncodedText PropSparseVector = System.Text.Json.JsonEncodedText.Encode("sparse_vector");
	private static readonly System.Text.Json.JsonEncodedText PropStore = System.Text.Json.JsonEncodedText.Encode("store");
	private static readonly System.Text.Json.JsonEncodedText PropVersions = System.Text.Json.JsonEncodedText.Encode("versions");

	public override Elastic.Clients.Elasticsearch.Cluster.ClusterIndices Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		reader.ValidateToken(System.Text.Json.JsonTokenType.StartObject);
		LocalJsonValue<Elastic.Clients.Elasticsearch.Cluster.CharFilterTypes?> propAnalysis = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.CompletionStats> propCompletion = default;
		LocalJsonValue<long> propCount = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.Cluster.DenseVectorStats> propDenseVector = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.DocStats> propDocs = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.FielddataStats> propFielddata = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.Cluster.FieldTypesMappings?> propMappings = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.QueryCacheStats> propQueryCache = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.Cluster.SearchUsageStats> propSearch = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.SegmentsStats> propSegments = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.Cluster.ClusterIndicesShards> propShards = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.Cluster.SparseVectorStats> propSparseVector = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.StoreStats> propStore = default;
		LocalJsonValue<System.Collections.Generic.IReadOnlyCollection<Elastic.Clients.Elasticsearch.Cluster.IndicesVersions>?> propVersions = default;
		while (reader.Read() && reader.TokenType is System.Text.Json.JsonTokenType.PropertyName)
		{
			if (propAnalysis.TryReadProperty(ref reader, options, PropAnalysis, null))
			{
				continue;
			}

			if (propCompletion.TryReadProperty(ref reader, options, PropCompletion, null))
			{
				continue;
			}

			if (propCount.TryReadProperty(ref reader, options, PropCount, null))
			{
				continue;
			}

			if (propDenseVector.TryReadProperty(ref reader, options, PropDenseVector, null))
			{
				continue;
			}

			if (propDocs.TryReadProperty(ref reader, options, PropDocs, null))
			{
				continue;
			}

			if (propFielddata.TryReadProperty(ref reader, options, PropFielddata, null))
			{
				continue;
			}

			if (propMappings.TryReadProperty(ref reader, options, PropMappings, null))
			{
				continue;
			}

			if (propQueryCache.TryReadProperty(ref reader, options, PropQueryCache, null))
			{
				continue;
			}

			if (propSearch.TryReadProperty(ref reader, options, PropSearch, null))
			{
				continue;
			}

			if (propSegments.TryReadProperty(ref reader, options, PropSegments, null))
			{
				continue;
			}

			if (propShards.TryReadProperty(ref reader, options, PropShards, null))
			{
				continue;
			}

			if (propSparseVector.TryReadProperty(ref reader, options, PropSparseVector, null))
			{
				continue;
			}

			if (propStore.TryReadProperty(ref reader, options, PropStore, null))
			{
				continue;
			}

			if (propVersions.TryReadProperty(ref reader, options, PropVersions, static System.Collections.Generic.IReadOnlyCollection<Elastic.Clients.Elasticsearch.Cluster.IndicesVersions>? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadCollectionValue<Elastic.Clients.Elasticsearch.Cluster.IndicesVersions>(o, null)))
			{
				continue;
			}

			if (options.UnmappedMemberHandling is System.Text.Json.Serialization.JsonUnmappedMemberHandling.Skip)
			{
				reader.SafeSkip();
				continue;
			}

			throw new System.Text.Json.JsonException($"Unknown JSON property '{reader.GetString()}' for type '{typeToConvert.Name}'.");
		}

		reader.ValidateToken(System.Text.Json.JsonTokenType.EndObject);
		return new Elastic.Clients.Elasticsearch.Cluster.ClusterIndices(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance)
		{
			Analysis = propAnalysis.Value,
			Completion = propCompletion.Value,
			Count = propCount.Value,
			DenseVector = propDenseVector.Value,
			Docs = propDocs.Value,
			Fielddata = propFielddata.Value,
			Mappings = propMappings.Value,
			QueryCache = propQueryCache.Value,
			Search = propSearch.Value,
			Segments = propSegments.Value,
			Shards = propShards.Value,
			SparseVector = propSparseVector.Value,
			Store = propStore.Value,
			Versions = propVersions.Value
		};
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Cluster.ClusterIndices value, System.Text.Json.JsonSerializerOptions options)
	{
		writer.WriteStartObject();
		writer.WriteProperty(options, PropAnalysis, value.Analysis, null, null);
		writer.WriteProperty(options, PropCompletion, value.Completion, null, null);
		writer.WriteProperty(options, PropCount, value.Count, null, null);
		writer.WriteProperty(options, PropDenseVector, value.DenseVector, null, null);
		writer.WriteProperty(options, PropDocs, value.Docs, null, null);
		writer.WriteProperty(options, PropFielddata, value.Fielddata, null, null);
		writer.WriteProperty(options, PropMappings, value.Mappings, null, null);
		writer.WriteProperty(options, PropQueryCache, value.QueryCache, null, null);
		writer.WriteProperty(options, PropSearch, value.Search, null, null);
		writer.WriteProperty(options, PropSegments, value.Segments, null, null);
		writer.WriteProperty(options, PropShards, value.Shards, null, null);
		writer.WriteProperty(options, PropSparseVector, value.SparseVector, null, null);
		writer.WriteProperty(options, PropStore, value.Store, null, null);
		writer.WriteProperty(options, PropVersions, value.Versions, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, System.Collections.Generic.IReadOnlyCollection<Elastic.Clients.Elasticsearch.Cluster.IndicesVersions>? v) => w.WriteCollectionValue<Elastic.Clients.Elasticsearch.Cluster.IndicesVersions>(o, v, null));
		writer.WriteEndObject();
	}
}