// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Cluster;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Cluster.Json.ClusterFileSystemConverter))]
public sealed partial class ClusterFileSystem
{
#if NET7_0_OR_GREATER
	public ClusterFileSystem()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public ClusterFileSystem()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal ClusterFileSystem(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// Total number of bytes available to JVM in file stores across all selected nodes.
	/// Depending on operating system or process-level restrictions, this number may be less than <c>nodes.fs.free_in_byes</c>.
	/// This is the actual amount of free disk space the selected Elasticsearch nodes can use.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.ByteSize? Available { get; set; }

	/// <summary>
	/// <para>
	/// Total number of bytes available to JVM in file stores across all selected nodes.
	/// Depending on operating system or process-level restrictions, this number may be less than <c>nodes.fs.free_in_byes</c>.
	/// This is the actual amount of free disk space the selected Elasticsearch nodes can use.
	/// </para>
	/// </summary>
	public long? AvailableInBytes { get; set; }
	public Elastic.Clients.Elasticsearch.ByteSize? FloodStageFreeSpace { get; set; }
	public long? FloodStageFreeSpaceInBytes { get; set; }

	/// <summary>
	/// <para>
	/// Total number of unallocated bytes in file stores across all selected nodes.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.ByteSize? Free { get; set; }

	/// <summary>
	/// <para>
	/// Total number, in bytes, of unallocated bytes in file stores across all selected nodes.
	/// </para>
	/// </summary>
	public long? FreeInBytes { get; set; }
	public Elastic.Clients.Elasticsearch.ByteSize? FrozenFloodStageFreeSpace { get; set; }
	public long? FrozenFloodStageFreeSpaceInBytes { get; set; }
	public Elastic.Clients.Elasticsearch.ByteSize? HighWatermarkFreeSpace { get; set; }
	public long? HighWatermarkFreeSpaceInBytes { get; set; }
	public Elastic.Clients.Elasticsearch.ByteSize? LowWatermarkFreeSpace { get; set; }
	public long? LowWatermarkFreeSpaceInBytes { get; set; }
	public string? Mount { get; set; }
	public string? Path { get; set; }

	/// <summary>
	/// <para>
	/// Total size of all file stores across all selected nodes.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.ByteSize? Total { get; set; }

	/// <summary>
	/// <para>
	/// Total size, in bytes, of all file stores across all selected nodes.
	/// </para>
	/// </summary>
	public long? TotalInBytes { get; set; }
	public string? Type { get; set; }
}