// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Cluster;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Cluster.Json.CCSUsageStatsConverter))]
public sealed partial class CCSUsageStats
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public CCSUsageStats(System.Collections.Generic.IReadOnlyDictionary<string, int> clients, System.Collections.Generic.IReadOnlyDictionary<string, Elastic.Clients.Elasticsearch.Cluster.CCSUsageClusterStats> clusters, System.Collections.Generic.IReadOnlyDictionary<string, int> failureReasons, System.Collections.Generic.IReadOnlyDictionary<string, int> features, double remotesPerSearchAvg, int remotesPerSearchMax, int skipped, int success, Elastic.Clients.Elasticsearch.Cluster.CCSUsageTimeValue took, int total)
	{
		Clients = clients;
		Clusters = clusters;
		FailureReasons = failureReasons;
		Features = features;
		RemotesPerSearchAvg = remotesPerSearchAvg;
		RemotesPerSearchMax = remotesPerSearchMax;
		Skipped = skipped;
		Success = success;
		Took = took;
		Total = total;
	}
#if NET7_0_OR_GREATER
	public CCSUsageStats()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public CCSUsageStats()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal CCSUsageStats(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// Statistics about the clients that executed cross-cluster search requests. The keys are the names of the clients, and the values are the number of requests that were executed by that client. Only known clients (such as <c>kibana</c> or <c>elasticsearch</c>) are counted.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	System.Collections.Generic.IReadOnlyDictionary<string, int> Clients { get; set; }

	/// <summary>
	/// <para>
	/// Statistics about the clusters that were queried in cross-cluster search requests. The keys are cluster names, and the values are per-cluster telemetry data. This also includes the local cluster itself, which uses the name <c>(local)</c>.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	System.Collections.Generic.IReadOnlyDictionary<string, Elastic.Clients.Elasticsearch.Cluster.CCSUsageClusterStats> Clusters { get; set; }

	/// <summary>
	/// <para>
	/// Statistics about the reasons for cross-cluster search request failures. The keys are the failure reason names and the values are the number of requests that failed for that reason.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	System.Collections.Generic.IReadOnlyDictionary<string, int> FailureReasons { get; set; }

	/// <summary>
	/// <para>
	/// The keys are the names of the search feature, and the values are the number of requests that used that feature. Single request can use more than one feature (e.g. both <c>async</c> and <c>wildcard</c>).
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	System.Collections.Generic.IReadOnlyDictionary<string, int> Features { get; set; }

	/// <summary>
	/// <para>
	/// The average number of remote clusters that were queried in a single cross-cluster search request.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	double RemotesPerSearchAvg { get; set; }

	/// <summary>
	/// <para>
	/// The maximum number of remote clusters that were queried in a single cross-cluster search request.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	int RemotesPerSearchMax { get; set; }

	/// <summary>
	/// <para>
	/// The total number of cross-cluster search requests (successful or failed) that had at least one remote cluster skipped.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	int Skipped { get; set; }

	/// <summary>
	/// <para>
	/// The total number of cross-cluster search requests that have been successfully executed by the cluster.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	int Success { get; set; }

	/// <summary>
	/// <para>
	/// Statistics about the time taken to execute cross-cluster search requests.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Cluster.CCSUsageTimeValue Took { get; set; }

	/// <summary>
	/// <para>
	/// Statistics about the time taken to execute cross-cluster search requests for which the <c>ccs_minimize_roundtrips</c> setting was set to <c>false</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Cluster.CCSUsageTimeValue? TookMrtFalse { get; set; }

	/// <summary>
	/// <para>
	/// Statistics about the time taken to execute cross-cluster search requests for which the <c>ccs_minimize_roundtrips</c> setting was set to <c>true</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Cluster.CCSUsageTimeValue? TookMrtTrue { get; set; }

	/// <summary>
	/// <para>
	/// The total number of cross-cluster search requests that have been executed by the cluster.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	int Total { get; set; }
}