// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Cluster;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Cluster.Json.CCSStatsConverter))]
public sealed partial class CCSStats
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public CCSStats(Elastic.Clients.Elasticsearch.Cluster.CCSUsageStats search)
	{
		Search = search;
	}
#if NET7_0_OR_GREATER
	public CCSStats()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public CCSStats()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal CCSStats(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// Contains remote cluster settings and metrics collected from them.
	/// The keys are cluster names, and the values are per-cluster data.
	/// Only present if <c>include_remotes</c> option is set to true.
	/// </para>
	/// </summary>
	public System.Collections.Generic.IReadOnlyDictionary<string, Elastic.Clients.Elasticsearch.Cluster.RemoteClusterInfo>? Clusters { get; set; }

	/// <summary>
	/// <para>
	/// Information about ES|QL cross-cluster query usage.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Cluster.CCSUsageStats? Esql { get; set; }

	/// <summary>
	/// <para>
	/// Information about cross-cluster search usage.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Cluster.CCSUsageStats Search { get; set; }
}