// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Cluster.Json;

public sealed partial class AllocationStoreConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.Cluster.AllocationStore>
{
	private static readonly System.Text.Json.JsonEncodedText PropAllocationId = System.Text.Json.JsonEncodedText.Encode("allocation_id");
	private static readonly System.Text.Json.JsonEncodedText PropFound = System.Text.Json.JsonEncodedText.Encode("found");
	private static readonly System.Text.Json.JsonEncodedText PropInSync = System.Text.Json.JsonEncodedText.Encode("in_sync");
	private static readonly System.Text.Json.JsonEncodedText PropMatchingSizeInBytes = System.Text.Json.JsonEncodedText.Encode("matching_size_in_bytes");
	private static readonly System.Text.Json.JsonEncodedText PropMatchingSyncId = System.Text.Json.JsonEncodedText.Encode("matching_sync_id");
	private static readonly System.Text.Json.JsonEncodedText PropStoreException = System.Text.Json.JsonEncodedText.Encode("store_exception");

	public override Elastic.Clients.Elasticsearch.Cluster.AllocationStore Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		reader.ValidateToken(System.Text.Json.JsonTokenType.StartObject);
		LocalJsonValue<string> propAllocationId = default;
		LocalJsonValue<bool> propFound = default;
		LocalJsonValue<bool> propInSync = default;
		LocalJsonValue<long> propMatchingSizeInBytes = default;
		LocalJsonValue<bool> propMatchingSyncId = default;
		LocalJsonValue<string> propStoreException = default;
		while (reader.Read() && reader.TokenType is System.Text.Json.JsonTokenType.PropertyName)
		{
			if (propAllocationId.TryReadProperty(ref reader, options, PropAllocationId, null))
			{
				continue;
			}

			if (propFound.TryReadProperty(ref reader, options, PropFound, null))
			{
				continue;
			}

			if (propInSync.TryReadProperty(ref reader, options, PropInSync, null))
			{
				continue;
			}

			if (propMatchingSizeInBytes.TryReadProperty(ref reader, options, PropMatchingSizeInBytes, null))
			{
				continue;
			}

			if (propMatchingSyncId.TryReadProperty(ref reader, options, PropMatchingSyncId, null))
			{
				continue;
			}

			if (propStoreException.TryReadProperty(ref reader, options, PropStoreException, null))
			{
				continue;
			}

			if (options.UnmappedMemberHandling is System.Text.Json.Serialization.JsonUnmappedMemberHandling.Skip)
			{
				reader.SafeSkip();
				continue;
			}

			throw new System.Text.Json.JsonException($"Unknown JSON property '{reader.GetString()}' for type '{typeToConvert.Name}'.");
		}

		reader.ValidateToken(System.Text.Json.JsonTokenType.EndObject);
		return new Elastic.Clients.Elasticsearch.Cluster.AllocationStore(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance)
		{
			AllocationId = propAllocationId.Value,
			Found = propFound.Value,
			InSync = propInSync.Value,
			MatchingSizeInBytes = propMatchingSizeInBytes.Value,
			MatchingSyncId = propMatchingSyncId.Value,
			StoreException = propStoreException.Value
		};
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Cluster.AllocationStore value, System.Text.Json.JsonSerializerOptions options)
	{
		writer.WriteStartObject();
		writer.WriteProperty(options, PropAllocationId, value.AllocationId, null, null);
		writer.WriteProperty(options, PropFound, value.Found, null, null);
		writer.WriteProperty(options, PropInSync, value.InSync, null, null);
		writer.WriteProperty(options, PropMatchingSizeInBytes, value.MatchingSizeInBytes, null, null);
		writer.WriteProperty(options, PropMatchingSyncId, value.MatchingSyncId, null, null);
		writer.WriteProperty(options, PropStoreException, value.StoreException, null, null);
		writer.WriteEndObject();
	}
}