// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Cluster.Json;

public sealed partial class AllocationExplainDecisionConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.Cluster.AllocationExplainDecision>
{
	private static readonly System.Text.Json.JsonEncodedText MemberAlways = System.Text.Json.JsonEncodedText.Encode("ALWAYS");
	private static readonly System.Text.Json.JsonEncodedText MemberNo = System.Text.Json.JsonEncodedText.Encode("NO");
	private static readonly System.Text.Json.JsonEncodedText MemberThrottle = System.Text.Json.JsonEncodedText.Encode("THROTTLE");
	private static readonly System.Text.Json.JsonEncodedText MemberYes = System.Text.Json.JsonEncodedText.Encode("YES");

	public override Elastic.Clients.Elasticsearch.Cluster.AllocationExplainDecision Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		if (reader.ValueTextEquals(MemberAlways))
		{
			return Elastic.Clients.Elasticsearch.Cluster.AllocationExplainDecision.Always;
		}

		if (reader.ValueTextEquals(MemberNo))
		{
			return Elastic.Clients.Elasticsearch.Cluster.AllocationExplainDecision.No;
		}

		if (reader.ValueTextEquals(MemberThrottle))
		{
			return Elastic.Clients.Elasticsearch.Cluster.AllocationExplainDecision.Throttle;
		}

		if (reader.ValueTextEquals(MemberYes))
		{
			return Elastic.Clients.Elasticsearch.Cluster.AllocationExplainDecision.Yes;
		}

		var value = reader.GetString()!;
		if (string.Equals(value, MemberAlways.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Cluster.AllocationExplainDecision.Always;
		}

		if (string.Equals(value, MemberNo.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Cluster.AllocationExplainDecision.No;
		}

		if (string.Equals(value, MemberThrottle.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Cluster.AllocationExplainDecision.Throttle;
		}

		if (string.Equals(value, MemberYes.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Cluster.AllocationExplainDecision.Yes;
		}

		throw new System.Text.Json.JsonException($"Unknown member '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.Cluster.AllocationExplainDecision)}'.");
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Cluster.AllocationExplainDecision value, System.Text.Json.JsonSerializerOptions options)
	{
		switch (value)
		{
			case Elastic.Clients.Elasticsearch.Cluster.AllocationExplainDecision.Always:
				writer.WriteStringValue(MemberAlways);
				break;
			case Elastic.Clients.Elasticsearch.Cluster.AllocationExplainDecision.No:
				writer.WriteStringValue(MemberNo);
				break;
			case Elastic.Clients.Elasticsearch.Cluster.AllocationExplainDecision.Throttle:
				writer.WriteStringValue(MemberThrottle);
				break;
			case Elastic.Clients.Elasticsearch.Cluster.AllocationExplainDecision.Yes:
				writer.WriteStringValue(MemberYes);
				break;
			default:
				throw new System.Text.Json.JsonException($"Invalid value '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.Cluster.AllocationExplainDecision)}'.");
		}
	}

	public override Elastic.Clients.Elasticsearch.Cluster.AllocationExplainDecision ReadAsPropertyName(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		return Read(ref reader, typeToConvert, options);
	}

	public override void WriteAsPropertyName(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Cluster.AllocationExplainDecision value, System.Text.Json.JsonSerializerOptions options)
	{
		Write(writer, value, options);
	}
}