// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.AsyncSearch;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.AsyncSearch.Json.AsyncSearchConverterFactory))]
public partial class AsyncSearch<TDocument>
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public AsyncSearch(Elastic.Clients.Elasticsearch.Core.Search.HitsMetadata<TDocument> hitsMetadata, Elastic.Clients.Elasticsearch.ShardStatistics shards, bool timedOut, long took)
	{
		HitsMetadata = hitsMetadata;
		Shards = shards;
		TimedOut = timedOut;
		Took = took;
	}
#if NET7_0_OR_GREATER
	public AsyncSearch()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public AsyncSearch()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal AsyncSearch(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// Partial aggregations results, coming from the shards that have already completed running the query.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Aggregations.AggregateDictionary? Aggregations { get; set; }
	public Elastic.Clients.Elasticsearch.ClusterStatistics? Clusters { get; set; }
	public System.Collections.Generic.IReadOnlyDictionary<string, object>? Fields { get; set; }
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Core.Search.HitsMetadata<TDocument> HitsMetadata { get; set; }
	public double? MaxScore { get; set; }

	/// <summary>
	/// <para>
	/// Indicates how many reductions of the results have been performed.
	/// If this number increases compared to the last retrieved results for a get asynch search request, you can expect additional results included in the search response.
	/// </para>
	/// </summary>
	public long? NumReducePhases { get; set; }
	public string? PitId { get; set; }
	public Elastic.Clients.Elasticsearch.Core.Search.Profile? Profile { get; set; }
	public Elastic.Clients.Elasticsearch.ScrollId? ScrollId { get; set; }

	/// <summary>
	/// <para>
	/// Indicates how many shards have run the query.
	/// Note that in order for shard results to be included in the search response, they need to be reduced first.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.ShardStatistics Shards { get; set; }
	public Elastic.Clients.Elasticsearch.Core.Search.SuggestDictionary<TDocument>? Suggest { get; set; }
	public bool? TerminatedEarly { get; set; }
	public
#if NET7_0_OR_GREATER
	required
#endif
	bool TimedOut { get; set; }
	public
#if NET7_0_OR_GREATER
	required
#endif
	long Took { get; set; }
}