// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Analysis;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Analysis.Json.WordDelimiterGraphTokenFilterConverter))]
public sealed partial class WordDelimiterGraphTokenFilter : Elastic.Clients.Elasticsearch.Analysis.ITokenFilter
{
#if NET7_0_OR_GREATER
	public WordDelimiterGraphTokenFilter()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public WordDelimiterGraphTokenFilter()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal WordDelimiterGraphTokenFilter(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// If <c>true</c>, the filter adjusts the offsets of split or catenated tokens to better reflect their actual position in the token stream. Defaults to <c>true</c>.
	/// </para>
	/// </summary>
	public bool? AdjustOffsets { get; set; }

	/// <summary>
	/// <para>
	/// If <c>true</c>, the filter produces catenated tokens for chains of alphanumeric characters separated by non-alphabetic delimiters. Defaults to <c>false</c>.
	/// </para>
	/// </summary>
	public bool? CatenateAll { get; set; }

	/// <summary>
	/// <para>
	/// If <c>true</c>, the filter produces catenated tokens for chains of numeric characters separated by non-alphabetic delimiters. Defaults to <c>false</c>.
	/// </para>
	/// </summary>
	public bool? CatenateNumbers { get; set; }

	/// <summary>
	/// <para>
	/// If <c>true</c>, the filter produces catenated tokens for chains of alphabetical characters separated by non-alphabetic delimiters. Defaults to <c>false</c>.
	/// </para>
	/// </summary>
	public bool? CatenateWords { get; set; }

	/// <summary>
	/// <para>
	/// If <c>true</c>, the filter includes tokens consisting of only numeric characters in the output. If <c>false</c>, the filter excludes these tokens from the output. Defaults to <c>true</c>.
	/// </para>
	/// </summary>
	public bool? GenerateNumberParts { get; set; }

	/// <summary>
	/// <para>
	/// If <c>true</c>, the filter includes tokens consisting of only alphabetical characters in the output. If <c>false</c>, the filter excludes these tokens from the output. Defaults to <c>true</c>.
	/// </para>
	/// </summary>
	public bool? GenerateWordParts { get; set; }

	/// <summary>
	/// <para>
	/// If <c>true</c>, the filter skips tokens with a keyword attribute of true. Defaults to <c>false</c>.
	/// </para>
	/// </summary>
	public bool? IgnoreKeywords { get; set; }

	/// <summary>
	/// <para>
	/// If <c>true</c>, the filter includes the original version of any split tokens in the output. This original version includes non-alphanumeric delimiters. Defaults to <c>false</c>.
	/// </para>
	/// </summary>
	public bool? PreserveOriginal { get; set; }

	/// <summary>
	/// <para>
	/// Array of tokens the filter won’t split.
	/// </para>
	/// </summary>
	public System.Collections.Generic.ICollection<string>? ProtectedWords { get; set; }

	/// <summary>
	/// <para>
	/// Path to a file that contains a list of tokens the filter won’t split.
	/// This path must be absolute or relative to the <c>config</c> location, and the file must be UTF-8 encoded. Each token in the file must be separated by a line break.
	/// </para>
	/// </summary>
	public string? ProtectedWordsPath { get; set; }

	/// <summary>
	/// <para>
	/// If <c>true</c>, the filter splits tokens at letter case transitions. For example: camelCase -> [ camel, Case ]. Defaults to <c>true</c>.
	/// </para>
	/// </summary>
	public bool? SplitOnCaseChange { get; set; }

	/// <summary>
	/// <para>
	/// If <c>true</c>, the filter splits tokens at letter-number transitions. For example: j2se -> [ j, 2, se ]. Defaults to <c>true</c>.
	/// </para>
	/// </summary>
	public bool? SplitOnNumerics { get; set; }

	/// <summary>
	/// <para>
	/// If <c>true</c>, the filter removes the English possessive (<c>'s</c>) from the end of each token. For example: O'Neil's -> [ O, Neil ]. Defaults to <c>true</c>.
	/// </para>
	/// </summary>
	public bool? StemEnglishPossessive { get; set; }

	public string Type => "word_delimiter_graph";

	/// <summary>
	/// <para>
	/// Array of custom type mappings for characters. This allows you to map non-alphanumeric characters as numeric or alphanumeric to avoid splitting on those characters.
	/// </para>
	/// </summary>
	public System.Collections.Generic.ICollection<string>? TypeTable { get; set; }

	/// <summary>
	/// <para>
	/// Path to a file that contains custom type mappings for characters. This allows you to map non-alphanumeric characters as numeric or alphanumeric to avoid splitting on those characters.
	/// </para>
	/// </summary>
	public string? TypeTablePath { get; set; }
	public string? Version { get; set; }
}

public readonly partial struct WordDelimiterGraphTokenFilterDescriptor
{
	internal Elastic.Clients.Elasticsearch.Analysis.WordDelimiterGraphTokenFilter Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public WordDelimiterGraphTokenFilterDescriptor(Elastic.Clients.Elasticsearch.Analysis.WordDelimiterGraphTokenFilter instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public WordDelimiterGraphTokenFilterDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Analysis.WordDelimiterGraphTokenFilter(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Analysis.WordDelimiterGraphTokenFilterDescriptor(Elastic.Clients.Elasticsearch.Analysis.WordDelimiterGraphTokenFilter instance) => new Elastic.Clients.Elasticsearch.Analysis.WordDelimiterGraphTokenFilterDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Analysis.WordDelimiterGraphTokenFilter(Elastic.Clients.Elasticsearch.Analysis.WordDelimiterGraphTokenFilterDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// If <c>true</c>, the filter adjusts the offsets of split or catenated tokens to better reflect their actual position in the token stream. Defaults to <c>true</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Analysis.WordDelimiterGraphTokenFilterDescriptor AdjustOffsets(bool? value = true)
	{
		Instance.AdjustOffsets = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If <c>true</c>, the filter produces catenated tokens for chains of alphanumeric characters separated by non-alphabetic delimiters. Defaults to <c>false</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Analysis.WordDelimiterGraphTokenFilterDescriptor CatenateAll(bool? value = true)
	{
		Instance.CatenateAll = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If <c>true</c>, the filter produces catenated tokens for chains of numeric characters separated by non-alphabetic delimiters. Defaults to <c>false</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Analysis.WordDelimiterGraphTokenFilterDescriptor CatenateNumbers(bool? value = true)
	{
		Instance.CatenateNumbers = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If <c>true</c>, the filter produces catenated tokens for chains of alphabetical characters separated by non-alphabetic delimiters. Defaults to <c>false</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Analysis.WordDelimiterGraphTokenFilterDescriptor CatenateWords(bool? value = true)
	{
		Instance.CatenateWords = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If <c>true</c>, the filter includes tokens consisting of only numeric characters in the output. If <c>false</c>, the filter excludes these tokens from the output. Defaults to <c>true</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Analysis.WordDelimiterGraphTokenFilterDescriptor GenerateNumberParts(bool? value = true)
	{
		Instance.GenerateNumberParts = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If <c>true</c>, the filter includes tokens consisting of only alphabetical characters in the output. If <c>false</c>, the filter excludes these tokens from the output. Defaults to <c>true</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Analysis.WordDelimiterGraphTokenFilterDescriptor GenerateWordParts(bool? value = true)
	{
		Instance.GenerateWordParts = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If <c>true</c>, the filter skips tokens with a keyword attribute of true. Defaults to <c>false</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Analysis.WordDelimiterGraphTokenFilterDescriptor IgnoreKeywords(bool? value = true)
	{
		Instance.IgnoreKeywords = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If <c>true</c>, the filter includes the original version of any split tokens in the output. This original version includes non-alphanumeric delimiters. Defaults to <c>false</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Analysis.WordDelimiterGraphTokenFilterDescriptor PreserveOriginal(bool? value = true)
	{
		Instance.PreserveOriginal = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Array of tokens the filter won’t split.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Analysis.WordDelimiterGraphTokenFilterDescriptor ProtectedWords(System.Collections.Generic.ICollection<string>? value)
	{
		Instance.ProtectedWords = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Array of tokens the filter won’t split.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Analysis.WordDelimiterGraphTokenFilterDescriptor ProtectedWords(params string[] values)
	{
		Instance.ProtectedWords = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// Path to a file that contains a list of tokens the filter won’t split.
	/// This path must be absolute or relative to the <c>config</c> location, and the file must be UTF-8 encoded. Each token in the file must be separated by a line break.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Analysis.WordDelimiterGraphTokenFilterDescriptor ProtectedWordsPath(string? value)
	{
		Instance.ProtectedWordsPath = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If <c>true</c>, the filter splits tokens at letter case transitions. For example: camelCase -> [ camel, Case ]. Defaults to <c>true</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Analysis.WordDelimiterGraphTokenFilterDescriptor SplitOnCaseChange(bool? value = true)
	{
		Instance.SplitOnCaseChange = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If <c>true</c>, the filter splits tokens at letter-number transitions. For example: j2se -> [ j, 2, se ]. Defaults to <c>true</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Analysis.WordDelimiterGraphTokenFilterDescriptor SplitOnNumerics(bool? value = true)
	{
		Instance.SplitOnNumerics = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If <c>true</c>, the filter removes the English possessive (<c>'s</c>) from the end of each token. For example: O'Neil's -> [ O, Neil ]. Defaults to <c>true</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Analysis.WordDelimiterGraphTokenFilterDescriptor StemEnglishPossessive(bool? value = true)
	{
		Instance.StemEnglishPossessive = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Array of custom type mappings for characters. This allows you to map non-alphanumeric characters as numeric or alphanumeric to avoid splitting on those characters.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Analysis.WordDelimiterGraphTokenFilterDescriptor TypeTable(System.Collections.Generic.ICollection<string>? value)
	{
		Instance.TypeTable = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Array of custom type mappings for characters. This allows you to map non-alphanumeric characters as numeric or alphanumeric to avoid splitting on those characters.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Analysis.WordDelimiterGraphTokenFilterDescriptor TypeTable(params string[] values)
	{
		Instance.TypeTable = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// Path to a file that contains custom type mappings for characters. This allows you to map non-alphanumeric characters as numeric or alphanumeric to avoid splitting on those characters.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Analysis.WordDelimiterGraphTokenFilterDescriptor TypeTablePath(string? value)
	{
		Instance.TypeTablePath = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.WordDelimiterGraphTokenFilterDescriptor Version(string? value)
	{
		Instance.Version = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Analysis.WordDelimiterGraphTokenFilter Build(System.Action<Elastic.Clients.Elasticsearch.Analysis.WordDelimiterGraphTokenFilterDescriptor>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.Analysis.WordDelimiterGraphTokenFilter(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.Analysis.WordDelimiterGraphTokenFilterDescriptor(new Elastic.Clients.Elasticsearch.Analysis.WordDelimiterGraphTokenFilter(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}