// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Analysis.Json;

public sealed partial class WordDelimiterGraphTokenFilterConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.Analysis.WordDelimiterGraphTokenFilter>
{
	private static readonly System.Text.Json.JsonEncodedText PropAdjustOffsets = System.Text.Json.JsonEncodedText.Encode("adjust_offsets");
	private static readonly System.Text.Json.JsonEncodedText PropCatenateAll = System.Text.Json.JsonEncodedText.Encode("catenate_all");
	private static readonly System.Text.Json.JsonEncodedText PropCatenateNumbers = System.Text.Json.JsonEncodedText.Encode("catenate_numbers");
	private static readonly System.Text.Json.JsonEncodedText PropCatenateWords = System.Text.Json.JsonEncodedText.Encode("catenate_words");
	private static readonly System.Text.Json.JsonEncodedText PropGenerateNumberParts = System.Text.Json.JsonEncodedText.Encode("generate_number_parts");
	private static readonly System.Text.Json.JsonEncodedText PropGenerateWordParts = System.Text.Json.JsonEncodedText.Encode("generate_word_parts");
	private static readonly System.Text.Json.JsonEncodedText PropIgnoreKeywords = System.Text.Json.JsonEncodedText.Encode("ignore_keywords");
	private static readonly System.Text.Json.JsonEncodedText PropPreserveOriginal = System.Text.Json.JsonEncodedText.Encode("preserve_original");
	private static readonly System.Text.Json.JsonEncodedText PropProtectedWords = System.Text.Json.JsonEncodedText.Encode("protected_words");
	private static readonly System.Text.Json.JsonEncodedText PropProtectedWordsPath = System.Text.Json.JsonEncodedText.Encode("protected_words_path");
	private static readonly System.Text.Json.JsonEncodedText PropSplitOnCaseChange = System.Text.Json.JsonEncodedText.Encode("split_on_case_change");
	private static readonly System.Text.Json.JsonEncodedText PropSplitOnNumerics = System.Text.Json.JsonEncodedText.Encode("split_on_numerics");
	private static readonly System.Text.Json.JsonEncodedText PropStemEnglishPossessive = System.Text.Json.JsonEncodedText.Encode("stem_english_possessive");
	private static readonly System.Text.Json.JsonEncodedText PropType = System.Text.Json.JsonEncodedText.Encode("type");
	private static readonly System.Text.Json.JsonEncodedText PropTypeTable = System.Text.Json.JsonEncodedText.Encode("type_table");
	private static readonly System.Text.Json.JsonEncodedText PropTypeTablePath = System.Text.Json.JsonEncodedText.Encode("type_table_path");
	private static readonly System.Text.Json.JsonEncodedText PropVersion = System.Text.Json.JsonEncodedText.Encode("version");

	public override Elastic.Clients.Elasticsearch.Analysis.WordDelimiterGraphTokenFilter Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		reader.ValidateToken(System.Text.Json.JsonTokenType.StartObject);
		LocalJsonValue<bool?> propAdjustOffsets = default;
		LocalJsonValue<bool?> propCatenateAll = default;
		LocalJsonValue<bool?> propCatenateNumbers = default;
		LocalJsonValue<bool?> propCatenateWords = default;
		LocalJsonValue<bool?> propGenerateNumberParts = default;
		LocalJsonValue<bool?> propGenerateWordParts = default;
		LocalJsonValue<bool?> propIgnoreKeywords = default;
		LocalJsonValue<bool?> propPreserveOriginal = default;
		LocalJsonValue<System.Collections.Generic.ICollection<string>?> propProtectedWords = default;
		LocalJsonValue<string?> propProtectedWordsPath = default;
		LocalJsonValue<bool?> propSplitOnCaseChange = default;
		LocalJsonValue<bool?> propSplitOnNumerics = default;
		LocalJsonValue<bool?> propStemEnglishPossessive = default;
		LocalJsonValue<System.Collections.Generic.ICollection<string>?> propTypeTable = default;
		LocalJsonValue<string?> propTypeTablePath = default;
		LocalJsonValue<string?> propVersion = default;
		while (reader.Read() && reader.TokenType is System.Text.Json.JsonTokenType.PropertyName)
		{
			if (propAdjustOffsets.TryReadProperty(ref reader, options, PropAdjustOffsets, static bool? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<bool>(o)))
			{
				continue;
			}

			if (propCatenateAll.TryReadProperty(ref reader, options, PropCatenateAll, static bool? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<bool>(o)))
			{
				continue;
			}

			if (propCatenateNumbers.TryReadProperty(ref reader, options, PropCatenateNumbers, static bool? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<bool>(o)))
			{
				continue;
			}

			if (propCatenateWords.TryReadProperty(ref reader, options, PropCatenateWords, static bool? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<bool>(o)))
			{
				continue;
			}

			if (propGenerateNumberParts.TryReadProperty(ref reader, options, PropGenerateNumberParts, static bool? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<bool>(o)))
			{
				continue;
			}

			if (propGenerateWordParts.TryReadProperty(ref reader, options, PropGenerateWordParts, static bool? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<bool>(o)))
			{
				continue;
			}

			if (propIgnoreKeywords.TryReadProperty(ref reader, options, PropIgnoreKeywords, static bool? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<bool>(o)))
			{
				continue;
			}

			if (propPreserveOriginal.TryReadProperty(ref reader, options, PropPreserveOriginal, static bool? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<bool>(o)))
			{
				continue;
			}

			if (propProtectedWords.TryReadProperty(ref reader, options, PropProtectedWords, static System.Collections.Generic.ICollection<string>? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadCollectionValue<string>(o, null)))
			{
				continue;
			}

			if (propProtectedWordsPath.TryReadProperty(ref reader, options, PropProtectedWordsPath, null))
			{
				continue;
			}

			if (propSplitOnCaseChange.TryReadProperty(ref reader, options, PropSplitOnCaseChange, static bool? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<bool>(o)))
			{
				continue;
			}

			if (propSplitOnNumerics.TryReadProperty(ref reader, options, PropSplitOnNumerics, static bool? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<bool>(o)))
			{
				continue;
			}

			if (propStemEnglishPossessive.TryReadProperty(ref reader, options, PropStemEnglishPossessive, static bool? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<bool>(o)))
			{
				continue;
			}

			if (reader.ValueTextEquals(PropType))
			{
				reader.SafeSkip();
				continue;
			}

			if (propTypeTable.TryReadProperty(ref reader, options, PropTypeTable, static System.Collections.Generic.ICollection<string>? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadCollectionValue<string>(o, null)))
			{
				continue;
			}

			if (propTypeTablePath.TryReadProperty(ref reader, options, PropTypeTablePath, null))
			{
				continue;
			}

			if (propVersion.TryReadProperty(ref reader, options, PropVersion, null))
			{
				continue;
			}

			if (options.UnmappedMemberHandling is System.Text.Json.Serialization.JsonUnmappedMemberHandling.Skip)
			{
				reader.SafeSkip();
				continue;
			}

			throw new System.Text.Json.JsonException($"Unknown JSON property '{reader.GetString()}' for type '{typeToConvert.Name}'.");
		}

		reader.ValidateToken(System.Text.Json.JsonTokenType.EndObject);
		return new Elastic.Clients.Elasticsearch.Analysis.WordDelimiterGraphTokenFilter(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance)
		{
			AdjustOffsets = propAdjustOffsets.Value,
			CatenateAll = propCatenateAll.Value,
			CatenateNumbers = propCatenateNumbers.Value,
			CatenateWords = propCatenateWords.Value,
			GenerateNumberParts = propGenerateNumberParts.Value,
			GenerateWordParts = propGenerateWordParts.Value,
			IgnoreKeywords = propIgnoreKeywords.Value,
			PreserveOriginal = propPreserveOriginal.Value,
			ProtectedWords = propProtectedWords.Value,
			ProtectedWordsPath = propProtectedWordsPath.Value,
			SplitOnCaseChange = propSplitOnCaseChange.Value,
			SplitOnNumerics = propSplitOnNumerics.Value,
			StemEnglishPossessive = propStemEnglishPossessive.Value,
			TypeTable = propTypeTable.Value,
			TypeTablePath = propTypeTablePath.Value,
			Version = propVersion.Value
		};
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Analysis.WordDelimiterGraphTokenFilter value, System.Text.Json.JsonSerializerOptions options)
	{
		writer.WriteStartObject();
		writer.WriteProperty(options, PropAdjustOffsets, value.AdjustOffsets, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, bool? v) => w.WriteNullableValue<bool>(o, v));
		writer.WriteProperty(options, PropCatenateAll, value.CatenateAll, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, bool? v) => w.WriteNullableValue<bool>(o, v));
		writer.WriteProperty(options, PropCatenateNumbers, value.CatenateNumbers, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, bool? v) => w.WriteNullableValue<bool>(o, v));
		writer.WriteProperty(options, PropCatenateWords, value.CatenateWords, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, bool? v) => w.WriteNullableValue<bool>(o, v));
		writer.WriteProperty(options, PropGenerateNumberParts, value.GenerateNumberParts, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, bool? v) => w.WriteNullableValue<bool>(o, v));
		writer.WriteProperty(options, PropGenerateWordParts, value.GenerateWordParts, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, bool? v) => w.WriteNullableValue<bool>(o, v));
		writer.WriteProperty(options, PropIgnoreKeywords, value.IgnoreKeywords, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, bool? v) => w.WriteNullableValue<bool>(o, v));
		writer.WriteProperty(options, PropPreserveOriginal, value.PreserveOriginal, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, bool? v) => w.WriteNullableValue<bool>(o, v));
		writer.WriteProperty(options, PropProtectedWords, value.ProtectedWords, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, System.Collections.Generic.ICollection<string>? v) => w.WriteCollectionValue<string>(o, v, null));
		writer.WriteProperty(options, PropProtectedWordsPath, value.ProtectedWordsPath, null, null);
		writer.WriteProperty(options, PropSplitOnCaseChange, value.SplitOnCaseChange, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, bool? v) => w.WriteNullableValue<bool>(o, v));
		writer.WriteProperty(options, PropSplitOnNumerics, value.SplitOnNumerics, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, bool? v) => w.WriteNullableValue<bool>(o, v));
		writer.WriteProperty(options, PropStemEnglishPossessive, value.StemEnglishPossessive, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, bool? v) => w.WriteNullableValue<bool>(o, v));
		writer.WriteProperty(options, PropType, value.Type, null, null);
		writer.WriteProperty(options, PropTypeTable, value.TypeTable, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, System.Collections.Generic.ICollection<string>? v) => w.WriteCollectionValue<string>(o, v, null));
		writer.WriteProperty(options, PropTypeTablePath, value.TypeTablePath, null, null);
		writer.WriteProperty(options, PropVersion, value.Version, null, null);
		writer.WriteEndObject();
	}
}