// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Analysis;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Analysis.Json.UniqueTokenFilterConverter))]
public sealed partial class UniqueTokenFilter : Elastic.Clients.Elasticsearch.Analysis.ITokenFilter
{
#if NET7_0_OR_GREATER
	public UniqueTokenFilter()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public UniqueTokenFilter()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal UniqueTokenFilter(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// If <c>true</c>, only remove duplicate tokens in the same position. Defaults to <c>false</c>.
	/// </para>
	/// </summary>
	public bool? OnlyOnSamePosition { get; set; }

	public string Type => "unique";

	public string? Version { get; set; }
}

public readonly partial struct UniqueTokenFilterDescriptor
{
	internal Elastic.Clients.Elasticsearch.Analysis.UniqueTokenFilter Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public UniqueTokenFilterDescriptor(Elastic.Clients.Elasticsearch.Analysis.UniqueTokenFilter instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public UniqueTokenFilterDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Analysis.UniqueTokenFilter(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Analysis.UniqueTokenFilterDescriptor(Elastic.Clients.Elasticsearch.Analysis.UniqueTokenFilter instance) => new Elastic.Clients.Elasticsearch.Analysis.UniqueTokenFilterDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Analysis.UniqueTokenFilter(Elastic.Clients.Elasticsearch.Analysis.UniqueTokenFilterDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// If <c>true</c>, only remove duplicate tokens in the same position. Defaults to <c>false</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Analysis.UniqueTokenFilterDescriptor OnlyOnSamePosition(bool? value = true)
	{
		Instance.OnlyOnSamePosition = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.UniqueTokenFilterDescriptor Version(string? value)
	{
		Instance.Version = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Analysis.UniqueTokenFilter Build(System.Action<Elastic.Clients.Elasticsearch.Analysis.UniqueTokenFilterDescriptor>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.Analysis.UniqueTokenFilter(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.Analysis.UniqueTokenFilterDescriptor(new Elastic.Clients.Elasticsearch.Analysis.UniqueTokenFilter(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}