// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Analysis;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Analysis.Json.TruncateTokenFilterConverter))]
public sealed partial class TruncateTokenFilter : Elastic.Clients.Elasticsearch.Analysis.ITokenFilter
{
#if NET7_0_OR_GREATER
	public TruncateTokenFilter()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public TruncateTokenFilter()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal TruncateTokenFilter(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// Character limit for each token. Tokens exceeding this limit are truncated. Defaults to <c>10</c>.
	/// </para>
	/// </summary>
	public int? Length { get; set; }

	public string Type => "truncate";

	public string? Version { get; set; }
}

public readonly partial struct TruncateTokenFilterDescriptor
{
	internal Elastic.Clients.Elasticsearch.Analysis.TruncateTokenFilter Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public TruncateTokenFilterDescriptor(Elastic.Clients.Elasticsearch.Analysis.TruncateTokenFilter instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public TruncateTokenFilterDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Analysis.TruncateTokenFilter(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Analysis.TruncateTokenFilterDescriptor(Elastic.Clients.Elasticsearch.Analysis.TruncateTokenFilter instance) => new Elastic.Clients.Elasticsearch.Analysis.TruncateTokenFilterDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Analysis.TruncateTokenFilter(Elastic.Clients.Elasticsearch.Analysis.TruncateTokenFilterDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Character limit for each token. Tokens exceeding this limit are truncated. Defaults to <c>10</c>.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Analysis.TruncateTokenFilterDescriptor Length(int? value)
	{
		Instance.Length = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TruncateTokenFilterDescriptor Version(string? value)
	{
		Instance.Version = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Analysis.TruncateTokenFilter Build(System.Action<Elastic.Clients.Elasticsearch.Analysis.TruncateTokenFilterDescriptor>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.Analysis.TruncateTokenFilter(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.Analysis.TruncateTokenFilterDescriptor(new Elastic.Clients.Elasticsearch.Analysis.TruncateTokenFilter(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}