// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Analysis;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Analysis.Json.TokenizersConverter))]
public sealed partial class Tokenizers : Elastic.Clients.Elasticsearch.IsADictionary<string, Elastic.Clients.Elasticsearch.Analysis.ITokenizer>
{
	public Tokenizers()
	{
	}

	public Tokenizers(System.Collections.Generic.IDictionary<string, Elastic.Clients.Elasticsearch.Analysis.ITokenizer> backingDictionary) : base(backingDictionary)
	{
	}

	public void Add(string key, Elastic.Clients.Elasticsearch.Analysis.ITokenizer value) => BackingDictionary.Add(Sanitize(key), value);
	public bool TryGetTokenizer(string key, [System.Diagnostics.CodeAnalysis.NotNullWhen(returnValue: true)] out Elastic.Clients.Elasticsearch.Analysis.ITokenizer value) => BackingDictionary.TryGetValue(Sanitize(key), out value);

	public bool TryGetTokenizer<T>(string key, [System.Diagnostics.CodeAnalysis.NotNullWhen(returnValue: true)] out T? value) where T : class, ITokenizer
	{
		if (BackingDictionary.TryGetValue(Sanitize(key), out var matchedValue) && matchedValue is T finalValue)
		{
			value = finalValue;
			return true;
		}

		value = null;
		return false;
	}
}

public readonly partial struct TokenizersDescriptor
{
	private readonly Elastic.Clients.Elasticsearch.Analysis.Tokenizers _items = new();

	private Elastic.Clients.Elasticsearch.Analysis.Tokenizers Value => _items;

	public TokenizersDescriptor()
	{
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenizersDescriptor CharGroup(string key, Elastic.Clients.Elasticsearch.Analysis.CharGroupTokenizer value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenizersDescriptor CharGroup(string key, System.Action<Elastic.Clients.Elasticsearch.Analysis.CharGroupTokenizerDescriptor> action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.CharGroupTokenizerDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenizersDescriptor Classic(string key, Elastic.Clients.Elasticsearch.Analysis.ClassicTokenizer value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenizersDescriptor Classic(string key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.ClassicTokenizerDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenizersDescriptor Classic(string key, System.Action<Elastic.Clients.Elasticsearch.Analysis.ClassicTokenizerDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.ClassicTokenizerDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenizersDescriptor EdgeNGram(string key, Elastic.Clients.Elasticsearch.Analysis.EdgeNGramTokenizer value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenizersDescriptor EdgeNGram(string key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.EdgeNGramTokenizerDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenizersDescriptor EdgeNGram(string key, System.Action<Elastic.Clients.Elasticsearch.Analysis.EdgeNGramTokenizerDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.EdgeNGramTokenizerDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenizersDescriptor Icu(string key, Elastic.Clients.Elasticsearch.Analysis.IcuTokenizer value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenizersDescriptor Icu(string key, System.Action<Elastic.Clients.Elasticsearch.Analysis.IcuTokenizerDescriptor> action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.IcuTokenizerDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenizersDescriptor Keyword(string key, Elastic.Clients.Elasticsearch.Analysis.KeywordTokenizer value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenizersDescriptor Keyword(string key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.KeywordTokenizerDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenizersDescriptor Keyword(string key, System.Action<Elastic.Clients.Elasticsearch.Analysis.KeywordTokenizerDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.KeywordTokenizerDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenizersDescriptor Kuromoji(string key, Elastic.Clients.Elasticsearch.Analysis.KuromojiTokenizer value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenizersDescriptor Kuromoji(string key, System.Action<Elastic.Clients.Elasticsearch.Analysis.KuromojiTokenizerDescriptor> action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.KuromojiTokenizerDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenizersDescriptor Letter(string key, Elastic.Clients.Elasticsearch.Analysis.LetterTokenizer value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenizersDescriptor Letter(string key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.LetterTokenizerDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenizersDescriptor Letter(string key, System.Action<Elastic.Clients.Elasticsearch.Analysis.LetterTokenizerDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.LetterTokenizerDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenizersDescriptor Lowercase(string key, Elastic.Clients.Elasticsearch.Analysis.LowercaseTokenizer value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenizersDescriptor Lowercase(string key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.LowercaseTokenizerDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenizersDescriptor Lowercase(string key, System.Action<Elastic.Clients.Elasticsearch.Analysis.LowercaseTokenizerDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.LowercaseTokenizerDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenizersDescriptor NGram(string key, Elastic.Clients.Elasticsearch.Analysis.NGramTokenizer value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenizersDescriptor NGram(string key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.NGramTokenizerDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenizersDescriptor NGram(string key, System.Action<Elastic.Clients.Elasticsearch.Analysis.NGramTokenizerDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.NGramTokenizerDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenizersDescriptor Nori(string key, Elastic.Clients.Elasticsearch.Analysis.NoriTokenizer value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenizersDescriptor Nori(string key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.NoriTokenizerDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenizersDescriptor Nori(string key, System.Action<Elastic.Clients.Elasticsearch.Analysis.NoriTokenizerDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.NoriTokenizerDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenizersDescriptor PathHierarchy(string key, Elastic.Clients.Elasticsearch.Analysis.PathHierarchyTokenizer value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenizersDescriptor PathHierarchy(string key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.PathHierarchyTokenizerDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenizersDescriptor PathHierarchy(string key, System.Action<Elastic.Clients.Elasticsearch.Analysis.PathHierarchyTokenizerDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.PathHierarchyTokenizerDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenizersDescriptor Pattern(string key, Elastic.Clients.Elasticsearch.Analysis.PatternTokenizer value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenizersDescriptor Pattern(string key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.PatternTokenizerDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenizersDescriptor Pattern(string key, System.Action<Elastic.Clients.Elasticsearch.Analysis.PatternTokenizerDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.PatternTokenizerDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenizersDescriptor SimplePattern(string key, Elastic.Clients.Elasticsearch.Analysis.SimplePatternTokenizer value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenizersDescriptor SimplePattern(string key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.SimplePatternTokenizerDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenizersDescriptor SimplePattern(string key, System.Action<Elastic.Clients.Elasticsearch.Analysis.SimplePatternTokenizerDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.SimplePatternTokenizerDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenizersDescriptor SimplePatternSplit(string key, Elastic.Clients.Elasticsearch.Analysis.SimplePatternSplitTokenizer value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenizersDescriptor SimplePatternSplit(string key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.SimplePatternSplitTokenizerDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenizersDescriptor SimplePatternSplit(string key, System.Action<Elastic.Clients.Elasticsearch.Analysis.SimplePatternSplitTokenizerDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.SimplePatternSplitTokenizerDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenizersDescriptor Standard(string key, Elastic.Clients.Elasticsearch.Analysis.StandardTokenizer value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenizersDescriptor Standard(string key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.StandardTokenizerDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenizersDescriptor Standard(string key, System.Action<Elastic.Clients.Elasticsearch.Analysis.StandardTokenizerDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.StandardTokenizerDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenizersDescriptor Thai(string key, Elastic.Clients.Elasticsearch.Analysis.ThaiTokenizer value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenizersDescriptor Thai(string key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.ThaiTokenizerDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenizersDescriptor Thai(string key, System.Action<Elastic.Clients.Elasticsearch.Analysis.ThaiTokenizerDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.ThaiTokenizerDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenizersDescriptor UaxEmailUrl(string key, Elastic.Clients.Elasticsearch.Analysis.UaxEmailUrlTokenizer value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenizersDescriptor UaxEmailUrl(string key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.UaxEmailUrlTokenizerDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenizersDescriptor UaxEmailUrl(string key, System.Action<Elastic.Clients.Elasticsearch.Analysis.UaxEmailUrlTokenizerDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.UaxEmailUrlTokenizerDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenizersDescriptor Whitespace(string key, Elastic.Clients.Elasticsearch.Analysis.WhitespaceTokenizer value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenizersDescriptor Whitespace(string key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.WhitespaceTokenizerDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenizersDescriptor Whitespace(string key, System.Action<Elastic.Clients.Elasticsearch.Analysis.WhitespaceTokenizerDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.WhitespaceTokenizerDescriptor.Build(action));
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Analysis.Tokenizers Build(System.Action<Elastic.Clients.Elasticsearch.Analysis.TokenizersDescriptor>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.Analysis.Tokenizers();
		}

		var builder = new Elastic.Clients.Elasticsearch.Analysis.TokenizersDescriptor();
		action.Invoke(builder);
		return builder.Value;
	}
}