// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Analysis;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Analysis.Json.ITokenizerConverter))]
public partial interface ITokenizer
{
	public string Type { get; }
}

public readonly partial struct TokenizerFactory
{
	public Elastic.Clients.Elasticsearch.Analysis.ITokenizer CharGroup(Elastic.Clients.Elasticsearch.Analysis.CharGroupTokenizer value)
	{
		return value;
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenizer CharGroup(System.Action<Elastic.Clients.Elasticsearch.Analysis.CharGroupTokenizerDescriptor> action)
	{
		return Elastic.Clients.Elasticsearch.Analysis.CharGroupTokenizerDescriptor.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenizer Classic(Elastic.Clients.Elasticsearch.Analysis.ClassicTokenizer value)
	{
		return value;
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenizer Classic()
	{
		return Elastic.Clients.Elasticsearch.Analysis.ClassicTokenizerDescriptor.Build(null);
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenizer Classic(System.Action<Elastic.Clients.Elasticsearch.Analysis.ClassicTokenizerDescriptor>? action)
	{
		return Elastic.Clients.Elasticsearch.Analysis.ClassicTokenizerDescriptor.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenizer EdgeNGram(Elastic.Clients.Elasticsearch.Analysis.EdgeNGramTokenizer value)
	{
		return value;
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenizer EdgeNGram()
	{
		return Elastic.Clients.Elasticsearch.Analysis.EdgeNGramTokenizerDescriptor.Build(null);
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenizer EdgeNGram(System.Action<Elastic.Clients.Elasticsearch.Analysis.EdgeNGramTokenizerDescriptor>? action)
	{
		return Elastic.Clients.Elasticsearch.Analysis.EdgeNGramTokenizerDescriptor.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenizer Icu(Elastic.Clients.Elasticsearch.Analysis.IcuTokenizer value)
	{
		return value;
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenizer Icu(System.Action<Elastic.Clients.Elasticsearch.Analysis.IcuTokenizerDescriptor> action)
	{
		return Elastic.Clients.Elasticsearch.Analysis.IcuTokenizerDescriptor.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenizer Keyword(Elastic.Clients.Elasticsearch.Analysis.KeywordTokenizer value)
	{
		return value;
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenizer Keyword()
	{
		return Elastic.Clients.Elasticsearch.Analysis.KeywordTokenizerDescriptor.Build(null);
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenizer Keyword(System.Action<Elastic.Clients.Elasticsearch.Analysis.KeywordTokenizerDescriptor>? action)
	{
		return Elastic.Clients.Elasticsearch.Analysis.KeywordTokenizerDescriptor.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenizer Kuromoji(Elastic.Clients.Elasticsearch.Analysis.KuromojiTokenizer value)
	{
		return value;
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenizer Kuromoji(System.Action<Elastic.Clients.Elasticsearch.Analysis.KuromojiTokenizerDescriptor> action)
	{
		return Elastic.Clients.Elasticsearch.Analysis.KuromojiTokenizerDescriptor.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenizer Letter(Elastic.Clients.Elasticsearch.Analysis.LetterTokenizer value)
	{
		return value;
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenizer Letter()
	{
		return Elastic.Clients.Elasticsearch.Analysis.LetterTokenizerDescriptor.Build(null);
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenizer Letter(System.Action<Elastic.Clients.Elasticsearch.Analysis.LetterTokenizerDescriptor>? action)
	{
		return Elastic.Clients.Elasticsearch.Analysis.LetterTokenizerDescriptor.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenizer Lowercase(Elastic.Clients.Elasticsearch.Analysis.LowercaseTokenizer value)
	{
		return value;
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenizer Lowercase()
	{
		return Elastic.Clients.Elasticsearch.Analysis.LowercaseTokenizerDescriptor.Build(null);
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenizer Lowercase(System.Action<Elastic.Clients.Elasticsearch.Analysis.LowercaseTokenizerDescriptor>? action)
	{
		return Elastic.Clients.Elasticsearch.Analysis.LowercaseTokenizerDescriptor.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenizer NGram(Elastic.Clients.Elasticsearch.Analysis.NGramTokenizer value)
	{
		return value;
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenizer NGram()
	{
		return Elastic.Clients.Elasticsearch.Analysis.NGramTokenizerDescriptor.Build(null);
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenizer NGram(System.Action<Elastic.Clients.Elasticsearch.Analysis.NGramTokenizerDescriptor>? action)
	{
		return Elastic.Clients.Elasticsearch.Analysis.NGramTokenizerDescriptor.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenizer Nori(Elastic.Clients.Elasticsearch.Analysis.NoriTokenizer value)
	{
		return value;
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenizer Nori()
	{
		return Elastic.Clients.Elasticsearch.Analysis.NoriTokenizerDescriptor.Build(null);
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenizer Nori(System.Action<Elastic.Clients.Elasticsearch.Analysis.NoriTokenizerDescriptor>? action)
	{
		return Elastic.Clients.Elasticsearch.Analysis.NoriTokenizerDescriptor.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenizer PathHierarchy(Elastic.Clients.Elasticsearch.Analysis.PathHierarchyTokenizer value)
	{
		return value;
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenizer PathHierarchy()
	{
		return Elastic.Clients.Elasticsearch.Analysis.PathHierarchyTokenizerDescriptor.Build(null);
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenizer PathHierarchy(System.Action<Elastic.Clients.Elasticsearch.Analysis.PathHierarchyTokenizerDescriptor>? action)
	{
		return Elastic.Clients.Elasticsearch.Analysis.PathHierarchyTokenizerDescriptor.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenizer Pattern(Elastic.Clients.Elasticsearch.Analysis.PatternTokenizer value)
	{
		return value;
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenizer Pattern()
	{
		return Elastic.Clients.Elasticsearch.Analysis.PatternTokenizerDescriptor.Build(null);
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenizer Pattern(System.Action<Elastic.Clients.Elasticsearch.Analysis.PatternTokenizerDescriptor>? action)
	{
		return Elastic.Clients.Elasticsearch.Analysis.PatternTokenizerDescriptor.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenizer SimplePattern(Elastic.Clients.Elasticsearch.Analysis.SimplePatternTokenizer value)
	{
		return value;
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenizer SimplePattern()
	{
		return Elastic.Clients.Elasticsearch.Analysis.SimplePatternTokenizerDescriptor.Build(null);
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenizer SimplePattern(System.Action<Elastic.Clients.Elasticsearch.Analysis.SimplePatternTokenizerDescriptor>? action)
	{
		return Elastic.Clients.Elasticsearch.Analysis.SimplePatternTokenizerDescriptor.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenizer SimplePatternSplit(Elastic.Clients.Elasticsearch.Analysis.SimplePatternSplitTokenizer value)
	{
		return value;
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenizer SimplePatternSplit()
	{
		return Elastic.Clients.Elasticsearch.Analysis.SimplePatternSplitTokenizerDescriptor.Build(null);
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenizer SimplePatternSplit(System.Action<Elastic.Clients.Elasticsearch.Analysis.SimplePatternSplitTokenizerDescriptor>? action)
	{
		return Elastic.Clients.Elasticsearch.Analysis.SimplePatternSplitTokenizerDescriptor.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenizer Standard(Elastic.Clients.Elasticsearch.Analysis.StandardTokenizer value)
	{
		return value;
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenizer Standard()
	{
		return Elastic.Clients.Elasticsearch.Analysis.StandardTokenizerDescriptor.Build(null);
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenizer Standard(System.Action<Elastic.Clients.Elasticsearch.Analysis.StandardTokenizerDescriptor>? action)
	{
		return Elastic.Clients.Elasticsearch.Analysis.StandardTokenizerDescriptor.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenizer Thai(Elastic.Clients.Elasticsearch.Analysis.ThaiTokenizer value)
	{
		return value;
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenizer Thai()
	{
		return Elastic.Clients.Elasticsearch.Analysis.ThaiTokenizerDescriptor.Build(null);
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenizer Thai(System.Action<Elastic.Clients.Elasticsearch.Analysis.ThaiTokenizerDescriptor>? action)
	{
		return Elastic.Clients.Elasticsearch.Analysis.ThaiTokenizerDescriptor.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenizer UaxEmailUrl(Elastic.Clients.Elasticsearch.Analysis.UaxEmailUrlTokenizer value)
	{
		return value;
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenizer UaxEmailUrl()
	{
		return Elastic.Clients.Elasticsearch.Analysis.UaxEmailUrlTokenizerDescriptor.Build(null);
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenizer UaxEmailUrl(System.Action<Elastic.Clients.Elasticsearch.Analysis.UaxEmailUrlTokenizerDescriptor>? action)
	{
		return Elastic.Clients.Elasticsearch.Analysis.UaxEmailUrlTokenizerDescriptor.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenizer Whitespace(Elastic.Clients.Elasticsearch.Analysis.WhitespaceTokenizer value)
	{
		return value;
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenizer Whitespace()
	{
		return Elastic.Clients.Elasticsearch.Analysis.WhitespaceTokenizerDescriptor.Build(null);
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenizer Whitespace(System.Action<Elastic.Clients.Elasticsearch.Analysis.WhitespaceTokenizerDescriptor>? action)
	{
		return Elastic.Clients.Elasticsearch.Analysis.WhitespaceTokenizerDescriptor.Build(action);
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Analysis.ITokenizer Build(System.Func<Elastic.Clients.Elasticsearch.Analysis.TokenizerFactory, Elastic.Clients.Elasticsearch.Analysis.ITokenizer> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Analysis.TokenizerFactory();
		return action.Invoke(builder);
	}
}