// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Analysis;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Analysis.Json.TokenFiltersConverter))]
public sealed partial class TokenFilters : Elastic.Clients.Elasticsearch.IsADictionary<string, Elastic.Clients.Elasticsearch.Analysis.ITokenFilter>
{
	public TokenFilters()
	{
	}

	public TokenFilters(System.Collections.Generic.IDictionary<string, Elastic.Clients.Elasticsearch.Analysis.ITokenFilter> backingDictionary) : base(backingDictionary)
	{
	}

	public void Add(string key, Elastic.Clients.Elasticsearch.Analysis.ITokenFilter value) => BackingDictionary.Add(Sanitize(key), value);
	public bool TryGetTokenFilter(string key, [System.Diagnostics.CodeAnalysis.NotNullWhen(returnValue: true)] out Elastic.Clients.Elasticsearch.Analysis.ITokenFilter value) => BackingDictionary.TryGetValue(Sanitize(key), out value);

	public bool TryGetTokenFilter<T>(string key, [System.Diagnostics.CodeAnalysis.NotNullWhen(returnValue: true)] out T? value) where T : class, ITokenFilter
	{
		if (BackingDictionary.TryGetValue(Sanitize(key), out var matchedValue) && matchedValue is T finalValue)
		{
			value = finalValue;
			return true;
		}

		value = null;
		return false;
	}
}

public readonly partial struct TokenFiltersDescriptor
{
	private readonly Elastic.Clients.Elasticsearch.Analysis.TokenFilters _items = new();

	private Elastic.Clients.Elasticsearch.Analysis.TokenFilters Value => _items;

	public TokenFiltersDescriptor()
	{
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenFiltersDescriptor Apostrophe(string key, Elastic.Clients.Elasticsearch.Analysis.ApostropheTokenFilter value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenFiltersDescriptor Apostrophe(string key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.ApostropheTokenFilterDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenFiltersDescriptor Apostrophe(string key, System.Action<Elastic.Clients.Elasticsearch.Analysis.ApostropheTokenFilterDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.ApostropheTokenFilterDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenFiltersDescriptor ArabicNormalization(string key, Elastic.Clients.Elasticsearch.Analysis.ArabicNormalizationTokenFilter value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenFiltersDescriptor ArabicNormalization(string key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.ArabicNormalizationTokenFilterDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenFiltersDescriptor ArabicNormalization(string key, System.Action<Elastic.Clients.Elasticsearch.Analysis.ArabicNormalizationTokenFilterDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.ArabicNormalizationTokenFilterDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenFiltersDescriptor ArabicStem(string key, Elastic.Clients.Elasticsearch.Analysis.ArabicStemTokenFilter value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenFiltersDescriptor ArabicStem(string key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.ArabicStemTokenFilterDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenFiltersDescriptor ArabicStem(string key, System.Action<Elastic.Clients.Elasticsearch.Analysis.ArabicStemTokenFilterDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.ArabicStemTokenFilterDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenFiltersDescriptor AsciiFolding(string key, Elastic.Clients.Elasticsearch.Analysis.AsciiFoldingTokenFilter value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenFiltersDescriptor AsciiFolding(string key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.AsciiFoldingTokenFilterDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenFiltersDescriptor AsciiFolding(string key, System.Action<Elastic.Clients.Elasticsearch.Analysis.AsciiFoldingTokenFilterDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.AsciiFoldingTokenFilterDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenFiltersDescriptor BengaliNormalization(string key, Elastic.Clients.Elasticsearch.Analysis.BengaliNormalizationTokenFilter value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenFiltersDescriptor BengaliNormalization(string key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.BengaliNormalizationTokenFilterDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenFiltersDescriptor BengaliNormalization(string key, System.Action<Elastic.Clients.Elasticsearch.Analysis.BengaliNormalizationTokenFilterDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.BengaliNormalizationTokenFilterDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenFiltersDescriptor BrazilianStem(string key, Elastic.Clients.Elasticsearch.Analysis.BrazilianStemTokenFilter value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenFiltersDescriptor BrazilianStem(string key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.BrazilianStemTokenFilterDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenFiltersDescriptor BrazilianStem(string key, System.Action<Elastic.Clients.Elasticsearch.Analysis.BrazilianStemTokenFilterDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.BrazilianStemTokenFilterDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenFiltersDescriptor CjkBigram(string key, Elastic.Clients.Elasticsearch.Analysis.CjkBigramTokenFilter value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenFiltersDescriptor CjkBigram(string key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.CjkBigramTokenFilterDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenFiltersDescriptor CjkBigram(string key, System.Action<Elastic.Clients.Elasticsearch.Analysis.CjkBigramTokenFilterDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.CjkBigramTokenFilterDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenFiltersDescriptor CjkWidth(string key, Elastic.Clients.Elasticsearch.Analysis.CjkWidthTokenFilter value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenFiltersDescriptor CjkWidth(string key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.CjkWidthTokenFilterDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenFiltersDescriptor CjkWidth(string key, System.Action<Elastic.Clients.Elasticsearch.Analysis.CjkWidthTokenFilterDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.CjkWidthTokenFilterDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenFiltersDescriptor Classic(string key, Elastic.Clients.Elasticsearch.Analysis.ClassicTokenFilter value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenFiltersDescriptor Classic(string key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.ClassicTokenFilterDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenFiltersDescriptor Classic(string key, System.Action<Elastic.Clients.Elasticsearch.Analysis.ClassicTokenFilterDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.ClassicTokenFilterDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenFiltersDescriptor CommonGrams(string key, Elastic.Clients.Elasticsearch.Analysis.CommonGramsTokenFilter value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenFiltersDescriptor CommonGrams(string key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.CommonGramsTokenFilterDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenFiltersDescriptor CommonGrams(string key, System.Action<Elastic.Clients.Elasticsearch.Analysis.CommonGramsTokenFilterDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.CommonGramsTokenFilterDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenFiltersDescriptor Condition(string key, Elastic.Clients.Elasticsearch.Analysis.ConditionTokenFilter value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenFiltersDescriptor Condition(string key, System.Action<Elastic.Clients.Elasticsearch.Analysis.ConditionTokenFilterDescriptor> action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.ConditionTokenFilterDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenFiltersDescriptor CzechStem(string key, Elastic.Clients.Elasticsearch.Analysis.CzechStemTokenFilter value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenFiltersDescriptor CzechStem(string key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.CzechStemTokenFilterDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenFiltersDescriptor CzechStem(string key, System.Action<Elastic.Clients.Elasticsearch.Analysis.CzechStemTokenFilterDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.CzechStemTokenFilterDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenFiltersDescriptor DecimalDigit(string key, Elastic.Clients.Elasticsearch.Analysis.DecimalDigitTokenFilter value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenFiltersDescriptor DecimalDigit(string key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.DecimalDigitTokenFilterDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenFiltersDescriptor DecimalDigit(string key, System.Action<Elastic.Clients.Elasticsearch.Analysis.DecimalDigitTokenFilterDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.DecimalDigitTokenFilterDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenFiltersDescriptor DelimitedPayload(string key, Elastic.Clients.Elasticsearch.Analysis.DelimitedPayloadTokenFilter value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenFiltersDescriptor DelimitedPayload(string key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.DelimitedPayloadTokenFilterDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenFiltersDescriptor DelimitedPayload(string key, System.Action<Elastic.Clients.Elasticsearch.Analysis.DelimitedPayloadTokenFilterDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.DelimitedPayloadTokenFilterDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenFiltersDescriptor DictionaryDecompounder(string key, Elastic.Clients.Elasticsearch.Analysis.DictionaryDecompounderTokenFilter value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenFiltersDescriptor DictionaryDecompounder(string key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.DictionaryDecompounderTokenFilterDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenFiltersDescriptor DictionaryDecompounder(string key, System.Action<Elastic.Clients.Elasticsearch.Analysis.DictionaryDecompounderTokenFilterDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.DictionaryDecompounderTokenFilterDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenFiltersDescriptor DutchStem(string key, Elastic.Clients.Elasticsearch.Analysis.DutchStemTokenFilter value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenFiltersDescriptor DutchStem(string key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.DutchStemTokenFilterDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenFiltersDescriptor DutchStem(string key, System.Action<Elastic.Clients.Elasticsearch.Analysis.DutchStemTokenFilterDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.DutchStemTokenFilterDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenFiltersDescriptor EdgeNGram(string key, Elastic.Clients.Elasticsearch.Analysis.EdgeNGramTokenFilter value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenFiltersDescriptor EdgeNGram(string key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.EdgeNGramTokenFilterDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenFiltersDescriptor EdgeNGram(string key, System.Action<Elastic.Clients.Elasticsearch.Analysis.EdgeNGramTokenFilterDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.EdgeNGramTokenFilterDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenFiltersDescriptor Elision(string key, Elastic.Clients.Elasticsearch.Analysis.ElisionTokenFilter value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenFiltersDescriptor Elision(string key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.ElisionTokenFilterDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenFiltersDescriptor Elision(string key, System.Action<Elastic.Clients.Elasticsearch.Analysis.ElisionTokenFilterDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.ElisionTokenFilterDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenFiltersDescriptor Fingerprint(string key, Elastic.Clients.Elasticsearch.Analysis.FingerprintTokenFilter value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenFiltersDescriptor Fingerprint(string key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.FingerprintTokenFilterDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenFiltersDescriptor Fingerprint(string key, System.Action<Elastic.Clients.Elasticsearch.Analysis.FingerprintTokenFilterDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.FingerprintTokenFilterDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenFiltersDescriptor FlattenGraph(string key, Elastic.Clients.Elasticsearch.Analysis.FlattenGraphTokenFilter value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenFiltersDescriptor FlattenGraph(string key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.FlattenGraphTokenFilterDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenFiltersDescriptor FlattenGraph(string key, System.Action<Elastic.Clients.Elasticsearch.Analysis.FlattenGraphTokenFilterDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.FlattenGraphTokenFilterDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenFiltersDescriptor FrenchStem(string key, Elastic.Clients.Elasticsearch.Analysis.FrenchStemTokenFilter value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenFiltersDescriptor FrenchStem(string key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.FrenchStemTokenFilterDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenFiltersDescriptor FrenchStem(string key, System.Action<Elastic.Clients.Elasticsearch.Analysis.FrenchStemTokenFilterDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.FrenchStemTokenFilterDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenFiltersDescriptor GermanNormalization(string key, Elastic.Clients.Elasticsearch.Analysis.GermanNormalizationTokenFilter value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenFiltersDescriptor GermanNormalization(string key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.GermanNormalizationTokenFilterDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenFiltersDescriptor GermanNormalization(string key, System.Action<Elastic.Clients.Elasticsearch.Analysis.GermanNormalizationTokenFilterDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.GermanNormalizationTokenFilterDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenFiltersDescriptor GermanStem(string key, Elastic.Clients.Elasticsearch.Analysis.GermanStemTokenFilter value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenFiltersDescriptor GermanStem(string key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.GermanStemTokenFilterDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenFiltersDescriptor GermanStem(string key, System.Action<Elastic.Clients.Elasticsearch.Analysis.GermanStemTokenFilterDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.GermanStemTokenFilterDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenFiltersDescriptor HindiNormalization(string key, Elastic.Clients.Elasticsearch.Analysis.HindiNormalizationTokenFilter value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenFiltersDescriptor HindiNormalization(string key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.HindiNormalizationTokenFilterDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenFiltersDescriptor HindiNormalization(string key, System.Action<Elastic.Clients.Elasticsearch.Analysis.HindiNormalizationTokenFilterDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.HindiNormalizationTokenFilterDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenFiltersDescriptor Hunspell(string key, Elastic.Clients.Elasticsearch.Analysis.HunspellTokenFilter value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenFiltersDescriptor Hunspell(string key, System.Action<Elastic.Clients.Elasticsearch.Analysis.HunspellTokenFilterDescriptor> action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.HunspellTokenFilterDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenFiltersDescriptor HyphenationDecompounder(string key, Elastic.Clients.Elasticsearch.Analysis.HyphenationDecompounderTokenFilter value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenFiltersDescriptor HyphenationDecompounder(string key, System.Action<Elastic.Clients.Elasticsearch.Analysis.HyphenationDecompounderTokenFilterDescriptor> action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.HyphenationDecompounderTokenFilterDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenFiltersDescriptor IcuCollation(string key, Elastic.Clients.Elasticsearch.Analysis.IcuCollationTokenFilter value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenFiltersDescriptor IcuCollation(string key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.IcuCollationTokenFilterDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenFiltersDescriptor IcuCollation(string key, System.Action<Elastic.Clients.Elasticsearch.Analysis.IcuCollationTokenFilterDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.IcuCollationTokenFilterDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenFiltersDescriptor IcuFolding(string key, Elastic.Clients.Elasticsearch.Analysis.IcuFoldingTokenFilter value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenFiltersDescriptor IcuFolding(string key, System.Action<Elastic.Clients.Elasticsearch.Analysis.IcuFoldingTokenFilterDescriptor> action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.IcuFoldingTokenFilterDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenFiltersDescriptor IcuNormalization(string key, Elastic.Clients.Elasticsearch.Analysis.IcuNormalizationTokenFilter value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenFiltersDescriptor IcuNormalization(string key, System.Action<Elastic.Clients.Elasticsearch.Analysis.IcuNormalizationTokenFilterDescriptor> action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.IcuNormalizationTokenFilterDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenFiltersDescriptor IcuTransform(string key, Elastic.Clients.Elasticsearch.Analysis.IcuTransformTokenFilter value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenFiltersDescriptor IcuTransform(string key, System.Action<Elastic.Clients.Elasticsearch.Analysis.IcuTransformTokenFilterDescriptor> action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.IcuTransformTokenFilterDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenFiltersDescriptor IndicNormalization(string key, Elastic.Clients.Elasticsearch.Analysis.IndicNormalizationTokenFilter value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenFiltersDescriptor IndicNormalization(string key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.IndicNormalizationTokenFilterDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenFiltersDescriptor IndicNormalization(string key, System.Action<Elastic.Clients.Elasticsearch.Analysis.IndicNormalizationTokenFilterDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.IndicNormalizationTokenFilterDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenFiltersDescriptor JaStop(string key, Elastic.Clients.Elasticsearch.Analysis.JaStopTokenFilter value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenFiltersDescriptor JaStop(string key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.JaStopTokenFilterDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenFiltersDescriptor JaStop(string key, System.Action<Elastic.Clients.Elasticsearch.Analysis.JaStopTokenFilterDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.JaStopTokenFilterDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenFiltersDescriptor KeepWords(string key, Elastic.Clients.Elasticsearch.Analysis.KeepWordsTokenFilter value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenFiltersDescriptor KeepWords(string key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.KeepWordsTokenFilterDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenFiltersDescriptor KeepWords(string key, System.Action<Elastic.Clients.Elasticsearch.Analysis.KeepWordsTokenFilterDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.KeepWordsTokenFilterDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenFiltersDescriptor KeepTypes(string key, Elastic.Clients.Elasticsearch.Analysis.KeepTypesTokenFilter value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenFiltersDescriptor KeepTypes(string key, System.Action<Elastic.Clients.Elasticsearch.Analysis.KeepTypesTokenFilterDescriptor> action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.KeepTypesTokenFilterDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenFiltersDescriptor KeywordMarker(string key, Elastic.Clients.Elasticsearch.Analysis.KeywordMarkerTokenFilter value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenFiltersDescriptor KeywordMarker(string key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.KeywordMarkerTokenFilterDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenFiltersDescriptor KeywordMarker(string key, System.Action<Elastic.Clients.Elasticsearch.Analysis.KeywordMarkerTokenFilterDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.KeywordMarkerTokenFilterDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenFiltersDescriptor KeywordRepeat(string key, Elastic.Clients.Elasticsearch.Analysis.KeywordRepeatTokenFilter value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenFiltersDescriptor KeywordRepeat(string key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.KeywordRepeatTokenFilterDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenFiltersDescriptor KeywordRepeat(string key, System.Action<Elastic.Clients.Elasticsearch.Analysis.KeywordRepeatTokenFilterDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.KeywordRepeatTokenFilterDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenFiltersDescriptor KStem(string key, Elastic.Clients.Elasticsearch.Analysis.KStemTokenFilter value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenFiltersDescriptor KStem(string key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.KStemTokenFilterDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenFiltersDescriptor KStem(string key, System.Action<Elastic.Clients.Elasticsearch.Analysis.KStemTokenFilterDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.KStemTokenFilterDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenFiltersDescriptor KuromojiPartOfSpeech(string key, Elastic.Clients.Elasticsearch.Analysis.KuromojiPartOfSpeechTokenFilter value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenFiltersDescriptor KuromojiPartOfSpeech(string key, System.Action<Elastic.Clients.Elasticsearch.Analysis.KuromojiPartOfSpeechTokenFilterDescriptor> action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.KuromojiPartOfSpeechTokenFilterDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenFiltersDescriptor KuromojiReadingForm(string key, Elastic.Clients.Elasticsearch.Analysis.KuromojiReadingFormTokenFilter value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenFiltersDescriptor KuromojiReadingForm(string key, System.Action<Elastic.Clients.Elasticsearch.Analysis.KuromojiReadingFormTokenFilterDescriptor> action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.KuromojiReadingFormTokenFilterDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenFiltersDescriptor KuromojiStemmer(string key, Elastic.Clients.Elasticsearch.Analysis.KuromojiStemmerTokenFilter value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenFiltersDescriptor KuromojiStemmer(string key, System.Action<Elastic.Clients.Elasticsearch.Analysis.KuromojiStemmerTokenFilterDescriptor> action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.KuromojiStemmerTokenFilterDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenFiltersDescriptor Length(string key, Elastic.Clients.Elasticsearch.Analysis.LengthTokenFilter value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenFiltersDescriptor Length(string key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.LengthTokenFilterDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenFiltersDescriptor Length(string key, System.Action<Elastic.Clients.Elasticsearch.Analysis.LengthTokenFilterDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.LengthTokenFilterDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenFiltersDescriptor LimitTokenCount(string key, Elastic.Clients.Elasticsearch.Analysis.LimitTokenCountTokenFilter value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenFiltersDescriptor LimitTokenCount(string key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.LimitTokenCountTokenFilterDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenFiltersDescriptor LimitTokenCount(string key, System.Action<Elastic.Clients.Elasticsearch.Analysis.LimitTokenCountTokenFilterDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.LimitTokenCountTokenFilterDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenFiltersDescriptor Lowercase(string key, Elastic.Clients.Elasticsearch.Analysis.LowercaseTokenFilter value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenFiltersDescriptor Lowercase(string key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.LowercaseTokenFilterDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenFiltersDescriptor Lowercase(string key, System.Action<Elastic.Clients.Elasticsearch.Analysis.LowercaseTokenFilterDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.LowercaseTokenFilterDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenFiltersDescriptor MinHash(string key, Elastic.Clients.Elasticsearch.Analysis.MinHashTokenFilter value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenFiltersDescriptor MinHash(string key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.MinHashTokenFilterDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenFiltersDescriptor MinHash(string key, System.Action<Elastic.Clients.Elasticsearch.Analysis.MinHashTokenFilterDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.MinHashTokenFilterDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenFiltersDescriptor Multiplexer(string key, Elastic.Clients.Elasticsearch.Analysis.MultiplexerTokenFilter value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenFiltersDescriptor Multiplexer(string key, System.Action<Elastic.Clients.Elasticsearch.Analysis.MultiplexerTokenFilterDescriptor> action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.MultiplexerTokenFilterDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenFiltersDescriptor NGram(string key, Elastic.Clients.Elasticsearch.Analysis.NGramTokenFilter value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenFiltersDescriptor NGram(string key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.NGramTokenFilterDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenFiltersDescriptor NGram(string key, System.Action<Elastic.Clients.Elasticsearch.Analysis.NGramTokenFilterDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.NGramTokenFilterDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenFiltersDescriptor NoriPartOfSpeech(string key, Elastic.Clients.Elasticsearch.Analysis.NoriPartOfSpeechTokenFilter value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenFiltersDescriptor NoriPartOfSpeech(string key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.NoriPartOfSpeechTokenFilterDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenFiltersDescriptor NoriPartOfSpeech(string key, System.Action<Elastic.Clients.Elasticsearch.Analysis.NoriPartOfSpeechTokenFilterDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.NoriPartOfSpeechTokenFilterDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenFiltersDescriptor PatternCapture(string key, Elastic.Clients.Elasticsearch.Analysis.PatternCaptureTokenFilter value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenFiltersDescriptor PatternCapture(string key, System.Action<Elastic.Clients.Elasticsearch.Analysis.PatternCaptureTokenFilterDescriptor> action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.PatternCaptureTokenFilterDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenFiltersDescriptor PatternReplace(string key, Elastic.Clients.Elasticsearch.Analysis.PatternReplaceTokenFilter value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenFiltersDescriptor PatternReplace(string key, System.Action<Elastic.Clients.Elasticsearch.Analysis.PatternReplaceTokenFilterDescriptor> action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.PatternReplaceTokenFilterDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenFiltersDescriptor PersianNormalization(string key, Elastic.Clients.Elasticsearch.Analysis.PersianNormalizationTokenFilter value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenFiltersDescriptor PersianNormalization(string key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.PersianNormalizationTokenFilterDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenFiltersDescriptor PersianNormalization(string key, System.Action<Elastic.Clients.Elasticsearch.Analysis.PersianNormalizationTokenFilterDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.PersianNormalizationTokenFilterDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenFiltersDescriptor PersianStem(string key, Elastic.Clients.Elasticsearch.Analysis.PersianStemTokenFilter value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenFiltersDescriptor PersianStem(string key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.PersianStemTokenFilterDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenFiltersDescriptor PersianStem(string key, System.Action<Elastic.Clients.Elasticsearch.Analysis.PersianStemTokenFilterDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.PersianStemTokenFilterDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenFiltersDescriptor Phonetic(string key, Elastic.Clients.Elasticsearch.Analysis.PhoneticTokenFilter value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenFiltersDescriptor Phonetic(string key, System.Action<Elastic.Clients.Elasticsearch.Analysis.PhoneticTokenFilterDescriptor> action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.PhoneticTokenFilterDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenFiltersDescriptor PorterStem(string key, Elastic.Clients.Elasticsearch.Analysis.PorterStemTokenFilter value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenFiltersDescriptor PorterStem(string key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.PorterStemTokenFilterDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenFiltersDescriptor PorterStem(string key, System.Action<Elastic.Clients.Elasticsearch.Analysis.PorterStemTokenFilterDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.PorterStemTokenFilterDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenFiltersDescriptor Predicate(string key, Elastic.Clients.Elasticsearch.Analysis.PredicateTokenFilter value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenFiltersDescriptor Predicate(string key, System.Action<Elastic.Clients.Elasticsearch.Analysis.PredicateTokenFilterDescriptor> action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.PredicateTokenFilterDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenFiltersDescriptor RemoveDuplicates(string key, Elastic.Clients.Elasticsearch.Analysis.RemoveDuplicatesTokenFilter value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenFiltersDescriptor RemoveDuplicates(string key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.RemoveDuplicatesTokenFilterDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenFiltersDescriptor RemoveDuplicates(string key, System.Action<Elastic.Clients.Elasticsearch.Analysis.RemoveDuplicatesTokenFilterDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.RemoveDuplicatesTokenFilterDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenFiltersDescriptor Reverse(string key, Elastic.Clients.Elasticsearch.Analysis.ReverseTokenFilter value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenFiltersDescriptor Reverse(string key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.ReverseTokenFilterDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenFiltersDescriptor Reverse(string key, System.Action<Elastic.Clients.Elasticsearch.Analysis.ReverseTokenFilterDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.ReverseTokenFilterDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenFiltersDescriptor RussianStem(string key, Elastic.Clients.Elasticsearch.Analysis.RussianStemTokenFilter value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenFiltersDescriptor RussianStem(string key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.RussianStemTokenFilterDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenFiltersDescriptor RussianStem(string key, System.Action<Elastic.Clients.Elasticsearch.Analysis.RussianStemTokenFilterDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.RussianStemTokenFilterDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenFiltersDescriptor ScandinavianFolding(string key, Elastic.Clients.Elasticsearch.Analysis.ScandinavianFoldingTokenFilter value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenFiltersDescriptor ScandinavianFolding(string key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.ScandinavianFoldingTokenFilterDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenFiltersDescriptor ScandinavianFolding(string key, System.Action<Elastic.Clients.Elasticsearch.Analysis.ScandinavianFoldingTokenFilterDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.ScandinavianFoldingTokenFilterDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenFiltersDescriptor ScandinavianNormalization(string key, Elastic.Clients.Elasticsearch.Analysis.ScandinavianNormalizationTokenFilter value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenFiltersDescriptor ScandinavianNormalization(string key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.ScandinavianNormalizationTokenFilterDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenFiltersDescriptor ScandinavianNormalization(string key, System.Action<Elastic.Clients.Elasticsearch.Analysis.ScandinavianNormalizationTokenFilterDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.ScandinavianNormalizationTokenFilterDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenFiltersDescriptor SerbianNormalization(string key, Elastic.Clients.Elasticsearch.Analysis.SerbianNormalizationTokenFilter value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenFiltersDescriptor SerbianNormalization(string key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.SerbianNormalizationTokenFilterDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenFiltersDescriptor SerbianNormalization(string key, System.Action<Elastic.Clients.Elasticsearch.Analysis.SerbianNormalizationTokenFilterDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.SerbianNormalizationTokenFilterDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenFiltersDescriptor Shingle(string key, Elastic.Clients.Elasticsearch.Analysis.ShingleTokenFilter value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenFiltersDescriptor Shingle(string key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.ShingleTokenFilterDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenFiltersDescriptor Shingle(string key, System.Action<Elastic.Clients.Elasticsearch.Analysis.ShingleTokenFilterDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.ShingleTokenFilterDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenFiltersDescriptor Snowball(string key, Elastic.Clients.Elasticsearch.Analysis.SnowballTokenFilter value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenFiltersDescriptor Snowball(string key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.SnowballTokenFilterDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenFiltersDescriptor Snowball(string key, System.Action<Elastic.Clients.Elasticsearch.Analysis.SnowballTokenFilterDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.SnowballTokenFilterDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenFiltersDescriptor SoraniNormalization(string key, Elastic.Clients.Elasticsearch.Analysis.SoraniNormalizationTokenFilter value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenFiltersDescriptor SoraniNormalization(string key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.SoraniNormalizationTokenFilterDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenFiltersDescriptor SoraniNormalization(string key, System.Action<Elastic.Clients.Elasticsearch.Analysis.SoraniNormalizationTokenFilterDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.SoraniNormalizationTokenFilterDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenFiltersDescriptor Stemmer(string key, Elastic.Clients.Elasticsearch.Analysis.StemmerTokenFilter value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenFiltersDescriptor Stemmer(string key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.StemmerTokenFilterDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenFiltersDescriptor Stemmer(string key, System.Action<Elastic.Clients.Elasticsearch.Analysis.StemmerTokenFilterDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.StemmerTokenFilterDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenFiltersDescriptor StemmerOverride(string key, Elastic.Clients.Elasticsearch.Analysis.StemmerOverrideTokenFilter value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenFiltersDescriptor StemmerOverride(string key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.StemmerOverrideTokenFilterDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenFiltersDescriptor StemmerOverride(string key, System.Action<Elastic.Clients.Elasticsearch.Analysis.StemmerOverrideTokenFilterDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.StemmerOverrideTokenFilterDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenFiltersDescriptor Stop(string key, Elastic.Clients.Elasticsearch.Analysis.StopTokenFilter value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenFiltersDescriptor Stop(string key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.StopTokenFilterDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenFiltersDescriptor Stop(string key, System.Action<Elastic.Clients.Elasticsearch.Analysis.StopTokenFilterDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.StopTokenFilterDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenFiltersDescriptor Synonym(string key, Elastic.Clients.Elasticsearch.Analysis.SynonymTokenFilter value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenFiltersDescriptor Synonym(string key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.SynonymTokenFilterDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenFiltersDescriptor Synonym(string key, System.Action<Elastic.Clients.Elasticsearch.Analysis.SynonymTokenFilterDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.SynonymTokenFilterDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenFiltersDescriptor SynonymGraph(string key, Elastic.Clients.Elasticsearch.Analysis.SynonymGraphTokenFilter value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenFiltersDescriptor SynonymGraph(string key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.SynonymGraphTokenFilterDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenFiltersDescriptor SynonymGraph(string key, System.Action<Elastic.Clients.Elasticsearch.Analysis.SynonymGraphTokenFilterDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.SynonymGraphTokenFilterDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenFiltersDescriptor Trim(string key, Elastic.Clients.Elasticsearch.Analysis.TrimTokenFilter value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenFiltersDescriptor Trim(string key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.TrimTokenFilterDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenFiltersDescriptor Trim(string key, System.Action<Elastic.Clients.Elasticsearch.Analysis.TrimTokenFilterDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.TrimTokenFilterDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenFiltersDescriptor Truncate(string key, Elastic.Clients.Elasticsearch.Analysis.TruncateTokenFilter value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenFiltersDescriptor Truncate(string key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.TruncateTokenFilterDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenFiltersDescriptor Truncate(string key, System.Action<Elastic.Clients.Elasticsearch.Analysis.TruncateTokenFilterDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.TruncateTokenFilterDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenFiltersDescriptor Unique(string key, Elastic.Clients.Elasticsearch.Analysis.UniqueTokenFilter value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenFiltersDescriptor Unique(string key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.UniqueTokenFilterDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenFiltersDescriptor Unique(string key, System.Action<Elastic.Clients.Elasticsearch.Analysis.UniqueTokenFilterDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.UniqueTokenFilterDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenFiltersDescriptor Uppercase(string key, Elastic.Clients.Elasticsearch.Analysis.UppercaseTokenFilter value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenFiltersDescriptor Uppercase(string key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.UppercaseTokenFilterDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenFiltersDescriptor Uppercase(string key, System.Action<Elastic.Clients.Elasticsearch.Analysis.UppercaseTokenFilterDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.UppercaseTokenFilterDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenFiltersDescriptor WordDelimiter(string key, Elastic.Clients.Elasticsearch.Analysis.WordDelimiterTokenFilter value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenFiltersDescriptor WordDelimiter(string key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.WordDelimiterTokenFilterDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenFiltersDescriptor WordDelimiter(string key, System.Action<Elastic.Clients.Elasticsearch.Analysis.WordDelimiterTokenFilterDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.WordDelimiterTokenFilterDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenFiltersDescriptor WordDelimiterGraph(string key, Elastic.Clients.Elasticsearch.Analysis.WordDelimiterGraphTokenFilter value)
	{
		_items.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenFiltersDescriptor WordDelimiterGraph(string key)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.WordDelimiterGraphTokenFilterDescriptor.Build(null));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Analysis.TokenFiltersDescriptor WordDelimiterGraph(string key, System.Action<Elastic.Clients.Elasticsearch.Analysis.WordDelimiterGraphTokenFilterDescriptor>? action)
	{
		_items.Add(key, Elastic.Clients.Elasticsearch.Analysis.WordDelimiterGraphTokenFilterDescriptor.Build(action));
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Analysis.TokenFilters Build(System.Action<Elastic.Clients.Elasticsearch.Analysis.TokenFiltersDescriptor>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.Analysis.TokenFilters();
		}

		var builder = new Elastic.Clients.Elasticsearch.Analysis.TokenFiltersDescriptor();
		action.Invoke(builder);
		return builder.Value;
	}
}