// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Analysis;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Analysis.Json.ITokenFilterConverter))]
public partial interface ITokenFilter
{
	public string Type { get; }
}

public readonly partial struct TokenFilterFactory
{
	public Elastic.Clients.Elasticsearch.Analysis.ITokenFilter Apostrophe(Elastic.Clients.Elasticsearch.Analysis.ApostropheTokenFilter value)
	{
		return value;
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenFilter Apostrophe()
	{
		return Elastic.Clients.Elasticsearch.Analysis.ApostropheTokenFilterDescriptor.Build(null);
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenFilter Apostrophe(System.Action<Elastic.Clients.Elasticsearch.Analysis.ApostropheTokenFilterDescriptor>? action)
	{
		return Elastic.Clients.Elasticsearch.Analysis.ApostropheTokenFilterDescriptor.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenFilter ArabicNormalization(Elastic.Clients.Elasticsearch.Analysis.ArabicNormalizationTokenFilter value)
	{
		return value;
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenFilter ArabicNormalization()
	{
		return Elastic.Clients.Elasticsearch.Analysis.ArabicNormalizationTokenFilterDescriptor.Build(null);
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenFilter ArabicNormalization(System.Action<Elastic.Clients.Elasticsearch.Analysis.ArabicNormalizationTokenFilterDescriptor>? action)
	{
		return Elastic.Clients.Elasticsearch.Analysis.ArabicNormalizationTokenFilterDescriptor.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenFilter ArabicStem(Elastic.Clients.Elasticsearch.Analysis.ArabicStemTokenFilter value)
	{
		return value;
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenFilter ArabicStem()
	{
		return Elastic.Clients.Elasticsearch.Analysis.ArabicStemTokenFilterDescriptor.Build(null);
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenFilter ArabicStem(System.Action<Elastic.Clients.Elasticsearch.Analysis.ArabicStemTokenFilterDescriptor>? action)
	{
		return Elastic.Clients.Elasticsearch.Analysis.ArabicStemTokenFilterDescriptor.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenFilter AsciiFolding(Elastic.Clients.Elasticsearch.Analysis.AsciiFoldingTokenFilter value)
	{
		return value;
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenFilter AsciiFolding()
	{
		return Elastic.Clients.Elasticsearch.Analysis.AsciiFoldingTokenFilterDescriptor.Build(null);
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenFilter AsciiFolding(System.Action<Elastic.Clients.Elasticsearch.Analysis.AsciiFoldingTokenFilterDescriptor>? action)
	{
		return Elastic.Clients.Elasticsearch.Analysis.AsciiFoldingTokenFilterDescriptor.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenFilter BengaliNormalization(Elastic.Clients.Elasticsearch.Analysis.BengaliNormalizationTokenFilter value)
	{
		return value;
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenFilter BengaliNormalization()
	{
		return Elastic.Clients.Elasticsearch.Analysis.BengaliNormalizationTokenFilterDescriptor.Build(null);
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenFilter BengaliNormalization(System.Action<Elastic.Clients.Elasticsearch.Analysis.BengaliNormalizationTokenFilterDescriptor>? action)
	{
		return Elastic.Clients.Elasticsearch.Analysis.BengaliNormalizationTokenFilterDescriptor.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenFilter BrazilianStem(Elastic.Clients.Elasticsearch.Analysis.BrazilianStemTokenFilter value)
	{
		return value;
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenFilter BrazilianStem()
	{
		return Elastic.Clients.Elasticsearch.Analysis.BrazilianStemTokenFilterDescriptor.Build(null);
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenFilter BrazilianStem(System.Action<Elastic.Clients.Elasticsearch.Analysis.BrazilianStemTokenFilterDescriptor>? action)
	{
		return Elastic.Clients.Elasticsearch.Analysis.BrazilianStemTokenFilterDescriptor.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenFilter CjkBigram(Elastic.Clients.Elasticsearch.Analysis.CjkBigramTokenFilter value)
	{
		return value;
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenFilter CjkBigram()
	{
		return Elastic.Clients.Elasticsearch.Analysis.CjkBigramTokenFilterDescriptor.Build(null);
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenFilter CjkBigram(System.Action<Elastic.Clients.Elasticsearch.Analysis.CjkBigramTokenFilterDescriptor>? action)
	{
		return Elastic.Clients.Elasticsearch.Analysis.CjkBigramTokenFilterDescriptor.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenFilter CjkWidth(Elastic.Clients.Elasticsearch.Analysis.CjkWidthTokenFilter value)
	{
		return value;
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenFilter CjkWidth()
	{
		return Elastic.Clients.Elasticsearch.Analysis.CjkWidthTokenFilterDescriptor.Build(null);
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenFilter CjkWidth(System.Action<Elastic.Clients.Elasticsearch.Analysis.CjkWidthTokenFilterDescriptor>? action)
	{
		return Elastic.Clients.Elasticsearch.Analysis.CjkWidthTokenFilterDescriptor.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenFilter Classic(Elastic.Clients.Elasticsearch.Analysis.ClassicTokenFilter value)
	{
		return value;
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenFilter Classic()
	{
		return Elastic.Clients.Elasticsearch.Analysis.ClassicTokenFilterDescriptor.Build(null);
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenFilter Classic(System.Action<Elastic.Clients.Elasticsearch.Analysis.ClassicTokenFilterDescriptor>? action)
	{
		return Elastic.Clients.Elasticsearch.Analysis.ClassicTokenFilterDescriptor.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenFilter CommonGrams(Elastic.Clients.Elasticsearch.Analysis.CommonGramsTokenFilter value)
	{
		return value;
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenFilter CommonGrams()
	{
		return Elastic.Clients.Elasticsearch.Analysis.CommonGramsTokenFilterDescriptor.Build(null);
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenFilter CommonGrams(System.Action<Elastic.Clients.Elasticsearch.Analysis.CommonGramsTokenFilterDescriptor>? action)
	{
		return Elastic.Clients.Elasticsearch.Analysis.CommonGramsTokenFilterDescriptor.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenFilter Condition(Elastic.Clients.Elasticsearch.Analysis.ConditionTokenFilter value)
	{
		return value;
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenFilter Condition(System.Action<Elastic.Clients.Elasticsearch.Analysis.ConditionTokenFilterDescriptor> action)
	{
		return Elastic.Clients.Elasticsearch.Analysis.ConditionTokenFilterDescriptor.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenFilter CzechStem(Elastic.Clients.Elasticsearch.Analysis.CzechStemTokenFilter value)
	{
		return value;
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenFilter CzechStem()
	{
		return Elastic.Clients.Elasticsearch.Analysis.CzechStemTokenFilterDescriptor.Build(null);
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenFilter CzechStem(System.Action<Elastic.Clients.Elasticsearch.Analysis.CzechStemTokenFilterDescriptor>? action)
	{
		return Elastic.Clients.Elasticsearch.Analysis.CzechStemTokenFilterDescriptor.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenFilter DecimalDigit(Elastic.Clients.Elasticsearch.Analysis.DecimalDigitTokenFilter value)
	{
		return value;
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenFilter DecimalDigit()
	{
		return Elastic.Clients.Elasticsearch.Analysis.DecimalDigitTokenFilterDescriptor.Build(null);
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenFilter DecimalDigit(System.Action<Elastic.Clients.Elasticsearch.Analysis.DecimalDigitTokenFilterDescriptor>? action)
	{
		return Elastic.Clients.Elasticsearch.Analysis.DecimalDigitTokenFilterDescriptor.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenFilter DelimitedPayload(Elastic.Clients.Elasticsearch.Analysis.DelimitedPayloadTokenFilter value)
	{
		return value;
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenFilter DelimitedPayload()
	{
		return Elastic.Clients.Elasticsearch.Analysis.DelimitedPayloadTokenFilterDescriptor.Build(null);
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenFilter DelimitedPayload(System.Action<Elastic.Clients.Elasticsearch.Analysis.DelimitedPayloadTokenFilterDescriptor>? action)
	{
		return Elastic.Clients.Elasticsearch.Analysis.DelimitedPayloadTokenFilterDescriptor.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenFilter DictionaryDecompounder(Elastic.Clients.Elasticsearch.Analysis.DictionaryDecompounderTokenFilter value)
	{
		return value;
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenFilter DictionaryDecompounder()
	{
		return Elastic.Clients.Elasticsearch.Analysis.DictionaryDecompounderTokenFilterDescriptor.Build(null);
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenFilter DictionaryDecompounder(System.Action<Elastic.Clients.Elasticsearch.Analysis.DictionaryDecompounderTokenFilterDescriptor>? action)
	{
		return Elastic.Clients.Elasticsearch.Analysis.DictionaryDecompounderTokenFilterDescriptor.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenFilter DutchStem(Elastic.Clients.Elasticsearch.Analysis.DutchStemTokenFilter value)
	{
		return value;
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenFilter DutchStem()
	{
		return Elastic.Clients.Elasticsearch.Analysis.DutchStemTokenFilterDescriptor.Build(null);
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenFilter DutchStem(System.Action<Elastic.Clients.Elasticsearch.Analysis.DutchStemTokenFilterDescriptor>? action)
	{
		return Elastic.Clients.Elasticsearch.Analysis.DutchStemTokenFilterDescriptor.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenFilter EdgeNGram(Elastic.Clients.Elasticsearch.Analysis.EdgeNGramTokenFilter value)
	{
		return value;
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenFilter EdgeNGram()
	{
		return Elastic.Clients.Elasticsearch.Analysis.EdgeNGramTokenFilterDescriptor.Build(null);
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenFilter EdgeNGram(System.Action<Elastic.Clients.Elasticsearch.Analysis.EdgeNGramTokenFilterDescriptor>? action)
	{
		return Elastic.Clients.Elasticsearch.Analysis.EdgeNGramTokenFilterDescriptor.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenFilter Elision(Elastic.Clients.Elasticsearch.Analysis.ElisionTokenFilter value)
	{
		return value;
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenFilter Elision()
	{
		return Elastic.Clients.Elasticsearch.Analysis.ElisionTokenFilterDescriptor.Build(null);
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenFilter Elision(System.Action<Elastic.Clients.Elasticsearch.Analysis.ElisionTokenFilterDescriptor>? action)
	{
		return Elastic.Clients.Elasticsearch.Analysis.ElisionTokenFilterDescriptor.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenFilter Fingerprint(Elastic.Clients.Elasticsearch.Analysis.FingerprintTokenFilter value)
	{
		return value;
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenFilter Fingerprint()
	{
		return Elastic.Clients.Elasticsearch.Analysis.FingerprintTokenFilterDescriptor.Build(null);
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenFilter Fingerprint(System.Action<Elastic.Clients.Elasticsearch.Analysis.FingerprintTokenFilterDescriptor>? action)
	{
		return Elastic.Clients.Elasticsearch.Analysis.FingerprintTokenFilterDescriptor.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenFilter FlattenGraph(Elastic.Clients.Elasticsearch.Analysis.FlattenGraphTokenFilter value)
	{
		return value;
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenFilter FlattenGraph()
	{
		return Elastic.Clients.Elasticsearch.Analysis.FlattenGraphTokenFilterDescriptor.Build(null);
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenFilter FlattenGraph(System.Action<Elastic.Clients.Elasticsearch.Analysis.FlattenGraphTokenFilterDescriptor>? action)
	{
		return Elastic.Clients.Elasticsearch.Analysis.FlattenGraphTokenFilterDescriptor.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenFilter FrenchStem(Elastic.Clients.Elasticsearch.Analysis.FrenchStemTokenFilter value)
	{
		return value;
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenFilter FrenchStem()
	{
		return Elastic.Clients.Elasticsearch.Analysis.FrenchStemTokenFilterDescriptor.Build(null);
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenFilter FrenchStem(System.Action<Elastic.Clients.Elasticsearch.Analysis.FrenchStemTokenFilterDescriptor>? action)
	{
		return Elastic.Clients.Elasticsearch.Analysis.FrenchStemTokenFilterDescriptor.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenFilter GermanNormalization(Elastic.Clients.Elasticsearch.Analysis.GermanNormalizationTokenFilter value)
	{
		return value;
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenFilter GermanNormalization()
	{
		return Elastic.Clients.Elasticsearch.Analysis.GermanNormalizationTokenFilterDescriptor.Build(null);
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenFilter GermanNormalization(System.Action<Elastic.Clients.Elasticsearch.Analysis.GermanNormalizationTokenFilterDescriptor>? action)
	{
		return Elastic.Clients.Elasticsearch.Analysis.GermanNormalizationTokenFilterDescriptor.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenFilter GermanStem(Elastic.Clients.Elasticsearch.Analysis.GermanStemTokenFilter value)
	{
		return value;
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenFilter GermanStem()
	{
		return Elastic.Clients.Elasticsearch.Analysis.GermanStemTokenFilterDescriptor.Build(null);
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenFilter GermanStem(System.Action<Elastic.Clients.Elasticsearch.Analysis.GermanStemTokenFilterDescriptor>? action)
	{
		return Elastic.Clients.Elasticsearch.Analysis.GermanStemTokenFilterDescriptor.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenFilter HindiNormalization(Elastic.Clients.Elasticsearch.Analysis.HindiNormalizationTokenFilter value)
	{
		return value;
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenFilter HindiNormalization()
	{
		return Elastic.Clients.Elasticsearch.Analysis.HindiNormalizationTokenFilterDescriptor.Build(null);
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenFilter HindiNormalization(System.Action<Elastic.Clients.Elasticsearch.Analysis.HindiNormalizationTokenFilterDescriptor>? action)
	{
		return Elastic.Clients.Elasticsearch.Analysis.HindiNormalizationTokenFilterDescriptor.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenFilter Hunspell(Elastic.Clients.Elasticsearch.Analysis.HunspellTokenFilter value)
	{
		return value;
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenFilter Hunspell(System.Action<Elastic.Clients.Elasticsearch.Analysis.HunspellTokenFilterDescriptor> action)
	{
		return Elastic.Clients.Elasticsearch.Analysis.HunspellTokenFilterDescriptor.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenFilter HyphenationDecompounder(Elastic.Clients.Elasticsearch.Analysis.HyphenationDecompounderTokenFilter value)
	{
		return value;
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenFilter HyphenationDecompounder(System.Action<Elastic.Clients.Elasticsearch.Analysis.HyphenationDecompounderTokenFilterDescriptor> action)
	{
		return Elastic.Clients.Elasticsearch.Analysis.HyphenationDecompounderTokenFilterDescriptor.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenFilter IcuCollation(Elastic.Clients.Elasticsearch.Analysis.IcuCollationTokenFilter value)
	{
		return value;
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenFilter IcuCollation()
	{
		return Elastic.Clients.Elasticsearch.Analysis.IcuCollationTokenFilterDescriptor.Build(null);
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenFilter IcuCollation(System.Action<Elastic.Clients.Elasticsearch.Analysis.IcuCollationTokenFilterDescriptor>? action)
	{
		return Elastic.Clients.Elasticsearch.Analysis.IcuCollationTokenFilterDescriptor.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenFilter IcuFolding(Elastic.Clients.Elasticsearch.Analysis.IcuFoldingTokenFilter value)
	{
		return value;
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenFilter IcuFolding(System.Action<Elastic.Clients.Elasticsearch.Analysis.IcuFoldingTokenFilterDescriptor> action)
	{
		return Elastic.Clients.Elasticsearch.Analysis.IcuFoldingTokenFilterDescriptor.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenFilter IcuNormalization(Elastic.Clients.Elasticsearch.Analysis.IcuNormalizationTokenFilter value)
	{
		return value;
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenFilter IcuNormalization(System.Action<Elastic.Clients.Elasticsearch.Analysis.IcuNormalizationTokenFilterDescriptor> action)
	{
		return Elastic.Clients.Elasticsearch.Analysis.IcuNormalizationTokenFilterDescriptor.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenFilter IcuTransform(Elastic.Clients.Elasticsearch.Analysis.IcuTransformTokenFilter value)
	{
		return value;
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenFilter IcuTransform(System.Action<Elastic.Clients.Elasticsearch.Analysis.IcuTransformTokenFilterDescriptor> action)
	{
		return Elastic.Clients.Elasticsearch.Analysis.IcuTransformTokenFilterDescriptor.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenFilter IndicNormalization(Elastic.Clients.Elasticsearch.Analysis.IndicNormalizationTokenFilter value)
	{
		return value;
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenFilter IndicNormalization()
	{
		return Elastic.Clients.Elasticsearch.Analysis.IndicNormalizationTokenFilterDescriptor.Build(null);
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenFilter IndicNormalization(System.Action<Elastic.Clients.Elasticsearch.Analysis.IndicNormalizationTokenFilterDescriptor>? action)
	{
		return Elastic.Clients.Elasticsearch.Analysis.IndicNormalizationTokenFilterDescriptor.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenFilter JaStop(Elastic.Clients.Elasticsearch.Analysis.JaStopTokenFilter value)
	{
		return value;
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenFilter JaStop()
	{
		return Elastic.Clients.Elasticsearch.Analysis.JaStopTokenFilterDescriptor.Build(null);
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenFilter JaStop(System.Action<Elastic.Clients.Elasticsearch.Analysis.JaStopTokenFilterDescriptor>? action)
	{
		return Elastic.Clients.Elasticsearch.Analysis.JaStopTokenFilterDescriptor.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenFilter KeepWords(Elastic.Clients.Elasticsearch.Analysis.KeepWordsTokenFilter value)
	{
		return value;
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenFilter KeepWords()
	{
		return Elastic.Clients.Elasticsearch.Analysis.KeepWordsTokenFilterDescriptor.Build(null);
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenFilter KeepWords(System.Action<Elastic.Clients.Elasticsearch.Analysis.KeepWordsTokenFilterDescriptor>? action)
	{
		return Elastic.Clients.Elasticsearch.Analysis.KeepWordsTokenFilterDescriptor.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenFilter KeepTypes(Elastic.Clients.Elasticsearch.Analysis.KeepTypesTokenFilter value)
	{
		return value;
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenFilter KeepTypes(System.Action<Elastic.Clients.Elasticsearch.Analysis.KeepTypesTokenFilterDescriptor> action)
	{
		return Elastic.Clients.Elasticsearch.Analysis.KeepTypesTokenFilterDescriptor.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenFilter KeywordMarker(Elastic.Clients.Elasticsearch.Analysis.KeywordMarkerTokenFilter value)
	{
		return value;
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenFilter KeywordMarker()
	{
		return Elastic.Clients.Elasticsearch.Analysis.KeywordMarkerTokenFilterDescriptor.Build(null);
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenFilter KeywordMarker(System.Action<Elastic.Clients.Elasticsearch.Analysis.KeywordMarkerTokenFilterDescriptor>? action)
	{
		return Elastic.Clients.Elasticsearch.Analysis.KeywordMarkerTokenFilterDescriptor.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenFilter KeywordRepeat(Elastic.Clients.Elasticsearch.Analysis.KeywordRepeatTokenFilter value)
	{
		return value;
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenFilter KeywordRepeat()
	{
		return Elastic.Clients.Elasticsearch.Analysis.KeywordRepeatTokenFilterDescriptor.Build(null);
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenFilter KeywordRepeat(System.Action<Elastic.Clients.Elasticsearch.Analysis.KeywordRepeatTokenFilterDescriptor>? action)
	{
		return Elastic.Clients.Elasticsearch.Analysis.KeywordRepeatTokenFilterDescriptor.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenFilter KStem(Elastic.Clients.Elasticsearch.Analysis.KStemTokenFilter value)
	{
		return value;
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenFilter KStem()
	{
		return Elastic.Clients.Elasticsearch.Analysis.KStemTokenFilterDescriptor.Build(null);
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenFilter KStem(System.Action<Elastic.Clients.Elasticsearch.Analysis.KStemTokenFilterDescriptor>? action)
	{
		return Elastic.Clients.Elasticsearch.Analysis.KStemTokenFilterDescriptor.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenFilter KuromojiPartOfSpeech(Elastic.Clients.Elasticsearch.Analysis.KuromojiPartOfSpeechTokenFilter value)
	{
		return value;
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenFilter KuromojiPartOfSpeech(System.Action<Elastic.Clients.Elasticsearch.Analysis.KuromojiPartOfSpeechTokenFilterDescriptor> action)
	{
		return Elastic.Clients.Elasticsearch.Analysis.KuromojiPartOfSpeechTokenFilterDescriptor.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenFilter KuromojiReadingForm(Elastic.Clients.Elasticsearch.Analysis.KuromojiReadingFormTokenFilter value)
	{
		return value;
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenFilter KuromojiReadingForm(System.Action<Elastic.Clients.Elasticsearch.Analysis.KuromojiReadingFormTokenFilterDescriptor> action)
	{
		return Elastic.Clients.Elasticsearch.Analysis.KuromojiReadingFormTokenFilterDescriptor.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenFilter KuromojiStemmer(Elastic.Clients.Elasticsearch.Analysis.KuromojiStemmerTokenFilter value)
	{
		return value;
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenFilter KuromojiStemmer(System.Action<Elastic.Clients.Elasticsearch.Analysis.KuromojiStemmerTokenFilterDescriptor> action)
	{
		return Elastic.Clients.Elasticsearch.Analysis.KuromojiStemmerTokenFilterDescriptor.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenFilter Length(Elastic.Clients.Elasticsearch.Analysis.LengthTokenFilter value)
	{
		return value;
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenFilter Length()
	{
		return Elastic.Clients.Elasticsearch.Analysis.LengthTokenFilterDescriptor.Build(null);
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenFilter Length(System.Action<Elastic.Clients.Elasticsearch.Analysis.LengthTokenFilterDescriptor>? action)
	{
		return Elastic.Clients.Elasticsearch.Analysis.LengthTokenFilterDescriptor.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenFilter LimitTokenCount(Elastic.Clients.Elasticsearch.Analysis.LimitTokenCountTokenFilter value)
	{
		return value;
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenFilter LimitTokenCount()
	{
		return Elastic.Clients.Elasticsearch.Analysis.LimitTokenCountTokenFilterDescriptor.Build(null);
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenFilter LimitTokenCount(System.Action<Elastic.Clients.Elasticsearch.Analysis.LimitTokenCountTokenFilterDescriptor>? action)
	{
		return Elastic.Clients.Elasticsearch.Analysis.LimitTokenCountTokenFilterDescriptor.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenFilter Lowercase(Elastic.Clients.Elasticsearch.Analysis.LowercaseTokenFilter value)
	{
		return value;
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenFilter Lowercase()
	{
		return Elastic.Clients.Elasticsearch.Analysis.LowercaseTokenFilterDescriptor.Build(null);
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenFilter Lowercase(System.Action<Elastic.Clients.Elasticsearch.Analysis.LowercaseTokenFilterDescriptor>? action)
	{
		return Elastic.Clients.Elasticsearch.Analysis.LowercaseTokenFilterDescriptor.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenFilter MinHash(Elastic.Clients.Elasticsearch.Analysis.MinHashTokenFilter value)
	{
		return value;
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenFilter MinHash()
	{
		return Elastic.Clients.Elasticsearch.Analysis.MinHashTokenFilterDescriptor.Build(null);
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenFilter MinHash(System.Action<Elastic.Clients.Elasticsearch.Analysis.MinHashTokenFilterDescriptor>? action)
	{
		return Elastic.Clients.Elasticsearch.Analysis.MinHashTokenFilterDescriptor.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenFilter Multiplexer(Elastic.Clients.Elasticsearch.Analysis.MultiplexerTokenFilter value)
	{
		return value;
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenFilter Multiplexer(System.Action<Elastic.Clients.Elasticsearch.Analysis.MultiplexerTokenFilterDescriptor> action)
	{
		return Elastic.Clients.Elasticsearch.Analysis.MultiplexerTokenFilterDescriptor.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenFilter NGram(Elastic.Clients.Elasticsearch.Analysis.NGramTokenFilter value)
	{
		return value;
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenFilter NGram()
	{
		return Elastic.Clients.Elasticsearch.Analysis.NGramTokenFilterDescriptor.Build(null);
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenFilter NGram(System.Action<Elastic.Clients.Elasticsearch.Analysis.NGramTokenFilterDescriptor>? action)
	{
		return Elastic.Clients.Elasticsearch.Analysis.NGramTokenFilterDescriptor.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenFilter NoriPartOfSpeech(Elastic.Clients.Elasticsearch.Analysis.NoriPartOfSpeechTokenFilter value)
	{
		return value;
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenFilter NoriPartOfSpeech()
	{
		return Elastic.Clients.Elasticsearch.Analysis.NoriPartOfSpeechTokenFilterDescriptor.Build(null);
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenFilter NoriPartOfSpeech(System.Action<Elastic.Clients.Elasticsearch.Analysis.NoriPartOfSpeechTokenFilterDescriptor>? action)
	{
		return Elastic.Clients.Elasticsearch.Analysis.NoriPartOfSpeechTokenFilterDescriptor.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenFilter PatternCapture(Elastic.Clients.Elasticsearch.Analysis.PatternCaptureTokenFilter value)
	{
		return value;
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenFilter PatternCapture(System.Action<Elastic.Clients.Elasticsearch.Analysis.PatternCaptureTokenFilterDescriptor> action)
	{
		return Elastic.Clients.Elasticsearch.Analysis.PatternCaptureTokenFilterDescriptor.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenFilter PatternReplace(Elastic.Clients.Elasticsearch.Analysis.PatternReplaceTokenFilter value)
	{
		return value;
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenFilter PatternReplace(System.Action<Elastic.Clients.Elasticsearch.Analysis.PatternReplaceTokenFilterDescriptor> action)
	{
		return Elastic.Clients.Elasticsearch.Analysis.PatternReplaceTokenFilterDescriptor.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenFilter PersianNormalization(Elastic.Clients.Elasticsearch.Analysis.PersianNormalizationTokenFilter value)
	{
		return value;
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenFilter PersianNormalization()
	{
		return Elastic.Clients.Elasticsearch.Analysis.PersianNormalizationTokenFilterDescriptor.Build(null);
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenFilter PersianNormalization(System.Action<Elastic.Clients.Elasticsearch.Analysis.PersianNormalizationTokenFilterDescriptor>? action)
	{
		return Elastic.Clients.Elasticsearch.Analysis.PersianNormalizationTokenFilterDescriptor.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenFilter PersianStem(Elastic.Clients.Elasticsearch.Analysis.PersianStemTokenFilter value)
	{
		return value;
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenFilter PersianStem()
	{
		return Elastic.Clients.Elasticsearch.Analysis.PersianStemTokenFilterDescriptor.Build(null);
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenFilter PersianStem(System.Action<Elastic.Clients.Elasticsearch.Analysis.PersianStemTokenFilterDescriptor>? action)
	{
		return Elastic.Clients.Elasticsearch.Analysis.PersianStemTokenFilterDescriptor.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenFilter Phonetic(Elastic.Clients.Elasticsearch.Analysis.PhoneticTokenFilter value)
	{
		return value;
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenFilter Phonetic(System.Action<Elastic.Clients.Elasticsearch.Analysis.PhoneticTokenFilterDescriptor> action)
	{
		return Elastic.Clients.Elasticsearch.Analysis.PhoneticTokenFilterDescriptor.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenFilter PorterStem(Elastic.Clients.Elasticsearch.Analysis.PorterStemTokenFilter value)
	{
		return value;
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenFilter PorterStem()
	{
		return Elastic.Clients.Elasticsearch.Analysis.PorterStemTokenFilterDescriptor.Build(null);
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenFilter PorterStem(System.Action<Elastic.Clients.Elasticsearch.Analysis.PorterStemTokenFilterDescriptor>? action)
	{
		return Elastic.Clients.Elasticsearch.Analysis.PorterStemTokenFilterDescriptor.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenFilter Predicate(Elastic.Clients.Elasticsearch.Analysis.PredicateTokenFilter value)
	{
		return value;
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenFilter Predicate(System.Action<Elastic.Clients.Elasticsearch.Analysis.PredicateTokenFilterDescriptor> action)
	{
		return Elastic.Clients.Elasticsearch.Analysis.PredicateTokenFilterDescriptor.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenFilter RemoveDuplicates(Elastic.Clients.Elasticsearch.Analysis.RemoveDuplicatesTokenFilter value)
	{
		return value;
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenFilter RemoveDuplicates()
	{
		return Elastic.Clients.Elasticsearch.Analysis.RemoveDuplicatesTokenFilterDescriptor.Build(null);
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenFilter RemoveDuplicates(System.Action<Elastic.Clients.Elasticsearch.Analysis.RemoveDuplicatesTokenFilterDescriptor>? action)
	{
		return Elastic.Clients.Elasticsearch.Analysis.RemoveDuplicatesTokenFilterDescriptor.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenFilter Reverse(Elastic.Clients.Elasticsearch.Analysis.ReverseTokenFilter value)
	{
		return value;
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenFilter Reverse()
	{
		return Elastic.Clients.Elasticsearch.Analysis.ReverseTokenFilterDescriptor.Build(null);
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenFilter Reverse(System.Action<Elastic.Clients.Elasticsearch.Analysis.ReverseTokenFilterDescriptor>? action)
	{
		return Elastic.Clients.Elasticsearch.Analysis.ReverseTokenFilterDescriptor.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenFilter RussianStem(Elastic.Clients.Elasticsearch.Analysis.RussianStemTokenFilter value)
	{
		return value;
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenFilter RussianStem()
	{
		return Elastic.Clients.Elasticsearch.Analysis.RussianStemTokenFilterDescriptor.Build(null);
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenFilter RussianStem(System.Action<Elastic.Clients.Elasticsearch.Analysis.RussianStemTokenFilterDescriptor>? action)
	{
		return Elastic.Clients.Elasticsearch.Analysis.RussianStemTokenFilterDescriptor.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenFilter ScandinavianFolding(Elastic.Clients.Elasticsearch.Analysis.ScandinavianFoldingTokenFilter value)
	{
		return value;
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenFilter ScandinavianFolding()
	{
		return Elastic.Clients.Elasticsearch.Analysis.ScandinavianFoldingTokenFilterDescriptor.Build(null);
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenFilter ScandinavianFolding(System.Action<Elastic.Clients.Elasticsearch.Analysis.ScandinavianFoldingTokenFilterDescriptor>? action)
	{
		return Elastic.Clients.Elasticsearch.Analysis.ScandinavianFoldingTokenFilterDescriptor.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenFilter ScandinavianNormalization(Elastic.Clients.Elasticsearch.Analysis.ScandinavianNormalizationTokenFilter value)
	{
		return value;
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenFilter ScandinavianNormalization()
	{
		return Elastic.Clients.Elasticsearch.Analysis.ScandinavianNormalizationTokenFilterDescriptor.Build(null);
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenFilter ScandinavianNormalization(System.Action<Elastic.Clients.Elasticsearch.Analysis.ScandinavianNormalizationTokenFilterDescriptor>? action)
	{
		return Elastic.Clients.Elasticsearch.Analysis.ScandinavianNormalizationTokenFilterDescriptor.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenFilter SerbianNormalization(Elastic.Clients.Elasticsearch.Analysis.SerbianNormalizationTokenFilter value)
	{
		return value;
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenFilter SerbianNormalization()
	{
		return Elastic.Clients.Elasticsearch.Analysis.SerbianNormalizationTokenFilterDescriptor.Build(null);
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenFilter SerbianNormalization(System.Action<Elastic.Clients.Elasticsearch.Analysis.SerbianNormalizationTokenFilterDescriptor>? action)
	{
		return Elastic.Clients.Elasticsearch.Analysis.SerbianNormalizationTokenFilterDescriptor.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenFilter Shingle(Elastic.Clients.Elasticsearch.Analysis.ShingleTokenFilter value)
	{
		return value;
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenFilter Shingle()
	{
		return Elastic.Clients.Elasticsearch.Analysis.ShingleTokenFilterDescriptor.Build(null);
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenFilter Shingle(System.Action<Elastic.Clients.Elasticsearch.Analysis.ShingleTokenFilterDescriptor>? action)
	{
		return Elastic.Clients.Elasticsearch.Analysis.ShingleTokenFilterDescriptor.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenFilter Snowball(Elastic.Clients.Elasticsearch.Analysis.SnowballTokenFilter value)
	{
		return value;
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenFilter Snowball()
	{
		return Elastic.Clients.Elasticsearch.Analysis.SnowballTokenFilterDescriptor.Build(null);
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenFilter Snowball(System.Action<Elastic.Clients.Elasticsearch.Analysis.SnowballTokenFilterDescriptor>? action)
	{
		return Elastic.Clients.Elasticsearch.Analysis.SnowballTokenFilterDescriptor.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenFilter SoraniNormalization(Elastic.Clients.Elasticsearch.Analysis.SoraniNormalizationTokenFilter value)
	{
		return value;
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenFilter SoraniNormalization()
	{
		return Elastic.Clients.Elasticsearch.Analysis.SoraniNormalizationTokenFilterDescriptor.Build(null);
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenFilter SoraniNormalization(System.Action<Elastic.Clients.Elasticsearch.Analysis.SoraniNormalizationTokenFilterDescriptor>? action)
	{
		return Elastic.Clients.Elasticsearch.Analysis.SoraniNormalizationTokenFilterDescriptor.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenFilter Stemmer(Elastic.Clients.Elasticsearch.Analysis.StemmerTokenFilter value)
	{
		return value;
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenFilter Stemmer()
	{
		return Elastic.Clients.Elasticsearch.Analysis.StemmerTokenFilterDescriptor.Build(null);
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenFilter Stemmer(System.Action<Elastic.Clients.Elasticsearch.Analysis.StemmerTokenFilterDescriptor>? action)
	{
		return Elastic.Clients.Elasticsearch.Analysis.StemmerTokenFilterDescriptor.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenFilter StemmerOverride(Elastic.Clients.Elasticsearch.Analysis.StemmerOverrideTokenFilter value)
	{
		return value;
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenFilter StemmerOverride()
	{
		return Elastic.Clients.Elasticsearch.Analysis.StemmerOverrideTokenFilterDescriptor.Build(null);
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenFilter StemmerOverride(System.Action<Elastic.Clients.Elasticsearch.Analysis.StemmerOverrideTokenFilterDescriptor>? action)
	{
		return Elastic.Clients.Elasticsearch.Analysis.StemmerOverrideTokenFilterDescriptor.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenFilter Stop(Elastic.Clients.Elasticsearch.Analysis.StopTokenFilter value)
	{
		return value;
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenFilter Stop()
	{
		return Elastic.Clients.Elasticsearch.Analysis.StopTokenFilterDescriptor.Build(null);
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenFilter Stop(System.Action<Elastic.Clients.Elasticsearch.Analysis.StopTokenFilterDescriptor>? action)
	{
		return Elastic.Clients.Elasticsearch.Analysis.StopTokenFilterDescriptor.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenFilter Synonym(Elastic.Clients.Elasticsearch.Analysis.SynonymTokenFilter value)
	{
		return value;
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenFilter Synonym()
	{
		return Elastic.Clients.Elasticsearch.Analysis.SynonymTokenFilterDescriptor.Build(null);
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenFilter Synonym(System.Action<Elastic.Clients.Elasticsearch.Analysis.SynonymTokenFilterDescriptor>? action)
	{
		return Elastic.Clients.Elasticsearch.Analysis.SynonymTokenFilterDescriptor.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenFilter SynonymGraph(Elastic.Clients.Elasticsearch.Analysis.SynonymGraphTokenFilter value)
	{
		return value;
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenFilter SynonymGraph()
	{
		return Elastic.Clients.Elasticsearch.Analysis.SynonymGraphTokenFilterDescriptor.Build(null);
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenFilter SynonymGraph(System.Action<Elastic.Clients.Elasticsearch.Analysis.SynonymGraphTokenFilterDescriptor>? action)
	{
		return Elastic.Clients.Elasticsearch.Analysis.SynonymGraphTokenFilterDescriptor.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenFilter Trim(Elastic.Clients.Elasticsearch.Analysis.TrimTokenFilter value)
	{
		return value;
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenFilter Trim()
	{
		return Elastic.Clients.Elasticsearch.Analysis.TrimTokenFilterDescriptor.Build(null);
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenFilter Trim(System.Action<Elastic.Clients.Elasticsearch.Analysis.TrimTokenFilterDescriptor>? action)
	{
		return Elastic.Clients.Elasticsearch.Analysis.TrimTokenFilterDescriptor.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenFilter Truncate(Elastic.Clients.Elasticsearch.Analysis.TruncateTokenFilter value)
	{
		return value;
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenFilter Truncate()
	{
		return Elastic.Clients.Elasticsearch.Analysis.TruncateTokenFilterDescriptor.Build(null);
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenFilter Truncate(System.Action<Elastic.Clients.Elasticsearch.Analysis.TruncateTokenFilterDescriptor>? action)
	{
		return Elastic.Clients.Elasticsearch.Analysis.TruncateTokenFilterDescriptor.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenFilter Unique(Elastic.Clients.Elasticsearch.Analysis.UniqueTokenFilter value)
	{
		return value;
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenFilter Unique()
	{
		return Elastic.Clients.Elasticsearch.Analysis.UniqueTokenFilterDescriptor.Build(null);
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenFilter Unique(System.Action<Elastic.Clients.Elasticsearch.Analysis.UniqueTokenFilterDescriptor>? action)
	{
		return Elastic.Clients.Elasticsearch.Analysis.UniqueTokenFilterDescriptor.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenFilter Uppercase(Elastic.Clients.Elasticsearch.Analysis.UppercaseTokenFilter value)
	{
		return value;
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenFilter Uppercase()
	{
		return Elastic.Clients.Elasticsearch.Analysis.UppercaseTokenFilterDescriptor.Build(null);
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenFilter Uppercase(System.Action<Elastic.Clients.Elasticsearch.Analysis.UppercaseTokenFilterDescriptor>? action)
	{
		return Elastic.Clients.Elasticsearch.Analysis.UppercaseTokenFilterDescriptor.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenFilter WordDelimiter(Elastic.Clients.Elasticsearch.Analysis.WordDelimiterTokenFilter value)
	{
		return value;
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenFilter WordDelimiter()
	{
		return Elastic.Clients.Elasticsearch.Analysis.WordDelimiterTokenFilterDescriptor.Build(null);
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenFilter WordDelimiter(System.Action<Elastic.Clients.Elasticsearch.Analysis.WordDelimiterTokenFilterDescriptor>? action)
	{
		return Elastic.Clients.Elasticsearch.Analysis.WordDelimiterTokenFilterDescriptor.Build(action);
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenFilter WordDelimiterGraph(Elastic.Clients.Elasticsearch.Analysis.WordDelimiterGraphTokenFilter value)
	{
		return value;
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenFilter WordDelimiterGraph()
	{
		return Elastic.Clients.Elasticsearch.Analysis.WordDelimiterGraphTokenFilterDescriptor.Build(null);
	}

	public Elastic.Clients.Elasticsearch.Analysis.ITokenFilter WordDelimiterGraph(System.Action<Elastic.Clients.Elasticsearch.Analysis.WordDelimiterGraphTokenFilterDescriptor>? action)
	{
		return Elastic.Clients.Elasticsearch.Analysis.WordDelimiterGraphTokenFilterDescriptor.Build(action);
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Analysis.ITokenFilter Build(System.Func<Elastic.Clients.Elasticsearch.Analysis.TokenFilterFactory, Elastic.Clients.Elasticsearch.Analysis.ITokenFilter> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Analysis.TokenFilterFactory();
		return action.Invoke(builder);
	}
}