// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Analysis.Json;

public sealed partial class ITokenFilterConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.Analysis.ITokenFilter>
{
	private static readonly System.Text.Json.JsonEncodedText PropDiscriminator = System.Text.Json.JsonEncodedText.Encode("type");

	public override Elastic.Clients.Elasticsearch.Analysis.ITokenFilter Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		reader.ValidateToken(System.Text.Json.JsonTokenType.StartObject);
		var readerSnapshot = reader;
		string? discriminator = null;
		while (reader.Read() && reader.TokenType is System.Text.Json.JsonTokenType.PropertyName)
		{
			if (reader.TryReadProperty(options, PropDiscriminator, ref discriminator, null))
			{
				break;
			}

			reader.SafeSkip();
		}

		reader = readerSnapshot;
		return discriminator switch
		{
			"apostrophe" => reader.ReadValue<Elastic.Clients.Elasticsearch.Analysis.ApostropheTokenFilter>(options, null),
			"arabic_normalization" => reader.ReadValue<Elastic.Clients.Elasticsearch.Analysis.ArabicNormalizationTokenFilter>(options, null),
			"arabic_stem" => reader.ReadValue<Elastic.Clients.Elasticsearch.Analysis.ArabicStemTokenFilter>(options, null),
			"asciifolding" => reader.ReadValue<Elastic.Clients.Elasticsearch.Analysis.AsciiFoldingTokenFilter>(options, null),
			"bengali_normalization" => reader.ReadValue<Elastic.Clients.Elasticsearch.Analysis.BengaliNormalizationTokenFilter>(options, null),
			"brazilian_stem" => reader.ReadValue<Elastic.Clients.Elasticsearch.Analysis.BrazilianStemTokenFilter>(options, null),
			"cjk_bigram" => reader.ReadValue<Elastic.Clients.Elasticsearch.Analysis.CjkBigramTokenFilter>(options, null),
			"cjk_width" => reader.ReadValue<Elastic.Clients.Elasticsearch.Analysis.CjkWidthTokenFilter>(options, null),
			"classic" => reader.ReadValue<Elastic.Clients.Elasticsearch.Analysis.ClassicTokenFilter>(options, null),
			"common_grams" => reader.ReadValue<Elastic.Clients.Elasticsearch.Analysis.CommonGramsTokenFilter>(options, null),
			"condition" => reader.ReadValue<Elastic.Clients.Elasticsearch.Analysis.ConditionTokenFilter>(options, null),
			"czech_stem" => reader.ReadValue<Elastic.Clients.Elasticsearch.Analysis.CzechStemTokenFilter>(options, null),
			"decimal_digit" => reader.ReadValue<Elastic.Clients.Elasticsearch.Analysis.DecimalDigitTokenFilter>(options, null),
			"delimited_payload" => reader.ReadValue<Elastic.Clients.Elasticsearch.Analysis.DelimitedPayloadTokenFilter>(options, null),
			"dictionary_decompounder" => reader.ReadValue<Elastic.Clients.Elasticsearch.Analysis.DictionaryDecompounderTokenFilter>(options, null),
			"dutch_stem" => reader.ReadValue<Elastic.Clients.Elasticsearch.Analysis.DutchStemTokenFilter>(options, null),
			"edge_ngram" => reader.ReadValue<Elastic.Clients.Elasticsearch.Analysis.EdgeNGramTokenFilter>(options, null),
			"elision" => reader.ReadValue<Elastic.Clients.Elasticsearch.Analysis.ElisionTokenFilter>(options, null),
			"fingerprint" => reader.ReadValue<Elastic.Clients.Elasticsearch.Analysis.FingerprintTokenFilter>(options, null),
			"flatten_graph" => reader.ReadValue<Elastic.Clients.Elasticsearch.Analysis.FlattenGraphTokenFilter>(options, null),
			"french_stem" => reader.ReadValue<Elastic.Clients.Elasticsearch.Analysis.FrenchStemTokenFilter>(options, null),
			"german_normalization" => reader.ReadValue<Elastic.Clients.Elasticsearch.Analysis.GermanNormalizationTokenFilter>(options, null),
			"german_stem" => reader.ReadValue<Elastic.Clients.Elasticsearch.Analysis.GermanStemTokenFilter>(options, null),
			"hindi_normalization" => reader.ReadValue<Elastic.Clients.Elasticsearch.Analysis.HindiNormalizationTokenFilter>(options, null),
			"hunspell" => reader.ReadValue<Elastic.Clients.Elasticsearch.Analysis.HunspellTokenFilter>(options, null),
			"hyphenation_decompounder" => reader.ReadValue<Elastic.Clients.Elasticsearch.Analysis.HyphenationDecompounderTokenFilter>(options, null),
			"icu_collation" => reader.ReadValue<Elastic.Clients.Elasticsearch.Analysis.IcuCollationTokenFilter>(options, null),
			"icu_folding" => reader.ReadValue<Elastic.Clients.Elasticsearch.Analysis.IcuFoldingTokenFilter>(options, null),
			"icu_normalizer" => reader.ReadValue<Elastic.Clients.Elasticsearch.Analysis.IcuNormalizationTokenFilter>(options, null),
			"icu_transform" => reader.ReadValue<Elastic.Clients.Elasticsearch.Analysis.IcuTransformTokenFilter>(options, null),
			"indic_normalization" => reader.ReadValue<Elastic.Clients.Elasticsearch.Analysis.IndicNormalizationTokenFilter>(options, null),
			"ja_stop" => reader.ReadValue<Elastic.Clients.Elasticsearch.Analysis.JaStopTokenFilter>(options, null),
			"keep" => reader.ReadValue<Elastic.Clients.Elasticsearch.Analysis.KeepWordsTokenFilter>(options, null),
			"keep_types" => reader.ReadValue<Elastic.Clients.Elasticsearch.Analysis.KeepTypesTokenFilter>(options, null),
			"keyword_marker" => reader.ReadValue<Elastic.Clients.Elasticsearch.Analysis.KeywordMarkerTokenFilter>(options, null),
			"keyword_repeat" => reader.ReadValue<Elastic.Clients.Elasticsearch.Analysis.KeywordRepeatTokenFilter>(options, null),
			"kstem" => reader.ReadValue<Elastic.Clients.Elasticsearch.Analysis.KStemTokenFilter>(options, null),
			"kuromoji_part_of_speech" => reader.ReadValue<Elastic.Clients.Elasticsearch.Analysis.KuromojiPartOfSpeechTokenFilter>(options, null),
			"kuromoji_readingform" => reader.ReadValue<Elastic.Clients.Elasticsearch.Analysis.KuromojiReadingFormTokenFilter>(options, null),
			"kuromoji_stemmer" => reader.ReadValue<Elastic.Clients.Elasticsearch.Analysis.KuromojiStemmerTokenFilter>(options, null),
			"length" => reader.ReadValue<Elastic.Clients.Elasticsearch.Analysis.LengthTokenFilter>(options, null),
			"limit" => reader.ReadValue<Elastic.Clients.Elasticsearch.Analysis.LimitTokenCountTokenFilter>(options, null),
			"lowercase" => reader.ReadValue<Elastic.Clients.Elasticsearch.Analysis.LowercaseTokenFilter>(options, null),
			"min_hash" => reader.ReadValue<Elastic.Clients.Elasticsearch.Analysis.MinHashTokenFilter>(options, null),
			"multiplexer" => reader.ReadValue<Elastic.Clients.Elasticsearch.Analysis.MultiplexerTokenFilter>(options, null),
			"ngram" => reader.ReadValue<Elastic.Clients.Elasticsearch.Analysis.NGramTokenFilter>(options, null),
			"nori_part_of_speech" => reader.ReadValue<Elastic.Clients.Elasticsearch.Analysis.NoriPartOfSpeechTokenFilter>(options, null),
			"pattern_capture" => reader.ReadValue<Elastic.Clients.Elasticsearch.Analysis.PatternCaptureTokenFilter>(options, null),
			"pattern_replace" => reader.ReadValue<Elastic.Clients.Elasticsearch.Analysis.PatternReplaceTokenFilter>(options, null),
			"persian_normalization" => reader.ReadValue<Elastic.Clients.Elasticsearch.Analysis.PersianNormalizationTokenFilter>(options, null),
			"persian_stem" => reader.ReadValue<Elastic.Clients.Elasticsearch.Analysis.PersianStemTokenFilter>(options, null),
			"phonetic" => reader.ReadValue<Elastic.Clients.Elasticsearch.Analysis.PhoneticTokenFilter>(options, null),
			"porter_stem" => reader.ReadValue<Elastic.Clients.Elasticsearch.Analysis.PorterStemTokenFilter>(options, null),
			"predicate_token_filter" => reader.ReadValue<Elastic.Clients.Elasticsearch.Analysis.PredicateTokenFilter>(options, null),
			"remove_duplicates" => reader.ReadValue<Elastic.Clients.Elasticsearch.Analysis.RemoveDuplicatesTokenFilter>(options, null),
			"reverse" => reader.ReadValue<Elastic.Clients.Elasticsearch.Analysis.ReverseTokenFilter>(options, null),
			"russian_stem" => reader.ReadValue<Elastic.Clients.Elasticsearch.Analysis.RussianStemTokenFilter>(options, null),
			"scandinavian_folding" => reader.ReadValue<Elastic.Clients.Elasticsearch.Analysis.ScandinavianFoldingTokenFilter>(options, null),
			"scandinavian_normalization" => reader.ReadValue<Elastic.Clients.Elasticsearch.Analysis.ScandinavianNormalizationTokenFilter>(options, null),
			"serbian_normalization" => reader.ReadValue<Elastic.Clients.Elasticsearch.Analysis.SerbianNormalizationTokenFilter>(options, null),
			"shingle" => reader.ReadValue<Elastic.Clients.Elasticsearch.Analysis.ShingleTokenFilter>(options, null),
			"snowball" => reader.ReadValue<Elastic.Clients.Elasticsearch.Analysis.SnowballTokenFilter>(options, null),
			"sorani_normalization" => reader.ReadValue<Elastic.Clients.Elasticsearch.Analysis.SoraniNormalizationTokenFilter>(options, null),
			"stemmer" => reader.ReadValue<Elastic.Clients.Elasticsearch.Analysis.StemmerTokenFilter>(options, null),
			"stemmer_override" => reader.ReadValue<Elastic.Clients.Elasticsearch.Analysis.StemmerOverrideTokenFilter>(options, null),
			"stop" => reader.ReadValue<Elastic.Clients.Elasticsearch.Analysis.StopTokenFilter>(options, null),
			"synonym" => reader.ReadValue<Elastic.Clients.Elasticsearch.Analysis.SynonymTokenFilter>(options, null),
			"synonym_graph" => reader.ReadValue<Elastic.Clients.Elasticsearch.Analysis.SynonymGraphTokenFilter>(options, null),
			"trim" => reader.ReadValue<Elastic.Clients.Elasticsearch.Analysis.TrimTokenFilter>(options, null),
			"truncate" => reader.ReadValue<Elastic.Clients.Elasticsearch.Analysis.TruncateTokenFilter>(options, null),
			"unique" => reader.ReadValue<Elastic.Clients.Elasticsearch.Analysis.UniqueTokenFilter>(options, null),
			"uppercase" => reader.ReadValue<Elastic.Clients.Elasticsearch.Analysis.UppercaseTokenFilter>(options, null),
			"word_delimiter" => reader.ReadValue<Elastic.Clients.Elasticsearch.Analysis.WordDelimiterTokenFilter>(options, null),
			"word_delimiter_graph" => reader.ReadValue<Elastic.Clients.Elasticsearch.Analysis.WordDelimiterGraphTokenFilter>(options, null),
			_ => throw new System.Text.Json.JsonException($"Variant '{discriminator}' is not supported for type '{nameof(Elastic.Clients.Elasticsearch.Analysis.ITokenFilter)}'.")
		};
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Analysis.ITokenFilter value, System.Text.Json.JsonSerializerOptions options)
	{
		switch (value.Type)
		{
			case "apostrophe":
				writer.WriteValue(options, (Elastic.Clients.Elasticsearch.Analysis.ApostropheTokenFilter)value, null);
				break;
			case "arabic_normalization":
				writer.WriteValue(options, (Elastic.Clients.Elasticsearch.Analysis.ArabicNormalizationTokenFilter)value, null);
				break;
			case "arabic_stem":
				writer.WriteValue(options, (Elastic.Clients.Elasticsearch.Analysis.ArabicStemTokenFilter)value, null);
				break;
			case "asciifolding":
				writer.WriteValue(options, (Elastic.Clients.Elasticsearch.Analysis.AsciiFoldingTokenFilter)value, null);
				break;
			case "bengali_normalization":
				writer.WriteValue(options, (Elastic.Clients.Elasticsearch.Analysis.BengaliNormalizationTokenFilter)value, null);
				break;
			case "brazilian_stem":
				writer.WriteValue(options, (Elastic.Clients.Elasticsearch.Analysis.BrazilianStemTokenFilter)value, null);
				break;
			case "cjk_bigram":
				writer.WriteValue(options, (Elastic.Clients.Elasticsearch.Analysis.CjkBigramTokenFilter)value, null);
				break;
			case "cjk_width":
				writer.WriteValue(options, (Elastic.Clients.Elasticsearch.Analysis.CjkWidthTokenFilter)value, null);
				break;
			case "classic":
				writer.WriteValue(options, (Elastic.Clients.Elasticsearch.Analysis.ClassicTokenFilter)value, null);
				break;
			case "common_grams":
				writer.WriteValue(options, (Elastic.Clients.Elasticsearch.Analysis.CommonGramsTokenFilter)value, null);
				break;
			case "condition":
				writer.WriteValue(options, (Elastic.Clients.Elasticsearch.Analysis.ConditionTokenFilter)value, null);
				break;
			case "czech_stem":
				writer.WriteValue(options, (Elastic.Clients.Elasticsearch.Analysis.CzechStemTokenFilter)value, null);
				break;
			case "decimal_digit":
				writer.WriteValue(options, (Elastic.Clients.Elasticsearch.Analysis.DecimalDigitTokenFilter)value, null);
				break;
			case "delimited_payload":
				writer.WriteValue(options, (Elastic.Clients.Elasticsearch.Analysis.DelimitedPayloadTokenFilter)value, null);
				break;
			case "dictionary_decompounder":
				writer.WriteValue(options, (Elastic.Clients.Elasticsearch.Analysis.DictionaryDecompounderTokenFilter)value, null);
				break;
			case "dutch_stem":
				writer.WriteValue(options, (Elastic.Clients.Elasticsearch.Analysis.DutchStemTokenFilter)value, null);
				break;
			case "edge_ngram":
				writer.WriteValue(options, (Elastic.Clients.Elasticsearch.Analysis.EdgeNGramTokenFilter)value, null);
				break;
			case "elision":
				writer.WriteValue(options, (Elastic.Clients.Elasticsearch.Analysis.ElisionTokenFilter)value, null);
				break;
			case "fingerprint":
				writer.WriteValue(options, (Elastic.Clients.Elasticsearch.Analysis.FingerprintTokenFilter)value, null);
				break;
			case "flatten_graph":
				writer.WriteValue(options, (Elastic.Clients.Elasticsearch.Analysis.FlattenGraphTokenFilter)value, null);
				break;
			case "french_stem":
				writer.WriteValue(options, (Elastic.Clients.Elasticsearch.Analysis.FrenchStemTokenFilter)value, null);
				break;
			case "german_normalization":
				writer.WriteValue(options, (Elastic.Clients.Elasticsearch.Analysis.GermanNormalizationTokenFilter)value, null);
				break;
			case "german_stem":
				writer.WriteValue(options, (Elastic.Clients.Elasticsearch.Analysis.GermanStemTokenFilter)value, null);
				break;
			case "hindi_normalization":
				writer.WriteValue(options, (Elastic.Clients.Elasticsearch.Analysis.HindiNormalizationTokenFilter)value, null);
				break;
			case "hunspell":
				writer.WriteValue(options, (Elastic.Clients.Elasticsearch.Analysis.HunspellTokenFilter)value, null);
				break;
			case "hyphenation_decompounder":
				writer.WriteValue(options, (Elastic.Clients.Elasticsearch.Analysis.HyphenationDecompounderTokenFilter)value, null);
				break;
			case "icu_collation":
				writer.WriteValue(options, (Elastic.Clients.Elasticsearch.Analysis.IcuCollationTokenFilter)value, null);
				break;
			case "icu_folding":
				writer.WriteValue(options, (Elastic.Clients.Elasticsearch.Analysis.IcuFoldingTokenFilter)value, null);
				break;
			case "icu_normalizer":
				writer.WriteValue(options, (Elastic.Clients.Elasticsearch.Analysis.IcuNormalizationTokenFilter)value, null);
				break;
			case "icu_transform":
				writer.WriteValue(options, (Elastic.Clients.Elasticsearch.Analysis.IcuTransformTokenFilter)value, null);
				break;
			case "indic_normalization":
				writer.WriteValue(options, (Elastic.Clients.Elasticsearch.Analysis.IndicNormalizationTokenFilter)value, null);
				break;
			case "ja_stop":
				writer.WriteValue(options, (Elastic.Clients.Elasticsearch.Analysis.JaStopTokenFilter)value, null);
				break;
			case "keep":
				writer.WriteValue(options, (Elastic.Clients.Elasticsearch.Analysis.KeepWordsTokenFilter)value, null);
				break;
			case "keep_types":
				writer.WriteValue(options, (Elastic.Clients.Elasticsearch.Analysis.KeepTypesTokenFilter)value, null);
				break;
			case "keyword_marker":
				writer.WriteValue(options, (Elastic.Clients.Elasticsearch.Analysis.KeywordMarkerTokenFilter)value, null);
				break;
			case "keyword_repeat":
				writer.WriteValue(options, (Elastic.Clients.Elasticsearch.Analysis.KeywordRepeatTokenFilter)value, null);
				break;
			case "kstem":
				writer.WriteValue(options, (Elastic.Clients.Elasticsearch.Analysis.KStemTokenFilter)value, null);
				break;
			case "kuromoji_part_of_speech":
				writer.WriteValue(options, (Elastic.Clients.Elasticsearch.Analysis.KuromojiPartOfSpeechTokenFilter)value, null);
				break;
			case "kuromoji_readingform":
				writer.WriteValue(options, (Elastic.Clients.Elasticsearch.Analysis.KuromojiReadingFormTokenFilter)value, null);
				break;
			case "kuromoji_stemmer":
				writer.WriteValue(options, (Elastic.Clients.Elasticsearch.Analysis.KuromojiStemmerTokenFilter)value, null);
				break;
			case "length":
				writer.WriteValue(options, (Elastic.Clients.Elasticsearch.Analysis.LengthTokenFilter)value, null);
				break;
			case "limit":
				writer.WriteValue(options, (Elastic.Clients.Elasticsearch.Analysis.LimitTokenCountTokenFilter)value, null);
				break;
			case "lowercase":
				writer.WriteValue(options, (Elastic.Clients.Elasticsearch.Analysis.LowercaseTokenFilter)value, null);
				break;
			case "min_hash":
				writer.WriteValue(options, (Elastic.Clients.Elasticsearch.Analysis.MinHashTokenFilter)value, null);
				break;
			case "multiplexer":
				writer.WriteValue(options, (Elastic.Clients.Elasticsearch.Analysis.MultiplexerTokenFilter)value, null);
				break;
			case "ngram":
				writer.WriteValue(options, (Elastic.Clients.Elasticsearch.Analysis.NGramTokenFilter)value, null);
				break;
			case "nori_part_of_speech":
				writer.WriteValue(options, (Elastic.Clients.Elasticsearch.Analysis.NoriPartOfSpeechTokenFilter)value, null);
				break;
			case "pattern_capture":
				writer.WriteValue(options, (Elastic.Clients.Elasticsearch.Analysis.PatternCaptureTokenFilter)value, null);
				break;
			case "pattern_replace":
				writer.WriteValue(options, (Elastic.Clients.Elasticsearch.Analysis.PatternReplaceTokenFilter)value, null);
				break;
			case "persian_normalization":
				writer.WriteValue(options, (Elastic.Clients.Elasticsearch.Analysis.PersianNormalizationTokenFilter)value, null);
				break;
			case "persian_stem":
				writer.WriteValue(options, (Elastic.Clients.Elasticsearch.Analysis.PersianStemTokenFilter)value, null);
				break;
			case "phonetic":
				writer.WriteValue(options, (Elastic.Clients.Elasticsearch.Analysis.PhoneticTokenFilter)value, null);
				break;
			case "porter_stem":
				writer.WriteValue(options, (Elastic.Clients.Elasticsearch.Analysis.PorterStemTokenFilter)value, null);
				break;
			case "predicate_token_filter":
				writer.WriteValue(options, (Elastic.Clients.Elasticsearch.Analysis.PredicateTokenFilter)value, null);
				break;
			case "remove_duplicates":
				writer.WriteValue(options, (Elastic.Clients.Elasticsearch.Analysis.RemoveDuplicatesTokenFilter)value, null);
				break;
			case "reverse":
				writer.WriteValue(options, (Elastic.Clients.Elasticsearch.Analysis.ReverseTokenFilter)value, null);
				break;
			case "russian_stem":
				writer.WriteValue(options, (Elastic.Clients.Elasticsearch.Analysis.RussianStemTokenFilter)value, null);
				break;
			case "scandinavian_folding":
				writer.WriteValue(options, (Elastic.Clients.Elasticsearch.Analysis.ScandinavianFoldingTokenFilter)value, null);
				break;
			case "scandinavian_normalization":
				writer.WriteValue(options, (Elastic.Clients.Elasticsearch.Analysis.ScandinavianNormalizationTokenFilter)value, null);
				break;
			case "serbian_normalization":
				writer.WriteValue(options, (Elastic.Clients.Elasticsearch.Analysis.SerbianNormalizationTokenFilter)value, null);
				break;
			case "shingle":
				writer.WriteValue(options, (Elastic.Clients.Elasticsearch.Analysis.ShingleTokenFilter)value, null);
				break;
			case "snowball":
				writer.WriteValue(options, (Elastic.Clients.Elasticsearch.Analysis.SnowballTokenFilter)value, null);
				break;
			case "sorani_normalization":
				writer.WriteValue(options, (Elastic.Clients.Elasticsearch.Analysis.SoraniNormalizationTokenFilter)value, null);
				break;
			case "stemmer":
				writer.WriteValue(options, (Elastic.Clients.Elasticsearch.Analysis.StemmerTokenFilter)value, null);
				break;
			case "stemmer_override":
				writer.WriteValue(options, (Elastic.Clients.Elasticsearch.Analysis.StemmerOverrideTokenFilter)value, null);
				break;
			case "stop":
				writer.WriteValue(options, (Elastic.Clients.Elasticsearch.Analysis.StopTokenFilter)value, null);
				break;
			case "synonym":
				writer.WriteValue(options, (Elastic.Clients.Elasticsearch.Analysis.SynonymTokenFilter)value, null);
				break;
			case "synonym_graph":
				writer.WriteValue(options, (Elastic.Clients.Elasticsearch.Analysis.SynonymGraphTokenFilter)value, null);
				break;
			case "trim":
				writer.WriteValue(options, (Elastic.Clients.Elasticsearch.Analysis.TrimTokenFilter)value, null);
				break;
			case "truncate":
				writer.WriteValue(options, (Elastic.Clients.Elasticsearch.Analysis.TruncateTokenFilter)value, null);
				break;
			case "unique":
				writer.WriteValue(options, (Elastic.Clients.Elasticsearch.Analysis.UniqueTokenFilter)value, null);
				break;
			case "uppercase":
				writer.WriteValue(options, (Elastic.Clients.Elasticsearch.Analysis.UppercaseTokenFilter)value, null);
				break;
			case "word_delimiter":
				writer.WriteValue(options, (Elastic.Clients.Elasticsearch.Analysis.WordDelimiterTokenFilter)value, null);
				break;
			case "word_delimiter_graph":
				writer.WriteValue(options, (Elastic.Clients.Elasticsearch.Analysis.WordDelimiterGraphTokenFilter)value, null);
				break;
			default:
				throw new System.Text.Json.JsonException($"Variant '{value.Type}' is not supported for type '{nameof(Elastic.Clients.Elasticsearch.Analysis.ITokenFilter)}'.");
		}
	}
}