// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Analysis.Json;

public sealed partial class TokenCharConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.Analysis.TokenChar>
{
	private static readonly System.Text.Json.JsonEncodedText MemberCustom = System.Text.Json.JsonEncodedText.Encode("custom");
	private static readonly System.Text.Json.JsonEncodedText MemberDigit = System.Text.Json.JsonEncodedText.Encode("digit");
	private static readonly System.Text.Json.JsonEncodedText MemberLetter = System.Text.Json.JsonEncodedText.Encode("letter");
	private static readonly System.Text.Json.JsonEncodedText MemberPunctuation = System.Text.Json.JsonEncodedText.Encode("punctuation");
	private static readonly System.Text.Json.JsonEncodedText MemberSymbol = System.Text.Json.JsonEncodedText.Encode("symbol");
	private static readonly System.Text.Json.JsonEncodedText MemberWhitespace = System.Text.Json.JsonEncodedText.Encode("whitespace");

	public override Elastic.Clients.Elasticsearch.Analysis.TokenChar Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		if (reader.ValueTextEquals(MemberCustom))
		{
			return Elastic.Clients.Elasticsearch.Analysis.TokenChar.Custom;
		}

		if (reader.ValueTextEquals(MemberDigit))
		{
			return Elastic.Clients.Elasticsearch.Analysis.TokenChar.Digit;
		}

		if (reader.ValueTextEquals(MemberLetter))
		{
			return Elastic.Clients.Elasticsearch.Analysis.TokenChar.Letter;
		}

		if (reader.ValueTextEquals(MemberPunctuation))
		{
			return Elastic.Clients.Elasticsearch.Analysis.TokenChar.Punctuation;
		}

		if (reader.ValueTextEquals(MemberSymbol))
		{
			return Elastic.Clients.Elasticsearch.Analysis.TokenChar.Symbol;
		}

		if (reader.ValueTextEquals(MemberWhitespace))
		{
			return Elastic.Clients.Elasticsearch.Analysis.TokenChar.Whitespace;
		}

		var value = reader.GetString()!;
		if (string.Equals(value, MemberCustom.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Analysis.TokenChar.Custom;
		}

		if (string.Equals(value, MemberDigit.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Analysis.TokenChar.Digit;
		}

		if (string.Equals(value, MemberLetter.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Analysis.TokenChar.Letter;
		}

		if (string.Equals(value, MemberPunctuation.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Analysis.TokenChar.Punctuation;
		}

		if (string.Equals(value, MemberSymbol.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Analysis.TokenChar.Symbol;
		}

		if (string.Equals(value, MemberWhitespace.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Analysis.TokenChar.Whitespace;
		}

		throw new System.Text.Json.JsonException($"Unknown member '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.Analysis.TokenChar)}'.");
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Analysis.TokenChar value, System.Text.Json.JsonSerializerOptions options)
	{
		switch (value)
		{
			case Elastic.Clients.Elasticsearch.Analysis.TokenChar.Custom:
				writer.WriteStringValue(MemberCustom);
				break;
			case Elastic.Clients.Elasticsearch.Analysis.TokenChar.Digit:
				writer.WriteStringValue(MemberDigit);
				break;
			case Elastic.Clients.Elasticsearch.Analysis.TokenChar.Letter:
				writer.WriteStringValue(MemberLetter);
				break;
			case Elastic.Clients.Elasticsearch.Analysis.TokenChar.Punctuation:
				writer.WriteStringValue(MemberPunctuation);
				break;
			case Elastic.Clients.Elasticsearch.Analysis.TokenChar.Symbol:
				writer.WriteStringValue(MemberSymbol);
				break;
			case Elastic.Clients.Elasticsearch.Analysis.TokenChar.Whitespace:
				writer.WriteStringValue(MemberWhitespace);
				break;
			default:
				throw new System.Text.Json.JsonException($"Invalid value '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.Analysis.TokenChar)}'.");
		}
	}

	public override Elastic.Clients.Elasticsearch.Analysis.TokenChar ReadAsPropertyName(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		return Read(ref reader, typeToConvert, options);
	}

	public override void WriteAsPropertyName(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Analysis.TokenChar value, System.Text.Json.JsonSerializerOptions options)
	{
		Write(writer, value, options);
	}
}